// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["FusedAddHalving.Vector64.Int16"] = FusedAddHalving_Vector64_Int16,
                ["FusedAddHalving.Vector64.Int32"] = FusedAddHalving_Vector64_Int32,
                ["FusedAddHalving.Vector64.SByte"] = FusedAddHalving_Vector64_SByte,
                ["FusedAddHalving.Vector64.UInt16"] = FusedAddHalving_Vector64_UInt16,
                ["FusedAddHalving.Vector64.UInt32"] = FusedAddHalving_Vector64_UInt32,
                ["FusedAddHalving.Vector128.Byte"] = FusedAddHalving_Vector128_Byte,
                ["FusedAddHalving.Vector128.Int16"] = FusedAddHalving_Vector128_Int16,
                ["FusedAddHalving.Vector128.Int32"] = FusedAddHalving_Vector128_Int32,
                ["FusedAddHalving.Vector128.SByte"] = FusedAddHalving_Vector128_SByte,
                ["FusedAddHalving.Vector128.UInt16"] = FusedAddHalving_Vector128_UInt16,
                ["FusedAddHalving.Vector128.UInt32"] = FusedAddHalving_Vector128_UInt32,
                ["FusedAddRoundedHalving.Vector64.Byte"] = FusedAddRoundedHalving_Vector64_Byte,
                ["FusedAddRoundedHalving.Vector64.Int16"] = FusedAddRoundedHalving_Vector64_Int16,
                ["FusedAddRoundedHalving.Vector64.Int32"] = FusedAddRoundedHalving_Vector64_Int32,
                ["FusedAddRoundedHalving.Vector64.SByte"] = FusedAddRoundedHalving_Vector64_SByte,
                ["FusedAddRoundedHalving.Vector64.UInt16"] = FusedAddRoundedHalving_Vector64_UInt16,
                ["FusedAddRoundedHalving.Vector64.UInt32"] = FusedAddRoundedHalving_Vector64_UInt32,
                ["FusedAddRoundedHalving.Vector128.Byte"] = FusedAddRoundedHalving_Vector128_Byte,
                ["FusedAddRoundedHalving.Vector128.Int16"] = FusedAddRoundedHalving_Vector128_Int16,
                ["FusedAddRoundedHalving.Vector128.Int32"] = FusedAddRoundedHalving_Vector128_Int32,
                ["FusedAddRoundedHalving.Vector128.SByte"] = FusedAddRoundedHalving_Vector128_SByte,
                ["FusedAddRoundedHalving.Vector128.UInt16"] = FusedAddRoundedHalving_Vector128_UInt16,
                ["FusedAddRoundedHalving.Vector128.UInt32"] = FusedAddRoundedHalving_Vector128_UInt32,
                ["FusedMultiplyAdd.Vector64.Single"] = FusedMultiplyAdd_Vector64_Single,
                ["FusedMultiplyAdd.Vector128.Single"] = FusedMultiplyAdd_Vector128_Single,
                ["FusedMultiplyAddScalar.Vector64.Double"] = FusedMultiplyAddScalar_Vector64_Double,
                ["FusedMultiplyAddScalar.Vector64.Single"] = FusedMultiplyAddScalar_Vector64_Single,
                ["FusedMultiplyAddNegatedScalar.Vector64.Double"] = FusedMultiplyAddNegatedScalar_Vector64_Double,
                ["FusedMultiplyAddNegatedScalar.Vector64.Single"] = FusedMultiplyAddNegatedScalar_Vector64_Single,
                ["FusedMultiplySubtract.Vector64.Single"] = FusedMultiplySubtract_Vector64_Single,
                ["FusedMultiplySubtract.Vector128.Single"] = FusedMultiplySubtract_Vector128_Single,
                ["FusedMultiplySubtractScalar.Vector64.Double"] = FusedMultiplySubtractScalar_Vector64_Double,
                ["FusedMultiplySubtractScalar.Vector64.Single"] = FusedMultiplySubtractScalar_Vector64_Single,
                ["FusedMultiplySubtractNegatedScalar.Vector64.Double"] = FusedMultiplySubtractNegatedScalar_Vector64_Double,
                ["FusedMultiplySubtractNegatedScalar.Vector64.Single"] = FusedMultiplySubtractNegatedScalar_Vector64_Single,
                ["FusedSubtractHalving.Vector64.Byte"] = FusedSubtractHalving_Vector64_Byte,
                ["FusedSubtractHalving.Vector64.Int16"] = FusedSubtractHalving_Vector64_Int16,
                ["FusedSubtractHalving.Vector64.Int32"] = FusedSubtractHalving_Vector64_Int32,
                ["FusedSubtractHalving.Vector64.SByte"] = FusedSubtractHalving_Vector64_SByte,
                ["FusedSubtractHalving.Vector64.UInt16"] = FusedSubtractHalving_Vector64_UInt16,
                ["FusedSubtractHalving.Vector64.UInt32"] = FusedSubtractHalving_Vector64_UInt32,
                ["FusedSubtractHalving.Vector128.Byte"] = FusedSubtractHalving_Vector128_Byte,
                ["FusedSubtractHalving.Vector128.Int16"] = FusedSubtractHalving_Vector128_Int16,
                ["FusedSubtractHalving.Vector128.Int32"] = FusedSubtractHalving_Vector128_Int32,
                ["FusedSubtractHalving.Vector128.SByte"] = FusedSubtractHalving_Vector128_SByte,
                ["FusedSubtractHalving.Vector128.UInt16"] = FusedSubtractHalving_Vector128_UInt16,
                ["FusedSubtractHalving.Vector128.UInt32"] = FusedSubtractHalving_Vector128_UInt32,
                ["Insert.Vector64.Byte.1"] = Insert_Vector64_Byte_1,
                ["Insert.Vector64.Int16.1"] = Insert_Vector64_Int16_1,
                ["Insert.Vector64.Int32.1"] = Insert_Vector64_Int32_1,
                ["Insert.Vector64.SByte.1"] = Insert_Vector64_SByte_1,
                ["Insert.Vector64.Single.1"] = Insert_Vector64_Single_1,
                ["Insert.Vector64.UInt16.1"] = Insert_Vector64_UInt16_1,
                ["Insert.Vector64.UInt32.1"] = Insert_Vector64_UInt32_1,
                ["Insert.Vector128.Byte.1"] = Insert_Vector128_Byte_1,
                ["Insert.Vector128.Double.1"] = Insert_Vector128_Double_1,
                ["Insert.Vector128.Int16.1"] = Insert_Vector128_Int16_1,
                ["Insert.Vector128.Int32.1"] = Insert_Vector128_Int32_1,
                ["Insert.Vector128.Int64.1"] = Insert_Vector128_Int64_1,
                ["Insert.Vector128.SByte.1"] = Insert_Vector128_SByte_1,
                ["Insert.Vector128.Single.1"] = Insert_Vector128_Single_1,
                ["Insert.Vector128.UInt16.1"] = Insert_Vector128_UInt16_1,
                ["Insert.Vector128.UInt32.1"] = Insert_Vector128_UInt32_1,
                ["Insert.Vector128.UInt64.1"] = Insert_Vector128_UInt64_1,
                ["InsertScalar.Vector128.Double.1"] = InsertScalar_Vector128_Double_1,
                ["InsertScalar.Vector128.Int64.1"] = InsertScalar_Vector128_Int64_1,
                ["InsertScalar.Vector128.UInt64.1"] = InsertScalar_Vector128_UInt64_1,
                ["LeadingSignCount.Vector64.Int16"] = LeadingSignCount_Vector64_Int16,
                ["LeadingSignCount.Vector64.Int32"] = LeadingSignCount_Vector64_Int32,
                ["LeadingSignCount.Vector64.SByte"] = LeadingSignCount_Vector64_SByte,
                ["LeadingSignCount.Vector128.Int16"] = LeadingSignCount_Vector128_Int16,
                ["LeadingSignCount.Vector128.Int32"] = LeadingSignCount_Vector128_Int32,
                ["LeadingSignCount.Vector128.SByte"] = LeadingSignCount_Vector128_SByte,
                ["LeadingZeroCount.Vector64.Byte"] = LeadingZeroCount_Vector64_Byte,
                ["LeadingZeroCount.Vector64.Int16"] = LeadingZeroCount_Vector64_Int16,
                ["LeadingZeroCount.Vector64.Int32"] = LeadingZeroCount_Vector64_Int32,
                ["LeadingZeroCount.Vector64.SByte"] = LeadingZeroCount_Vector64_SByte,
                ["LeadingZeroCount.Vector64.UInt16"] = LeadingZeroCount_Vector64_UInt16,
                ["LeadingZeroCount.Vector64.UInt32"] = LeadingZeroCount_Vector64_UInt32,
                ["LeadingZeroCount.Vector128.Byte"] = LeadingZeroCount_Vector128_Byte,
                ["LeadingZeroCount.Vector128.Int16"] = LeadingZeroCount_Vector128_Int16,
                ["LeadingZeroCount.Vector128.Int32"] = LeadingZeroCount_Vector128_Int32,
                ["LeadingZeroCount.Vector128.SByte"] = LeadingZeroCount_Vector128_SByte,
                ["LeadingZeroCount.Vector128.UInt16"] = LeadingZeroCount_Vector128_UInt16,
                ["LeadingZeroCount.Vector128.UInt32"] = LeadingZeroCount_Vector128_UInt32,
                ["LoadAndInsertScalar.Vector64.Byte.7"] = LoadAndInsertScalar_Vector64_Byte_7,
                ["LoadAndInsertScalar.Vector64.Int16.3"] = LoadAndInsertScalar_Vector64_Int16_3,
                ["LoadAndInsertScalar.Vector64.Int32.1"] = LoadAndInsertScalar_Vector64_Int32_1,
                ["LoadAndInsertScalar.Vector64.SByte.7"] = LoadAndInsertScalar_Vector64_SByte_7,
                ["LoadAndInsertScalar.Vector64.Single.1"] = LoadAndInsertScalar_Vector64_Single_1,
                ["LoadAndInsertScalar.Vector64.UInt16.3"] = LoadAndInsertScalar_Vector64_UInt16_3,
                ["LoadAndInsertScalar.Vector64.UInt32.1"] = LoadAndInsertScalar_Vector64_UInt32_1,
                ["LoadAndInsertScalar.Vector128.Byte.15"] = LoadAndInsertScalar_Vector128_Byte_15,
                ["LoadAndInsertScalar.Vector128.Double.1"] = LoadAndInsertScalar_Vector128_Double_1,
                ["LoadAndInsertScalar.Vector128.Int16.7"] = LoadAndInsertScalar_Vector128_Int16_7,
                ["LoadAndInsertScalar.Vector128.Int32.3"] = LoadAndInsertScalar_Vector128_Int32_3,
                ["LoadAndInsertScalar.Vector128.Int64.1"] = LoadAndInsertScalar_Vector128_Int64_1,
                ["LoadAndInsertScalar.Vector128.SByte.15"] = LoadAndInsertScalar_Vector128_SByte_15,
                ["LoadAndInsertScalar.Vector128.Single.3"] = LoadAndInsertScalar_Vector128_Single_3,
                ["LoadAndInsertScalar.Vector128.UInt16.7"] = LoadAndInsertScalar_Vector128_UInt16_7,
            };
        }
    }
}
