// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;
using System.IO;

// DIRECTIONS:
//    This file isn't very robust and makes several assumptions
//    You can execute it by calling "csi .\GenerateTests.csx"
//
//    csi can be found under the <repo-root>\tools\net46\roslyn directory
//    It must be run such from the directory that contains the csx script
//
//    New tests can be generated from the template by adding an entry to the
//    appropriate Inputs array below.
//
//    You can support a new Isa by creating a new array and adding a new
//    "ProcessInputs" call at the bottom of the script.

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector64Inputs = new []
{
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Abs", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (short)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (int)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (long)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (float)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Add", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] + right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & ~right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & ~BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & ~BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & ~right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & ~right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & ~right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & ~right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & ~BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & ~BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & ~right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "AndNot", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & ~right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & ~right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] | right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] | right[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Ceiling", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Ceiling(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != Math.Ceiling(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Ceiling", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != MathF.Ceiling(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != MathF.Ceiling(firstOp[i])" }),

    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((BitConverter.DoubleToInt64Bits(secondOp[0]) & BitConverter.DoubleToInt64Bits(firstOp[0])) | (BitConverter.DoubleToInt64Bits(thirdOp[0]) & ~BitConverter.DoubleToInt64Bits(firstOp[0])))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((BitConverter.DoubleToInt64Bits(secondOp[i]) & BitConverter.DoubleToInt64Bits(firstOp[i])) | (BitConverter.DoubleToInt64Bits(thirdOp[i]) & ~BitConverter.DoubleToInt64Bits(firstOp[i])))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((BitConverter.SingleToInt32Bits(secondOp[0]) & BitConverter.SingleToInt32Bits(firstOp[0])) | (BitConverter.SingleToInt32Bits(thirdOp[0]) & ~BitConverter.SingleToInt32Bits(firstOp[0])))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((BitConverter.SingleToInt32Bits(secondOp[i]) & BitConverter.SingleToInt32Bits(firstOp[i])) | (BitConverter.SingleToInt32Bits(thirdOp[i]) & ~BitConverter.SingleToInt32Bits(firstOp[i])))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector64", ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),

    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToDouble", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (double)(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToDouble", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "Math.Min(long.MaxValue, TestLibrary.Generator.GetUInt64())", ["ValidateFirstResult"] = "result[0] != (double)(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToInt32",  ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (int)(firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToInt64",  ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (long)(firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToSingle", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (float)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToSingle", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (float)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToUInt32", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (uint)(firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ConvertToUInt64", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (ulong)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(firstOp[i])" }),

    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "Math.Max((byte)(1), TestLibrary.Generator.GetByte())",     ["ValidateFirstResult"] = "result[0] != (byte)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "Math.Max((double)(1), TestLibrary.Generator.GetDouble())", ["ValidateFirstResult"] = "result[0] != (double)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "Math.Max((short)(1), TestLibrary.Generator.GetInt16())",   ["ValidateFirstResult"] = "result[0] != (short)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "Math.Max((int)(1), TestLibrary.Generator.GetInt32())",     ["ValidateFirstResult"] = "result[0] != (int)(left[0] / right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "Math.Max((long)(1), TestLibrary.Generator.GetInt64())",    ["ValidateFirstResult"] = "result[0] != (long)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "Math.Max((sbyte)(1), TestLibrary.Generator.GetSByte())",   ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "Math.Max((float)(1), TestLibrary.Generator.GetSingle())",  ["ValidateFirstResult"] = "result[0] != (float)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "Math.Max((ushort)(1), TestLibrary.Generator.GetUInt16())", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "Math.Max((uint)(1), TestLibrary.Generator.GetUInt32())",   ["ValidateFirstResult"] = "result[0] != (uint)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Divide", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "Math.Max((ulong)(1), TestLibrary.Generator.GetUInt64())",  ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] / right[i])" }),

    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Dot", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Equals", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Floor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Floor(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != Math.Floor(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Floor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != MathF.Floor(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != MathF.Floor(firstOp[i])" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] > right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] > right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] < right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] < right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThan", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Max", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Min", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (short)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (int)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (long)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (float)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Multiply", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] * right[i])" }),

    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (float)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (float)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (short)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0])",    ["ValidateRemainingResults"] = "result[i] != (int)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (byte)(left[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Narrow", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(0 - firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Negate", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(0 - firstOp[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ~BitConverter.DoubleToInt64Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ~BitConverter.DoubleToInt64Bits(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (short)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(~firstOp[0])",                                                          ["ValidateRemainingResults"] = "result[i] != (int)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (long)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (sbyte)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ~BitConverter.SingleToInt32Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ~BitConverter.SingleToInt32Bits(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(~firstOp[0])",                                                       ["ValidateRemainingResults"] = "result[i] != (ushort)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (ulong)(~firstOp[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(MathF.Sqrt(firstOp[0]))",   ["ValidateRemainingResults"] = "result[i] != (byte)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(Math.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (double)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (short)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(Math.Sqrt(firstOp[0]))",     ["ValidateRemainingResults"] = "result[i] != (int)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(Math.Sqrt(firstOp[0]))",    ["ValidateRemainingResults"] = "result[i] != (long)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (float)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(MathF.Sqrt(firstOp[0]))", ["ValidateRemainingResults"] = "result[i] != (ushort)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(Math.Sqrt(firstOp[0]))",    ["ValidateRemainingResults"] = "result[i] != (uint)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(Math.Sqrt(firstOp[0]))",   ["ValidateRemainingResults"] = "result[i] != (ulong)(Math.Sqrt(firstOp[i]))" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] - right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Subtract", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] - right[i])" }),

    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateLowerResult"] = "lowerResult[i] != (ushort)(firstOp[i])", ["ValidateUpperResult"] = "upperResult[i] != (ushort)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateLowerResult"] = "lowerResult[i] != (int)(firstOp[i])",    ["ValidateUpperResult"] = "upperResult[i] != (int)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateLowerResult"] = "lowerResult[i] != (long)(firstOp[i])",   ["ValidateUpperResult"] = "upperResult[i] != (long)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateLowerResult"] = "lowerResult[i] != (short)(firstOp[i])",  ["ValidateUpperResult"] = "upperResult[i] != (short)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateLowerResult"] = "lowerResult[i] != (double)(firstOp[i])", ["ValidateUpperResult"] = "upperResult[i] != (double)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateLowerResult"] = "lowerResult[i] != (uint)(firstOp[i])",   ["ValidateUpperResult"] = "upperResult[i] != (uint)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Widen", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateLowerResult"] = "lowerResult[i] != (ulong)(firstOp[i])",  ["ValidateUpperResult"] = "upperResult[i] != (ulong)(firstOp[i + RetElementCount])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] ^ right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] ^ right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Xor", ["RetVectorType"] = "Vector64", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] ^ right[i])" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector64_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8" }),

    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] + right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] + right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] | right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] | right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "Math.Max((byte)(1), TestLibrary.Generator.GetByte())",     ["ValidateFirstResult"] = "result[0] != (byte)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "Math.Max((double)(1), TestLibrary.Generator.GetDouble())", ["ValidateFirstResult"] = "result[0] != (double)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "Math.Max((short)(1), TestLibrary.Generator.GetInt16())",   ["ValidateFirstResult"] = "result[0] != (short)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "Math.Max((int)(1), TestLibrary.Generator.GetInt32())",     ["ValidateFirstResult"] = "result[0] != (int)(left[0] / right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "Math.Max((long)(1), TestLibrary.Generator.GetInt64())",    ["ValidateFirstResult"] = "result[0] != (long)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "Math.Max((sbyte)(1), TestLibrary.Generator.GetSByte())",   ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "Math.Max((float)(1), TestLibrary.Generator.GetSingle())",  ["ValidateFirstResult"] = "result[0] != (float)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "Math.Max((ushort)(1), TestLibrary.Generator.GetUInt16())", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "Math.Max((uint)(1), TestLibrary.Generator.GetUInt32())",   ["ValidateFirstResult"] = "result[0] != (uint)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "Math.Max((ulong)(1), TestLibrary.Generator.GetUInt64())",  ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] / right[i])" }),

    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] ^ right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] ^ right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] ^ right[i])" }),

    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] != right[i]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] * right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] * right[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ~BitConverter.DoubleToInt64Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ~BitConverter.DoubleToInt64Bits(firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (short)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(~firstOp[0])",                                                          ["ValidateRemainingResults"] = "result[i] != (int)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (long)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (sbyte)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ~BitConverter.SingleToInt32Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ~BitConverter.SingleToInt32Bits(firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(~firstOp[0])",                                                       ["ValidateRemainingResults"] = "result[i] != (ushort)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (ulong)(~firstOp[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] - right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] - right[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(0 - firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(0 - firstOp[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(+firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(+firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(+firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(+firstOp[i])" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector128Inputs = new []
{
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Abs", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (short)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (int)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (long)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (float)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Add", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] + right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & ~BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & ~BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & ~BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & ~BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "AndNot", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & ~right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (short)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (int)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (long)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] | right[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Ceiling", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Ceiling(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != Math.Ceiling(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Ceiling", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != MathF.Ceiling(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != MathF.Ceiling(firstOp[i])" }),

    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (byte)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((BitConverter.DoubleToInt64Bits(secondOp[0]) & BitConverter.DoubleToInt64Bits(firstOp[0])) | (BitConverter.DoubleToInt64Bits(thirdOp[0]) & ~BitConverter.DoubleToInt64Bits(firstOp[0])))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((BitConverter.DoubleToInt64Bits(secondOp[i]) & BitConverter.DoubleToInt64Bits(firstOp[i])) | (BitConverter.DoubleToInt64Bits(thirdOp[i]) & ~BitConverter.DoubleToInt64Bits(firstOp[i])))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (short)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (int)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (long)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (sbyte)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((BitConverter.SingleToInt32Bits(secondOp[0]) & BitConverter.SingleToInt32Bits(firstOp[0])) | (BitConverter.SingleToInt32Bits(thirdOp[0]) & ~BitConverter.SingleToInt32Bits(firstOp[0])))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((BitConverter.SingleToInt32Bits(secondOp[i]) & BitConverter.SingleToInt32Bits(firstOp[i])) | (BitConverter.SingleToInt32Bits(thirdOp[i]) & ~BitConverter.SingleToInt32Bits(firstOp[i])))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (uint)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (ulong)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),

    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToDouble", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (double)(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToDouble", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "Math.Min(long.MaxValue, TestLibrary.Generator.GetUInt64())", ["ValidateFirstResult"] = "result[0] != (double)(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToInt32",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (int)(firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToInt64",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (long)(firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToSingle", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (float)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToSingle", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (float)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToUInt32", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (uint)(firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ConvertToUInt64", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (ulong)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(firstOp[i])" }),

    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "Math.Max((byte)(1), TestLibrary.Generator.GetByte())",     ["ValidateFirstResult"] = "result[0] != (byte)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "Math.Max((double)(1), TestLibrary.Generator.GetDouble())", ["ValidateFirstResult"] = "result[0] != (double)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "Math.Max((short)(1), TestLibrary.Generator.GetInt16())",   ["ValidateFirstResult"] = "result[0] != (short)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "Math.Max((int)(1), TestLibrary.Generator.GetInt32())",     ["ValidateFirstResult"] = "result[0] != (int)(left[0] / right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "Math.Max((long)(1), TestLibrary.Generator.GetInt64())",    ["ValidateFirstResult"] = "result[0] != (long)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "Math.Max((sbyte)(1), TestLibrary.Generator.GetSByte())",   ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "Math.Max((float)(1), TestLibrary.Generator.GetSingle())",  ["ValidateFirstResult"] = "result[0] != (float)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "Math.Max((ushort)(1), TestLibrary.Generator.GetUInt16())", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "Math.Max((uint)(1), TestLibrary.Generator.GetUInt32())",   ["ValidateFirstResult"] = "result[0] != (uint)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Divide", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "Math.Max((ulong)(1), TestLibrary.Generator.GetUInt64())",  ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] / right[i])" }),

    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Dot", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Equals", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Floor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Floor(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != Math.Floor(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Floor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != MathF.Floor(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != MathF.Floor(firstOp[i])" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] > right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] > right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] < right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] < right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Max", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Min", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] * right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Multiply", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] * right[i])" }),

    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (float)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (float)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (short)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0])",    ["ValidateRemainingResults"] = "result[i] != (int)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (byte)(left[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Narrow", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(0 - firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Negate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(0 - firstOp[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ~BitConverter.DoubleToInt64Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ~BitConverter.DoubleToInt64Bits(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (short)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(~firstOp[0])",                                                          ["ValidateRemainingResults"] = "result[i] != (int)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (long)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (sbyte)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ~BitConverter.SingleToInt32Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ~BitConverter.SingleToInt32Bits(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(~firstOp[0])",                                                       ["ValidateRemainingResults"] = "result[i] != (ushort)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (ulong)(~firstOp[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(MathF.Sqrt(firstOp[0]))",   ["ValidateRemainingResults"] = "result[i] != (byte)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(Math.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (double)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (short)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(Math.Sqrt(firstOp[0]))",     ["ValidateRemainingResults"] = "result[i] != (int)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(Math.Sqrt(firstOp[0]))",    ["ValidateRemainingResults"] = "result[i] != (long)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (float)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(MathF.Sqrt(firstOp[0]))", ["ValidateRemainingResults"] = "result[i] != (ushort)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(Math.Sqrt(firstOp[0]))",    ["ValidateRemainingResults"] = "result[i] != (uint)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(Math.Sqrt(firstOp[0]))",   ["ValidateRemainingResults"] = "result[i] != (ulong)(Math.Sqrt(firstOp[i]))" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] - right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Subtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] - right[i])" }),

    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateLowerResult"] = "lowerResult[i] != (ushort)(firstOp[i])", ["ValidateUpperResult"] = "upperResult[i] != (ushort)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateLowerResult"] = "lowerResult[i] != (int)(firstOp[i])",    ["ValidateUpperResult"] = "upperResult[i] != (int)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateLowerResult"] = "lowerResult[i] != (long)(firstOp[i])",   ["ValidateUpperResult"] = "upperResult[i] != (long)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateLowerResult"] = "lowerResult[i] != (short)(firstOp[i])",  ["ValidateUpperResult"] = "upperResult[i] != (short)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateLowerResult"] = "lowerResult[i] != (double)(firstOp[i])", ["ValidateUpperResult"] = "upperResult[i] != (double)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateLowerResult"] = "lowerResult[i] != (uint)(firstOp[i])",   ["ValidateUpperResult"] = "upperResult[i] != (uint)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Widen", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateLowerResult"] = "lowerResult[i] != (ulong)(firstOp[i])",  ["ValidateUpperResult"] = "upperResult[i] != (ulong)(firstOp[i + RetElementCount])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] ^ right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] ^ right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Xor", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] ^ right[i])" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector128_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16" }),

    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorAsNumericsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector2", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector2", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector3", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector3", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector4", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector4", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),

    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] + right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] + right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] | right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] | right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "Math.Max((byte)(1), TestLibrary.Generator.GetByte())",     ["ValidateFirstResult"] = "result[0] != (byte)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "Math.Max((double)(1), TestLibrary.Generator.GetDouble())", ["ValidateFirstResult"] = "result[0] != (double)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "Math.Max((short)(1), TestLibrary.Generator.GetInt16())",   ["ValidateFirstResult"] = "result[0] != (short)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "Math.Max((int)(1), TestLibrary.Generator.GetInt32())",     ["ValidateFirstResult"] = "result[0] != (int)(left[0] / right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "Math.Max((long)(1), TestLibrary.Generator.GetInt64())",    ["ValidateFirstResult"] = "result[0] != (long)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "Math.Max((sbyte)(1), TestLibrary.Generator.GetSByte())",   ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "Math.Max((float)(1), TestLibrary.Generator.GetSingle())",  ["ValidateFirstResult"] = "result[0] != (float)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "Math.Max((ushort)(1), TestLibrary.Generator.GetUInt16())", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "Math.Max((uint)(1), TestLibrary.Generator.GetUInt32())",   ["ValidateFirstResult"] = "result[0] != (uint)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "Math.Max((ulong)(1), TestLibrary.Generator.GetUInt64())",  ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] / right[i])" }),

    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] ^ right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] ^ right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] ^ right[i])" }),

    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] != right[i]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] * right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] * right[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ~BitConverter.DoubleToInt64Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ~BitConverter.DoubleToInt64Bits(firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (short)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(~firstOp[0])",                                                          ["ValidateRemainingResults"] = "result[i] != (int)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (long)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (sbyte)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ~BitConverter.SingleToInt32Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ~BitConverter.SingleToInt32Bits(firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(~firstOp[0])",                                                       ["ValidateRemainingResults"] = "result[i] != (ushort)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (ulong)(~firstOp[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] - right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] - right[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(0 - firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(0 - firstOp[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(+firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(+firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(+firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(+firstOp[i])" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector256Inputs = new []
{
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Abs", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != firstOp[0]",           ["ValidateRemainingResults"] = "result[i] != firstOp[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] + right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] + right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Add", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] + right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & ~right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & ~BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & ~BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & ~right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & ~right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & ~right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & ~right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & ~BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & ~BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & ~right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & ~right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & ~right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "AndNot", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & ~right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & ~right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseAnd", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] | right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] | right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "BitwiseOr", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] | right[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Ceiling", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Ceiling(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != Math.Ceiling(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Ceiling", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != MathF.Ceiling(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != MathF.Ceiling(firstOp[i])" }),

    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (byte)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((BitConverter.DoubleToInt64Bits(secondOp[0]) & BitConverter.DoubleToInt64Bits(firstOp[0])) | (BitConverter.DoubleToInt64Bits(thirdOp[0]) & ~BitConverter.DoubleToInt64Bits(firstOp[0])))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((BitConverter.DoubleToInt64Bits(secondOp[i]) & BitConverter.DoubleToInt64Bits(firstOp[i])) | (BitConverter.DoubleToInt64Bits(thirdOp[i]) & ~BitConverter.DoubleToInt64Bits(firstOp[i])))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (short)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (int)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (long)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (sbyte)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((BitConverter.SingleToInt32Bits(secondOp[0]) & BitConverter.SingleToInt32Bits(firstOp[0])) | (BitConverter.SingleToInt32Bits(thirdOp[0]) & ~BitConverter.SingleToInt32Bits(firstOp[0])))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((BitConverter.SingleToInt32Bits(secondOp[i]) & BitConverter.SingleToInt32Bits(firstOp[i])) | (BitConverter.SingleToInt32Bits(thirdOp[i]) & ~BitConverter.SingleToInt32Bits(firstOp[i])))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (uint)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),
    ("VectorTernaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConditionalSelect", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)((secondOp[0] & firstOp[0]) | (thirdOp[0] & ~firstOp[0]))",                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (ulong)((secondOp[i] & firstOp[i]) | (thirdOp[i] & ~firstOp[i]))" }),

    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToDouble", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (double)(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToDouble", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "Math.Min(long.MaxValue, TestLibrary.Generator.GetUInt64())", ["ValidateFirstResult"] = "result[0] != (double)(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToInt32",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (int)(firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToInt64",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (long)(firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToSingle", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (float)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToSingle", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (float)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToUInt32", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (uint)(firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(firstOp[i])" }),
    ("VectorConvertToTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ConvertToUInt64", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (ulong)(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(firstOp[i])" }),

    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "Math.Max((byte)(1), TestLibrary.Generator.GetByte())",     ["ValidateFirstResult"] = "result[0] != (byte)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "Math.Max((double)(1), TestLibrary.Generator.GetDouble())", ["ValidateFirstResult"] = "result[0] != (double)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "Math.Max((short)(1), TestLibrary.Generator.GetInt16())",   ["ValidateFirstResult"] = "result[0] != (short)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "Math.Max((int)(1), TestLibrary.Generator.GetInt32())",     ["ValidateFirstResult"] = "result[0] != (int)(left[0] / right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "Math.Max((long)(1), TestLibrary.Generator.GetInt64())",    ["ValidateFirstResult"] = "result[0] != (long)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "Math.Max((sbyte)(1), TestLibrary.Generator.GetSByte())",   ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "Math.Max((float)(1), TestLibrary.Generator.GetSingle())",  ["ValidateFirstResult"] = "result[0] != (float)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "Math.Max((ushort)(1), TestLibrary.Generator.GetUInt16())", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "Math.Max((uint)(1), TestLibrary.Generator.GetUInt32())",   ["ValidateFirstResult"] = "result[0] != (uint)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] / right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Divide", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "Math.Max((ulong)(1), TestLibrary.Generator.GetUInt64())",  ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] / right[i])" }),

    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorDotTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Dot", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "EqualsAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Equals", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Floor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != Math.Floor(firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != Math.Floor(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Floor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != MathF.Floor(firstOp[0])", ["ValidateRemainingResults"] = "result[i] != MathF.Floor(firstOp[i])" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] > right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] > right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] > right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] >= right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] < right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] < right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] < right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThan", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAllBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAll", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),

    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),
    ("VectorBooleanAnyBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqualAny", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] <= right[i]" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? byte.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? byte.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? -1 : 0)",                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? ushort.MaxValue : 0)",                    ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? ushort.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? uint.MaxValue : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? uint.MaxValue : 0)" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "LessThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? ulong.MaxValue : 0)",                     ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? ulong.MaxValue : 0)" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Max", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? left[i] : right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Min", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? left[0] : right[0])", ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? left[i] : right[i])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] * right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] * right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Multiply", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] * right[i])" }),

    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (float)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (float)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0])",  ["ValidateRemainingResults"] = "result[i] != (short)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0])",    ["ValidateRemainingResults"] = "result[i] != (int)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (byte)(left[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),
    ("VectorNarrowTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Narrow", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)((i < Op1ElementCount) ? left[i] : right[i - Op1ElementCount])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(0 - firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(0 - firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Negate", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(0 - firstOp[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ~BitConverter.DoubleToInt64Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ~BitConverter.DoubleToInt64Bits(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (short)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(~firstOp[0])",                                                          ["ValidateRemainingResults"] = "result[i] != (int)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (long)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (sbyte)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ~BitConverter.SingleToInt32Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ~BitConverter.SingleToInt32Bits(firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(~firstOp[0])",                                                       ["ValidateRemainingResults"] = "result[i] != (ushort)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(~firstOp[i])" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "OnesComplement", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (ulong)(~firstOp[i])" }),

    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(MathF.Sqrt(firstOp[0]))",   ["ValidateRemainingResults"] = "result[i] != (byte)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(Math.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (double)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (short)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(Math.Sqrt(firstOp[0]))",     ["ValidateRemainingResults"] = "result[i] != (int)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(Math.Sqrt(firstOp[0]))",    ["ValidateRemainingResults"] = "result[i] != (long)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(MathF.Sqrt(firstOp[0]))",  ["ValidateRemainingResults"] = "result[i] != (float)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(MathF.Sqrt(firstOp[0]))", ["ValidateRemainingResults"] = "result[i] != (ushort)(MathF.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(Math.Sqrt(firstOp[0]))",    ["ValidateRemainingResults"] = "result[i] != (uint)(Math.Sqrt(firstOp[i]))" }),
    ("VectorUnaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Sqrt", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(Math.Sqrt(firstOp[0]))",   ["ValidateRemainingResults"] = "result[i] != (ulong)(Math.Sqrt(firstOp[i]))" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] - right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] - right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Subtract", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] - right[i])" }),

    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateLowerResult"] = "lowerResult[i] != (ushort)(firstOp[i])", ["ValidateUpperResult"] = "upperResult[i] != (ushort)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateLowerResult"] = "lowerResult[i] != (int)(firstOp[i])",    ["ValidateUpperResult"] = "upperResult[i] != (int)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateLowerResult"] = "lowerResult[i] != (long)(firstOp[i])",   ["ValidateUpperResult"] = "upperResult[i] != (long)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateLowerResult"] = "lowerResult[i] != (short)(firstOp[i])",  ["ValidateUpperResult"] = "upperResult[i] != (short)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateLowerResult"] = "lowerResult[i] != (double)(firstOp[i])", ["ValidateUpperResult"] = "upperResult[i] != (double)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateLowerResult"] = "lowerResult[i] != (uint)(firstOp[i])",   ["ValidateUpperResult"] = "upperResult[i] != (uint)(firstOp[i + RetElementCount])" }),
    ("VectorWidenTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Widen", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateLowerResult"] = "lowerResult[i] != (ulong)(firstOp[i])",  ["ValidateUpperResult"] = "upperResult[i] != (ulong)(firstOp[i + RetElementCount])" }),

    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] ^ right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] ^ right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] ^ right[i])" }),
    ("VectorBinaryOpTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Xor", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] ^ right[i])" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector256_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32" }),

    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32" }),


    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "31", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "31", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] + right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] + right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] + right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] + right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Addition", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] + right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] + right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] & right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] & right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] & right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] & right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseAnd", ["Opcode"] = "&", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] & right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] & right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] | right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] | right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] | right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] | right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_BitwiseOr", ["Opcode"] = "|", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] | right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] | right[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "Math.Max((byte)(1), TestLibrary.Generator.GetByte())",     ["ValidateFirstResult"] = "result[0] != (byte)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "Math.Max((double)(1), TestLibrary.Generator.GetDouble())", ["ValidateFirstResult"] = "result[0] != (double)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "Math.Max((short)(1), TestLibrary.Generator.GetInt16())",   ["ValidateFirstResult"] = "result[0] != (short)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "Math.Max((int)(1), TestLibrary.Generator.GetInt32())",     ["ValidateFirstResult"] = "result[0] != (int)(left[0] / right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "Math.Max((long)(1), TestLibrary.Generator.GetInt64())",    ["ValidateFirstResult"] = "result[0] != (long)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "Math.Max((sbyte)(1), TestLibrary.Generator.GetSByte())",   ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "Math.Max((float)(1), TestLibrary.Generator.GetSingle())",  ["ValidateFirstResult"] = "result[0] != (float)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "Math.Max((ushort)(1), TestLibrary.Generator.GetUInt16())", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] / right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "Math.Max((uint)(1), TestLibrary.Generator.GetUInt32())",   ["ValidateFirstResult"] = "result[0] != (uint)(left[0] / right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] / right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Division", ["Opcode"] = "/", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "Math.Max((ulong)(1), TestLibrary.Generator.GetUInt64())",  ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] / right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] / right[i])" }),

    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] == right[i]" }),
    ("VectorBooleanAllBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Equality", ["Opcode"] = "==", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] == right[i]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] ^ right[0])",                                                                                            ["ValidateRemainingResults"] = "result[i] != (int)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (long)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i]))" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] ^ right[0])",                                                                                         ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] ^ right[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] ^ right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_ExclusiveOr", ["Opcode"] = "^", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] ^ right[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] ^ right[i])" }),

    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "left[i] != right[i]" }),
    ("VectorBooleanAnyBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Inequality", ["Opcode"] = "!=", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "left[i] != right[i]" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] * right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] * right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] * right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] * right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Multiply", ["Opcode"] = "*", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] * right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] * right[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (byte)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ~BitConverter.DoubleToInt64Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ~BitConverter.DoubleToInt64Bits(firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (short)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(~firstOp[0])",                                                          ["ValidateRemainingResults"] = "result[i] != (int)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (long)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (sbyte)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ~BitConverter.SingleToInt32Bits(firstOp[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ~BitConverter.SingleToInt32Bits(firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(~firstOp[0])",                                                       ["ValidateRemainingResults"] = "result[i] != (ushort)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(~firstOp[0])",                                                         ["ValidateRemainingResults"] = "result[i] != (uint)(~firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_OnesComplement", ["Opcode"] = "~", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(~firstOp[0])",                                                        ["ValidateRemainingResults"] = "result[i] != (ulong)(~firstOp[i])" }),

    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (double)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(left[0] - right[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(left[0] - right[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(left[0] - right[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(left[i] - right[i])" }),
    ("VectorBinaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_Subtraction", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(left[0] - right[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(left[i] - right[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(0 - firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(0 - firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(0 - firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(0 - firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryNegation", ["Opcode"] = "-", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(0 - firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(0 - firstOp[i])" }),

    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != (byte)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (byte)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "result[0] != (double)(+firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (double)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (short)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (short)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (int)(+firstOp[0])",    ["ValidateRemainingResults"] = "result[i] != (int)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != (long)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (long)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != (sbyte)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (sbyte)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "result[0] != (float)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (float)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != (ushort)(+firstOp[0])", ["ValidateRemainingResults"] = "result[i] != (ushort)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (uint)(+firstOp[0])",   ["ValidateRemainingResults"] = "result[i] != (uint)(+firstOp[i])" }),
    ("VectorUnaryOperatorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "op_UnaryPlus", ["Opcode"] = "+", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (ulong)(+firstOp[0])",  ["ValidateRemainingResults"] = "result[i] != (ulong)(+firstOp[i])" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] NotSupportedInputs = new []
{
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanZero",                    ["TargetType"] = "Vector64<bool>",    ["Source"] = "Vector64<bool>",             ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAllBitsSet",              ["TargetType"] = "Vector64<bool>",    ["Source"] = "Vector64<bool>",             ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Boolean",       ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ByteAsGeneric_Boolean",          ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<byte>)",    ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64DoubleAsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<double>)",  ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int16AsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<short>)",   ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int32AsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<int>)",     ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int64AsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<long>)",    ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SByteAsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<sbyte>)",   ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SingleAsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<float>)",   ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt16AsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<ushort>)",  ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt32AsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<uint>)",    ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt64AsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<ulong>)",   ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Byte",          ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Double",        ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int16",         ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int32",         ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int64",         ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_SByte",         ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Single",        ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt16",        ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt32",        ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt64",        ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsByte",                  ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsDouble",                ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt16",                 ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt32",                 ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt64",                 ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsSByte",                 ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsSingle",                ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt16",                ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt32",                ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt64",                ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanGetElementNegativeOne",   ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanGetElement0",             ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanGetElementMaxValue",      ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanWithElementNegativeOne",  ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanWithElement0",            ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanWithElementMaxValue",     ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToScalar",                ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToVector128",             ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToVector128()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToVector128Unsafe",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToVector128Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToString",                ["TargetType"] = "string",            ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanZero",                   ["TargetType"] = "Vector128<bool>",   ["Source"] = "Vector128<bool>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAllBitsSet",             ["TargetType"] = "Vector128<bool>",   ["Source"] = "Vector128<bool>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Boolean",      ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ByteAsGeneric_Boolean",         ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<byte>)",   ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128DoubleAsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<double>)", ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int16AsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<short>)",  ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int32AsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<int>)",    ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int64AsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<long>)",   ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SByteAsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<sbyte>)",  ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SingleAsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<float>)",  ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt16AsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<ushort>)", ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt32AsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<uint>)",   ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt64AsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<ulong>)",  ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Byte",         ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Double",       ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int16",        ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int32",        ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int64",        ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_SByte",        ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Single",       ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt16",       ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt32",       ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt64",       ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsByte",                 ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsDouble",               ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt16",                ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt32",                ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt64",                ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsSByte",                ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsSingle",               ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt16",               ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt32",               ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt64",               ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetElementNegativeOne",  ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetElement0",            ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetElementMaxValue",     ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithElementNegativeOne", ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithElement0",           ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithElementMaxValue",    ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetLower",               ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithLower",              ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithLower(default(Vector64<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetUpper",               ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithUpper",              ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithUpper(default(Vector64<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToScalar",               ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToVector256",            ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToVector256()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToVector256Unsafe",      ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToVector256Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToString",               ["TargetType"] = "string",            ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanZero",                   ["TargetType"] = "Vector256<bool>",   ["Source"] = "Vector256<bool>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAllBitsSet",             ["TargetType"] = "Vector256<bool>",   ["Source"] = "Vector256<bool>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Boolean",      ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ByteAsGeneric_Boolean",         ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<byte>)",   ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256DoubleAsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<double>)", ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int16AsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<short>)",  ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int32AsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<int>)",    ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int64AsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<long>)",   ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SByteAsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<sbyte>)",  ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SingleAsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<float>)",  ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt16AsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<ushort>)", ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt32AsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<uint>)",   ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt64AsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<ulong>)",  ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Byte",         ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Double",       ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int16",        ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int32",        ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int64",        ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_SByte",        ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Single",       ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt16",       ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt32",       ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt64",       ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsByte",                 ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsDouble",               ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt16",                ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt32",                ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt64",                ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsSByte",                ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsSingle",               ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt16",               ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt32",               ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt64",               ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetElementNegativeOne",  ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetElement0",            ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetElementMaxValue",     ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithElementNegativeOne", ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithElement0",           ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithElementMaxValue",    ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetLower",               ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithLower",              ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithLower(default(Vector128<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetUpper",               ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithUpper",              ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithUpper(default(Vector128<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanToScalar",               ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanToString",               ["TargetType"] = "string",            ["Source"] = "default(Vector256<bool>)",   ["Method"] = "ToString()" }),
};

private static void ProcessInputs(string groupName, (string templateFileName, Dictionary<string, string> templateData)[] inputs)
{
    var testListFileName = Path.Combine("..", groupName, $"Program.{groupName}.cs");

    using (var testListFile = new StreamWriter(testListFileName, append: false))
    {
        testListFile.WriteLine(@"// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.General
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {");

        foreach (var input in inputs)
        {
            ProcessInput(testListFile, groupName, input);
        }

        testListFile.WriteLine(@"            };
        }
    }
}");
    }
}

private static void ProcessInput(StreamWriter testListFile, string groupName, (string templateFileName, Dictionary<string, string> templateData) input)
{
    var testName = "";

    // Ex: ["Add.Single"] = AddSingle
    if (input.templateFileName == "VectorCreateElementTest.template")
    {
        testName = $"{input.templateData["Method"]}Element.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}Element{input.templateData["BaseType"]},");
    }
    else if (input.templateFileName == "VectorCreateVectorTest.template")
    {
        testName = $"{input.templateData["Method"]}Vector.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}Vector{input.templateData["BaseType"]},");
    }
    else if (input.templateFileName == "VectorGetAndWithElementTest.template")
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["BaseType"]}.{input.templateData["Imm"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["BaseType"]}{input.templateData["Imm"]},");
    }
    else if (input.templateFileName == "VectorNotSupportedTest.template")
    {
        testName = input.templateData["Name"];
        testListFile.WriteLine($@"                [""{testName}""] = {testName},");
    }
    else if (input.templateData.ContainsKey("BaseType"))
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["BaseType"]},");
    }
    else if ((input.templateFileName == "VectorNarrowTest.template") || (input.templateFileName == "VectorConvertToTest.template"))
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["Op1BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["Op1BaseType"]},");
    }
    else
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["RetBaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["RetBaseType"]},");
    }

    var testFileName = Path.Combine("..", groupName, $"{testName}.cs");
    var template = File.ReadAllText(input.templateFileName);

    foreach (var kvp in input.templateData)
    {
        template = template.Replace($"{{{kvp.Key}}}", kvp.Value);
    }

    File.WriteAllText(testFileName, template);
}

ProcessInputs("Vector64", Vector64Inputs);
ProcessInputs("Vector64_1", Vector64_1Inputs);
ProcessInputs("Vector128", Vector128Inputs);
ProcessInputs("Vector128_1", Vector128_1Inputs);
ProcessInputs("Vector256", Vector256Inputs);
ProcessInputs("Vector256_1", Vector256_1Inputs);
ProcessInputs("NotSupported", NotSupportedInputs);
