// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.X86
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["Add.Double"] = AddDouble,
                ["Add.Single"] = AddSingle,
                ["AddSubtract.Double"] = AddSubtractDouble,
                ["AddSubtract.Single"] = AddSubtractSingle,
                ["And.Double"] = AndDouble,
                ["And.Single"] = AndSingle,
                ["AndNot.Double"] = AndNotDouble,
                ["AndNot.Single"] = AndNotSingle,
                ["BlendVariable.Double"] = BlendVariableDouble,
                ["BlendVariable.Single"] = BlendVariableSingle,
                ["BroadcastScalarToVector128.Single"] = BroadcastScalarToVector128Single,
                ["BroadcastScalarToVector256.Single"] = BroadcastScalarToVector256Single,
                ["BroadcastScalarToVector256.Double"] = BroadcastScalarToVector256Double,
                ["BroadcastVector128ToVector256.Single"] = BroadcastVector128ToVector256Single,
                ["BroadcastVector128ToVector256.Double"] = BroadcastVector128ToVector256Double,
                ["Ceiling.Double"] = CeilingDouble,
                ["Ceiling.Single"] = CeilingSingle,
                ["CompareEqual.Single"] = CompareEqualSingle,
                ["CompareEqual.Double"] = CompareEqualDouble,
                ["CompareGreaterThan.Single"] = CompareGreaterThanSingle,
                ["CompareGreaterThan.Double"] = CompareGreaterThanDouble,
                ["CompareGreaterThanOrEqual.Single"] = CompareGreaterThanOrEqualSingle,
                ["CompareGreaterThanOrEqual.Double"] = CompareGreaterThanOrEqualDouble,
                ["CompareLessThan.Single"] = CompareLessThanSingle,
                ["CompareLessThan.Double"] = CompareLessThanDouble,
                ["CompareLessThanOrEqual.Single"] = CompareLessThanOrEqualSingle,
                ["CompareLessThanOrEqual.Double"] = CompareLessThanOrEqualDouble,
                ["CompareNotEqual.Single"] = CompareNotEqualSingle,
                ["CompareNotEqual.Double"] = CompareNotEqualDouble,
                ["CompareNotGreaterThan.Single"] = CompareNotGreaterThanSingle,
                ["CompareNotGreaterThan.Double"] = CompareNotGreaterThanDouble,
                ["CompareNotGreaterThanOrEqual.Single"] = CompareNotGreaterThanOrEqualSingle,
                ["CompareNotGreaterThanOrEqual.Double"] = CompareNotGreaterThanOrEqualDouble,
                ["CompareNotLessThan.Single"] = CompareNotLessThanSingle,
                ["CompareNotLessThan.Double"] = CompareNotLessThanDouble,
                ["CompareNotLessThanOrEqual.Single"] = CompareNotLessThanOrEqualSingle,
                ["CompareNotLessThanOrEqual.Double"] = CompareNotLessThanOrEqualDouble,
                ["CompareOrdered.Single"] = CompareOrderedSingle,
                ["CompareOrdered.Double"] = CompareOrderedDouble,
                ["CompareUnordered.Single"] = CompareUnorderedSingle,
                ["CompareUnordered.Double"] = CompareUnorderedDouble,
                ["Divide.Double"] = DivideDouble,
                ["Divide.Single"] = DivideSingle,
                ["DuplicateEvenIndexed.Double"] = DuplicateEvenIndexedDouble,
                ["DuplicateEvenIndexed.Single"] = DuplicateEvenIndexedSingle,
                ["DuplicateOddIndexed.Single"] = DuplicateOddIndexedSingle,
                ["ExtractVector128.Single.1"] = ExtractVector128Single1,
                ["ExtractVector128.Double.1"] = ExtractVector128Double1,
                ["ExtractVector128.Byte.1"] = ExtractVector128Byte1,
                ["ExtractVector128.SByte.1"] = ExtractVector128SByte1,
                ["ExtractVector128.Int16.1"] = ExtractVector128Int161,
                ["ExtractVector128.UInt16.1"] = ExtractVector128UInt161,
                ["ExtractVector128.Int32.1"] = ExtractVector128Int321,
                ["ExtractVector128.UInt32.1"] = ExtractVector128UInt321,
                ["ExtractVector128.Int64.1"] = ExtractVector128Int641,
                ["ExtractVector128.UInt64.1"] = ExtractVector128UInt641,
                ["InsertVector128.Byte.1"] = InsertVector128Byte1,
                ["InsertVector128.SByte.1"] = InsertVector128SByte1,
                ["InsertVector128.Int16.1"] = InsertVector128Int161,
                ["InsertVector128.UInt16.1"] = InsertVector128UInt161,
                ["InsertVector128.Int32.1"] = InsertVector128Int321,
                ["InsertVector128.UInt32.1"] = InsertVector128UInt321,
                ["InsertVector128.Int64.1"] = InsertVector128Int641,
                ["InsertVector128.UInt64.1"] = InsertVector128UInt641,
                ["InsertVector128.Single.1"] = InsertVector128Single1,
                ["InsertVector128.Double.1"] = InsertVector128Double1,
                ["Floor.Double"] = FloorDouble,
                ["Floor.Single"] = FloorSingle,
                ["LoadVector256.Single"] = LoadVector256Single,
                ["LoadVector256.Double"] = LoadVector256Double,
                ["LoadVector256.Byte"] = LoadVector256Byte,
                ["LoadVector256.SByte"] = LoadVector256SByte,
                ["LoadVector256.Int16"] = LoadVector256Int16,
                ["LoadVector256.UInt16"] = LoadVector256UInt16,
                ["LoadVector256.Int32"] = LoadVector256Int32,
                ["LoadVector256.UInt32"] = LoadVector256UInt32,
                ["LoadVector256.Int64"] = LoadVector256Int64,
                ["LoadVector256.UInt64"] = LoadVector256UInt64,
                ["MaskLoad.Double"] = MaskLoadDouble,
                ["MaskLoad.Single"] = MaskLoadSingle,
                ["MaskStore.Double"] = MaskStoreDouble,
                ["MaskStore.Single"] = MaskStoreSingle,
                ["Max.Double"] = MaxDouble,
                ["Max.Single"] = MaxSingle,
                ["Min.Double"] = MinDouble,
                ["Min.Single"] = MinSingle,
                ["Multiply.Double"] = MultiplyDouble,
                ["Multiply.Single"] = MultiplySingle,
                ["Or.Double"] = OrDouble,
                ["Or.Single"] = OrSingle,
                ["Permute.Single.1"] = PermuteSingle1,
                ["Permute.Double.1"] = PermuteDouble1,
                ["Permute.Single.2"] = PermuteSingle2,
                ["Permute.Double.2"] = PermuteDouble2,
                ["Permute2x128.Double.2"] = Permute2x128Double2,
                ["Permute2x128.Single.2"] = Permute2x128Single2,
                ["Permute2x128.Byte.2"] = Permute2x128Byte2,
                ["Permute2x128.SByte.2"] = Permute2x128SByte2,
                ["Permute2x128.Int16.2"] = Permute2x128Int162,
                ["Permute2x128.UInt16.2"] = Permute2x128UInt162,
                ["Permute2x128.Int32.2"] = Permute2x128Int322,
                ["Permute2x128.UInt32.2"] = Permute2x128UInt322,
                ["Permute2x128.Int64.2"] = Permute2x128Int642,
                ["Permute2x128.UInt64.2"] = Permute2x128UInt642,
                ["PermuteVar.Single"] = PermuteVarSingle,
                ["PermuteVar.Double"] = PermuteVarDouble,
                ["RoundCurrentDirection.Double"] = RoundCurrentDirectionDouble,
                ["RoundCurrentDirection.Single"] = RoundCurrentDirectionSingle,
                ["RoundToNearestInteger.Double"] = RoundToNearestIntegerDouble,
                ["RoundToNearestInteger.Single"] = RoundToNearestIntegerSingle,
                ["RoundToNegativeInfinity.Double"] = RoundToNegativeInfinityDouble,
                ["RoundToNegativeInfinity.Single"] = RoundToNegativeInfinitySingle,
                ["RoundToPositiveInfinity.Double"] = RoundToPositiveInfinityDouble,
                ["RoundToPositiveInfinity.Single"] = RoundToPositiveInfinitySingle,
                ["RoundToZero.Double"] = RoundToZeroDouble,
                ["RoundToZero.Single"] = RoundToZeroSingle,
                ["Shuffle.Single.1"] = ShuffleSingle1,
                ["Shuffle.Double.1"] = ShuffleDouble1,
                ["Subtract.Double"] = SubtractDouble,
                ["Subtract.Single"] = SubtractSingle,
                ["TestC.Byte"] = TestCByte,
                ["TestC.Int16"] = TestCInt16,
                ["TestC.Int32"] = TestCInt32,
                ["TestC.Int64"] = TestCInt64,
                ["TestC.SByte"] = TestCSByte,
                ["TestC.UInt16"] = TestCUInt16,
                ["TestC.UInt32"] = TestCUInt32,
                ["TestC.UInt64"] = TestCUInt64,
                ["TestNotZAndNotC.Byte"] = TestNotZAndNotCByte,
                ["TestNotZAndNotC.Int16"] = TestNotZAndNotCInt16,
                ["TestNotZAndNotC.Int32"] = TestNotZAndNotCInt32,
                ["TestNotZAndNotC.Int64"] = TestNotZAndNotCInt64,
                ["TestNotZAndNotC.SByte"] = TestNotZAndNotCSByte,
                ["TestNotZAndNotC.UInt16"] = TestNotZAndNotCUInt16,
                ["TestNotZAndNotC.UInt32"] = TestNotZAndNotCUInt32,
                ["TestNotZAndNotC.UInt64"] = TestNotZAndNotCUInt64,
                ["TestZ.Byte"] = TestZByte,
                ["TestZ.Int16"] = TestZInt16,
                ["TestZ.Int32"] = TestZInt32,
                ["TestZ.Int64"] = TestZInt64,
                ["TestZ.SByte"] = TestZSByte,
                ["TestZ.UInt16"] = TestZUInt16,
                ["TestZ.UInt32"] = TestZUInt32,
                ["TestZ.UInt64"] = TestZUInt64,
                ["Xor.Single"] = XorSingle,
                ["Xor.Double"] = XorDouble,
            };
        }
    }
}
