// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

// DIRECTIONS:
//    This file isn't very robust and makes several assumptions
//    You can execute it by calling "csi .\GenerateTests.csx"
//
//    csi can be found under the <repo-root>\tools\net46\roslyn directory
//    It must be run such from the directory that contains the csx script
//
//    New tests can be generated from the template by adding an entry to the
//    appropriate Inputs array below.
//
//    You can support a new Isa by creating a new array and adding a new
//    "ProcessInputs" call at the bottom of the script.

private const string AlternatingOpTest_ValidationLogic = @"for (var i = 0; i < RetElementCount; i += 2)
            {
                if ({ValidateFirstResult})
                {
                    succeeded = false;
                    break;
                }

                if ({ValidateRemainingResults})
                {
                    succeeded = false;
                    break;
                }
            }";

private const string BooleanCmpTest_ValidationLogic = @"if ({ValidateFirstResult})
            {
                succeeded = false;
            }";

private const string BooleanTwoCmpTest_ValidationLogic = @"var expectedResult1 = true;

            for (var i = 0; i < Op1ElementCount; i++)
            {
                expectedResult1 &= ({ValidateFirstResult});
            }

            var expectedResult2 = true;

            for (var i = 0; i < Op1ElementCount; i++)
            {
                expectedResult2 &= ({ValidateRemainingResults});
            }

            succeeded = (((expectedResult1 == false) && (expectedResult2 == false)) == result);";

private const string BooleanOpTest_ValidationLogic = @"var expectedResult = true;

            for (var i = 0; i < Op1ElementCount; i++)
            {
                expectedResult &= ({ValidateFirstResult});
            }

            succeeded = (expectedResult == result);";

private const string HorizontalOpTest_ValidationLogic = @"for (var outer = 0; outer < (LargestVectorSize / 16); outer++)
            {
                for (var inner = 0; inner < (8 / sizeof({RetBaseType})); inner++)
                {
                    var i1 = (outer * (16 / sizeof({RetBaseType}))) + inner;
                    var i2 = i1 + (8 / sizeof({RetBaseType}));
                    var i3 = (outer * (16 / sizeof({RetBaseType}))) + (inner * 2);

                    if ({ValidateFirstResult})
                    {
                        succeeded = false;
                        break;
                    }

                    if ({ValidateRemainingResults})
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

private const string SimpleOpTest_ValidationLogic = @"if ({ValidateFirstResult})
            {
                succeeded = false;
            }
            else
            {
                for (var i = 1; i < RetElementCount; i++)
                {
                    if ({ValidateRemainingResults})
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

private static readonly (string templateFileName, string outputTemplateName, Dictionary<string, string> templateData)[] Templates = new[]
{
    ("_BinaryOpTestTemplate.template",        "AlternatingBinOpTest.template",  new Dictionary<string, string> { ["TemplateName"] = "Alternating", ["TemplateValidationLogic"] = AlternatingOpTest_ValidationLogic }),
    ("_BinaryOpTestTemplate.template",        "HorizontalBinOpTest.template",   new Dictionary<string, string> { ["TemplateName"] = "Horizontal",  ["TemplateValidationLogic"] = HorizontalOpTest_ValidationLogic }),
    ("_BinaryOpTestTemplate.template",        "SimpleBinOpTest.template",       new Dictionary<string, string> { ["TemplateName"] = "Simple",      ["TemplateValidationLogic"] = SimpleOpTest_ValidationLogic }),
    ("_BooleanBinaryOpTestTemplate.template", "BooleanBinOpTest.template",      new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanOpTest_ValidationLogic }),
    ("_BooleanBinaryOpTestTemplate.template", "BooleanCmpOpTest.template",      new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanCmpTest_ValidationLogic }),
    ("_BooleanBinaryOpTestTemplate.template", "BooleanTwoCmpOpTest.template",   new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanTwoCmpTest_ValidationLogic }),
    ("_BooleanUnaryOpTestTemplate.template",  "BooleanUnOpTest.template",       new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanOpTest_ValidationLogic }),
    ("_TernaryOpTestTemplate.template",       "AlternatingTernOpTest.template", new Dictionary<string, string> { ["TemplateName"] = "Alternating", ["TemplateValidationLogic"] = AlternatingOpTest_ValidationLogic }),
    ("_TernaryOpTestTemplate.template",       "SimpleTernOpTest.template",      new Dictionary<string, string> { ["TemplateName"] = "Simple",      ["TemplateValidationLogic"] = SimpleOpTest_ValidationLogic }),
    ("_UnaryOpTestTemplate.template",         "SimpleUnOpTest.template",        new Dictionary<string, string> { ["TemplateName"] = "Simple",      ["TemplateValidationLogic"] = SimpleOpTest_ValidationLogic }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse1Inputs = new []
{
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "AddScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(~BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(~BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarEqual",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedEqual",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarGreaterThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedGreaterThan",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedGreaterThan",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarGreaterThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedGreaterThanOrEqual",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedGreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarLessThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedLessThan",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedLessThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarLessThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedLessThanOrEqual",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedLessThanOrEqual",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotEqual",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedNotEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedNotEqual",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotGreaterThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotGreaterThanOrEqual",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotLessThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotLessThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((!float.IsNaN(left[i]) && !float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrdered",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((float.IsNaN(left[i]) || float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnordered",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpConvTest.template",new Dictionary<string, string>{["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "ConvertScalarToVector128Single",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single",                                  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(float)right != result[0]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "DivideScalar",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse",                      ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse",                      ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                            ["ValidateRemainingResults"] = "0 != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(Math.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MaxScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(Math.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MinScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Multiply",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] * right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MultiplyScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "SubtractScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse1X64Inputs = new []
{
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse.X64", ["LoadIsa"] = "Sse", ["Method"] = "ConvertToInt64",                                                  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                          ["ValidateFirstResult"] = "(long)Math.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse.X64", ["LoadIsa"] = "Sse", ["Method"] = "ConvertToInt64WithTruncation",                                    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                          ["ValidateFirstResult"] = "(long) firstOp[0] != result"}),
    ("SimpleBinOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse.X64", ["LoadIsa"] = "Sse", ["Method"] = "ConvertScalarToVector128Single", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                    ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "(float)right != result[0]"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse2Inputs = new []
{
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] + right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(~BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(~BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                                                                         ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Average",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)((left[0] + right[0] + 1) >> 1) != result[0]",                                                                                 ["ValidateRemainingResults"] = "(byte)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Average",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)((left[0] + right[0] + 1) >> 1) != result[0]",                                                                               ["ValidateRemainingResults"] = "(ushort)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((byte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((byte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((short)(-1)) : 0)",                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ushort)(-1)) : 0)",                                                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ushort)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarEqual",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedEqual",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((short)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarGreaterThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedGreaterThan",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedGreaterThan",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarGreaterThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedGreaterThanOrEqual",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedGreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((short)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((int)(-1)) : 0)",                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarLessThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedLessThan",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedLessThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarLessThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedLessThanOrEqual",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedLessThanOrEqual",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotEqual",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedNotEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedNotEqual",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotGreaterThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotGreaterThanOrEqual",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotLessThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotLessThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((!double.IsNaN(left[i]) && !double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrdered",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((double.IsNaN(left[i]) || double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnordered",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt32",                                                            ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "(int)Math.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt32",                                                            ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt32WithTruncation",                                              ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "(int) firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToUInt32",                                                           ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Double",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Double",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i % 2]) != BitConverter.DoubleToInt64Bits(firstOp[i % 2])"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "result[0] != (int)Math.Round(firstOp[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != ((i < 2) ? (int)Math.Round(firstOp[i]) : 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "result[0] != (int)MathF.Round(firstOp[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (int) MathF.Round(firstOp[i], 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32WithTruncation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                       ["ValidateRemainingResults"] = "result[i] != ((i < 2) ? (int)firstOp[i] : 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32WithTruncation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Single",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((float)firstOp[0])",                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((i < 2) ? BitConverter.SingleToInt32Bits((float)firstOp[i]) : 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Single",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((float)firstOp[0])",                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((float)firstOp[i])"}),
    ("SimpleBinOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Double",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(double)right != result[0]"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Int32",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",                                   ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp != result[0]",                                                                                                               ["ValidateRemainingResults"] = "false"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128UInt32",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",                                  ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp != result[0]",                                                                                                               ["ValidateRemainingResults"] = "false"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "DivideScalar",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                               ["Data"] = "(short)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)0",                                                                                  ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                              ["Data"] = "(ushort)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)0",                                                                                 ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                               ["Data"] = "(short)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)0",                                                                                  ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                              ["Data"] = "(ushort)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)0",                                                                                 ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                            ["ValidateRemainingResults"] = "0 != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "Math.Max(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Max(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "Math.Max(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Max(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MaxScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "Math.Min(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Min(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "Math.Min(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Min(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MinScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Multiply",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] * right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddAdjacent",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), int.MinValue, int.MaxValue)",                                 ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), int.MinValue, int.MaxValue)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[0])) * right[0]), 0)",                                           ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[0])) * right[0]), 0)",                                         ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[i])) * right[i]), 0)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveMask",                                                                  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "((firstOp[0] & 128) == 0) != ((result & 1) == 0)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveMask",                                                                  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "(firstOp[0] >= 0) != ((result & 1) == 0)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveMask",                                                                  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) >= 0) != ((result & 1) == 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] | right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] | right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "PackSignedSaturate",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (short)Math.Min(Math.Max(left[0], short.MinValue), short.MaxValue)",                                                    ["ValidateRemainingResults"] = "result[i] != ((i < 4) ? (short)Math.Min(Math.Max(left[i], short.MinValue), short.MaxValue) : (short)Math.Min(Math.Max(right[i%4], short.MinValue), short.MaxValue))"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "PackSignedSaturate",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (sbyte)Math.Min(Math.Max(left[0], sbyte.MinValue), sbyte.MaxValue)",                                                    ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (sbyte)Math.Min(Math.Max(left[i], sbyte.MinValue), sbyte.MaxValue) : (sbyte)Math.Min(Math.Max(right[i%8], sbyte.MinValue), sbyte.MaxValue))"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "PackUnsignedSaturate",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (byte)Math.Min(Math.Max(left[0], byte.MinValue), byte.MaxValue)",                                                       ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (byte)Math.Min(Math.Max(left[i], byte.MinValue), byte.MaxValue) : (byte)Math.Min(Math.Max(right[i%8], byte.MinValue), byte.MaxValue))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] << 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(ushort)(firstOp[0] << 1) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(ushort)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] << 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "(uint)(firstOp[0] << 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(uint)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "(long)(firstOp[0] << 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(long)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "(ulong)(firstOp[0] << 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(ulong)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 0",                                                                                                                     ["ValidateRemainingResults"] =  "result[i] != 8"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 0",                                                                                                                     ["ValidateRemainingResults"] =  "result[i] != 8"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)8",                                                                                 ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)8",                                                                                    ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] >> 15) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 15) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] >> 31) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 31) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(ushort)(firstOp[0] >> 1) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(ushort)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "(uint)(firstOp[0] >> 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(uint)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "(long)(firstOp[0] >> 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(long)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "(ulong)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(ulong)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 8",                                                                                                                     ["ValidateRemainingResults"] = "(i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 8",                                                                                                                     ["ValidateRemainingResults"] = "(i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] = "(i == 7 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)8",                                                                                 ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] = "(i == 7 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)8",                                                                                    ["ValidateFirstResult"] = "result[0] != 134217728",                                                                                                             ["ValidateRemainingResults"] = "(i == 3 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 134217728",                                                                                                             ["ValidateRemainingResults"] = "(i == 3 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 576460752303423488L",                                                                                                   ["ValidateRemainingResults"] = "(result[i] != 0)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 576460752303423488UL",                                                                                                  ["ValidateRemainingResults"] = "(result[i] != 0)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmBinOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                         ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[0])"}),
    ("ImmBinOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                         ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[0])"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[4] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[4] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[5] != result[4]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[5] != result[4]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("StoreUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "StoreScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "value[0] != result[0]",                                                                                                              ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("StoreUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "StoreScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "value[0] != result[0]",                                                                                                              ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] - right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] - right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SumAbsoluteDifferences",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",    ["ValidateFirstResult"] = "result[0] != Math.Abs(left[0] - right[0]) + Math.Abs(left[1] - right[1]) + Math.Abs(left[2] - right[2]) + Math.Abs(left[3] - right[3]) + Math.Abs(left[4] - right[4]) + Math.Abs(left[5] - right[5]) + Math.Abs(left[6] - right[6]) + Math.Abs(left[7] - right[7])",    ["ValidateRemainingResults"] = "result[i] != (i != 4 ? 0 : Math.Abs(left[8] - right[8]) + Math.Abs(left[9] - right[9]) + Math.Abs(left[10] - right[10]) + Math.Abs(left[11] - right[11]) + Math.Abs(left[12] - right[12]) + Math.Abs(left[13] - right[13]) + Math.Abs(left[14] - right[14]) + Math.Abs(left[15] - right[15]))"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i/2+1]) : BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[(i - 1)/2 + 1])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != left[1] || result[1] != right[1]",                                                                                      ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 1] : result[i] != right[(i - 1)/2 + 1]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != left[1] || result[1] != right[1]",                                                                                      ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 1] : result[i] != right[(i - 1)/2 + 1]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != left[2]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 2] : result[i] != right[(i - 1)/2 + 2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != left[2]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 2] : result[i] != right[(i - 1)/2 + 2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != left[4]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 4] : result[i] != right[(i - 1)/2 + 4]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != left[4]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 4] : result[i] != right[(i - 1)/2 + 4]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != left[8]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 8] : result[i] != right[(i - 1)/2 + 8]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != left[8]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2 + 8] : result[i] != right[(i - 1)/2 + 8]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i/2]) : BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[(i - 1)/2])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != left[0] || result[1] != right[0]",                                                                                      ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != left[0] || result[1] != right[0]",                                                                                      ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "(i % 2 == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] ^ right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] ^ right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] ^ right[i]) != result[i]"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse2X64Inputs = new []
{
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt64",                                                  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                          ["ValidateFirstResult"] = "(long)Math.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt64",                                                  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToUInt64",                                                 ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt64WithTruncation",                                    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                          ["ValidateFirstResult"] = "(long)firstOp[0] != result"}),
    ("SimpleBinOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Double", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                    ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "(double)right != result[0]"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Int64",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",                                   ["Op1BaseType"] = "Int64",                                                                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "firstOp != result[0]",                                                                         ["ValidateRemainingResults"] = "false"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128UInt64", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",                                  ["Op1BaseType"] = "UInt64",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "firstOp != result[0]",                                                                         ["ValidateRemainingResults"] = "false"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse3Inputs = new []
{
    ("AlternatingBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "AddSubtract",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i] - right[i])",       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i + 1]) != BitConverter.DoubleToInt64Bits(left[i + 1] + right[i + 1])"}),
    ("AlternatingBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse" , ["Method"] = "AddSubtract",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i] - right[i])",       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i + 1]) != BitConverter.SingleToInt32Bits(left[i + 1] + right[i + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i1]) != BitConverter.DoubleToInt64Bits(left[i3] + left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i2]) != BitConverter.DoubleToInt64Bits(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse",  ["Method"] = "HorizontalAdd",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i1]) != BitConverter.SingleToInt32Bits(left[i3] + left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i2]) != BitConverter.SingleToInt32Bits(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i1]) != BitConverter.DoubleToInt64Bits(left[i3] - left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i2]) != BitConverter.DoubleToInt64Bits(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse",  ["Method"] = "HorizontalSubtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i1]) != BitConverter.SingleToInt32Bits(left[i3] - left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i2]) != BitConverter.SingleToInt32Bits(right[i3] - right[i3 + 1])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Ssse3Inputs = new []
{
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                        ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])",                                                                      ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                        ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])",                                                                      ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                        ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])",                                                                      ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",  ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",       ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",       ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 15 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 15 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 7 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",     ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",     ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 7 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["Imm"] = "4",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 3 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",["Imm"] = "4",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 3 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["Imm"] = "8",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 1 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",     ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",["Imm"] = "8",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",     ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 1 ? left[0] : right[i+1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != (short)(left[i3] + left[i3 + 1])",                                                         ["ValidateRemainingResults"] = "result[i2] != (short)(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["ValidateFirstResult"] = "result[i1] != (int)(left[i3] + left[i3 + 1])",                                                           ["ValidateRemainingResults"] = "result[i2] != (int)(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAddSaturate",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != Math.Clamp((left[i3] + left[i3 + 1]), short.MinValue, short.MaxValue)",                    ["ValidateRemainingResults"] = "result[i2] != Math.Clamp((right[i3] + right[i3 + 1]), short.MinValue, short.MaxValue)"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != (short)(left[i3] - left[i3 + 1])",                                                         ["ValidateRemainingResults"] = "result[i2] != (short)(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["ValidateFirstResult"] = "result[i1] != (int)(left[i3] - left[i3 + 1])",                                                           ["ValidateRemainingResults"] = "result[i2] != (int)(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtractSaturate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != Math.Clamp((left[i3] - left[i3 + 1]), short.MinValue, short.MaxValue)",                    ["ValidateRemainingResults"] = "result[i2] != Math.Clamp((right[i3] - right[i3 + 1]), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddAdjacent",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), short.MinValue, short.MaxValue)", ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyHighRoundScale",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[0] != (short)((((left[0] * right[0]) >> 14) + 1) >> 1)",                                          ["ValidateRemainingResults"] = "result[i] != (short)((((left[i] * right[i]) >> 14) + 1) >> 1)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",  ["ValidateFirstResult"] = "result[0] != ((right[0] > 127) ? 0 : left[right[0] & 0x0F])",                                            ["ValidateRemainingResults"] = "result[i] != ((right[i] > 127) ? 0 : left[right[i] & 0x0F])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? 0 : left[right[0] & 0x0F])",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? 0 : left[right[i] & 0x0F])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (sbyte)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                         ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (sbyte)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (short)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                         ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (short)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (int)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                           ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (int)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse41Inputs = new []
{
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "(byte)(((i % 2) == 0) ? 128 : 1)",      ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                                  ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "(double)(((i % 2) == 0) ? -0.0 : 1.0)", ["ValidateFirstResult"] = "((BitConverter.DoubleToInt64Bits(thirdOp[0]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[0]) != BitConverter.DoubleToInt64Bits(result[0]) : BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.DoubleToInt64Bits(thirdOp[i]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[i]) != BitConverter.DoubleToInt64Bits(result[i]) : BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "(sbyte)(((i % 2) == 0) ? -128 : 1)",    ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                                  ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "(float)(((i % 2) == 0) ? -0.0 : 1.0)",  ["ValidateFirstResult"] = "((BitConverter.SingleToInt32Bits(thirdOp[0]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[0]) != BitConverter.SingleToInt32Bits(result[0]) : BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.SingleToInt32Bits(thirdOp[i]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[i]) != BitConverter.SingleToInt32Bits(result[i]) : BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToInt16(\"0xFFFF\", 16) : (short)0)",      ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToUInt16(\"0xFFFF\", 16) : (ushort)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToInt32(\"0xFFFFFFFF\", 16) : (int)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToUInt32(\"0xFFFFFFFF\", 16) : (uint)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToInt64(\"0xFFFFFFFFFFFFFFFF\", 16) : (long)0)",   ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                        ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt64",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToUInt64(\"0xFFFFFFFFFFFFFFFF\", 16): (ulong)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                        ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Ceiling",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Ceiling",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CeilingScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(right[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "CeilingScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(right[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1]))"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                    ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Floor",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Floor",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "FloorScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "FloorScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["Data"] = "(byte)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["Data"] = "(sbyte)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["Data"] = "(int)2",   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["Data"] = "(uint)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(0.0f)",                                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "i == 1 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(0.0f) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "4",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "i == 2 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(0.0f) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "8",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "i == 3 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(0.0f) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i == 1 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[0]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i == 2 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[0]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "48",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i == 3 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[0]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[1])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "128", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[2])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["Data"] = "(byte)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["Data"] = "(sbyte)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["Data"] = "(int)2",   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["Data"] = "(uint)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(0.0f)",                                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "192", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[3])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[0])) * right[0]), 0)",                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[0])) * right[0]), 0)",                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[i])) * right[i]), 0)"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "PackUnsignedSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[i1] != ((left[i3 - inner] > 0xFFFF) ? 0xFFFF : ((left[i3 - inner] < 0) ? 0 : BitConverter.ToUInt16(BitConverter.GetBytes(left[i3 - inner]), 0)))",                                                                                            ["ValidateRemainingResults"] = "result[i2] != ((right[i3 - inner] > 0xFFFF) ? 0xFFFF : ((right[i3 - inner] < 0) ? 0 : BitConverter.ToUInt16(BitConverter.GetBytes(right[i3 - inner]), 0)))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirection",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirection",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestInteger",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestInteger",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(right[0], MidpointRounding.AwayFromZero))",                                                                                                                   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(right[0], MidpointRounding.AwayFromZero))",                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(right[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(right[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToZero",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((firstOp[0] > 0) ? Math.Floor(firstOp[0]) : Math.Ceiling(firstOp[0]))",                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((firstOp[i] > 0) ? Math.Floor(firstOp[i]) : Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToZero",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((firstOp[0] > 0) ? MathF.Floor(firstOp[0]) : MathF.Ceiling(firstOp[0]))",                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((firstOp[i] > 0) ? MathF.Floor(firstOp[i]) : MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToZeroScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((right[0] > 0) ? Math.Floor(right[0]) : Math.Ceiling(right[0]))",                                                                                                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToZeroScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((right[0] > 0) ? MathF.Floor(right[0]) : MathF.Ceiling(right[0]))",                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse41_OverloadedInputs = new []
{
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse41X64Inputs = new []
{
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["Data"] = "(long)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["Data"] = "(ulong)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["Data"] = "(long)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["Data"] = "(ulong)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse42Inputs = new []
{
    ("SimpleBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse42", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Avx1Inputs = new []
{
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Add",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Add",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AddSubtract",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "((i % 2 != 0) && (BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i]))) || ((i % 2 == 0) && (BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AddSubtract",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "((i % 2 != 0) && (BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i]))) || ((i % 2 == 0) && (BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "And",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "And",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AndNot",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "((~BitConverter.DoubleToInt64Bits(left[0])) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                               ["ValidateRemainingResults"] = "((~BitConverter.DoubleToInt64Bits(left[i])) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AndNot",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "((~BitConverter.SingleToInt32Bits(left[0])) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                               ["ValidateRemainingResults"] = "((~BitConverter.SingleToInt32Bits(left[i])) & BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "BlendVariable",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "(double)(((i % 2) == 0) ? -0.0 : 1.0)", ["ValidateFirstResult"] = "((BitConverter.DoubleToInt64Bits(thirdOp[0]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[0]) != BitConverter.DoubleToInt64Bits(result[0]) : BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.DoubleToInt64Bits(thirdOp[i]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[i]) != BitConverter.DoubleToInt64Bits(result[i]) : BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "BlendVariable",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "(float)(((i % 2) == 0) ? -0.0 : 1.0)",  ["ValidateFirstResult"] = "((BitConverter.SingleToInt32Bits(thirdOp[0]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[0]) != BitConverter.SingleToInt32Bits(result[0]) : BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.SingleToInt32Bits(thirdOp[i]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[i]) != BitConverter.SingleToInt32Bits(result[i]) : BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastScalarToVector128",["RetVectorType"]="Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastScalarToVector256",["RetVectorType"]="Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastScalarToVector256",["RetVectorType"]="Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastVector128ToVector256",["RetVectorType"]="Vector256",["RetBaseType"]= "Single",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (i < 4 ? BitConverter.SingleToInt32Bits(firstOp[i]) : BitConverter.SingleToInt32Bits(firstOp[i-4]))"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastVector128ToVector256",["RetVectorType"]="Vector256",["RetBaseType"]= "Double",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (i < 2 ? BitConverter.DoubleToInt64Bits(firstOp[i]) : BitConverter.DoubleToInt64Bits(firstOp[i-2]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Ceiling",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Ceiling",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThan",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThan",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThanOrEqual",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThanOrEqual",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThan",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThan",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThanOrEqual",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThanOrEqual",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotEqual",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotEqual",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThan",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThan",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThanOrEqual", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThan",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThan",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThanOrEqual",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThanOrEqual",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareOrdered",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((!float.IsNaN(left[i]) && !float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareOrdered",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((!double.IsNaN(left[i]) && !double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareUnordered",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((float.IsNaN(left[i]) || float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareUnordered",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((double.IsNaN(left[i]) || double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Divide",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Divide",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateEvenIndexed",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(i % 2 == 0) ? (BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(firstOp[i - 1]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateEvenIndexed",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(i % 2 == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i - 1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateOddIndexed",     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(i % 2 == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i + 1]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[4])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i+4])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i+2])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                                                     ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+2]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+2]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                       ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 16 ? left[i] : right[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                      ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 16 ? left[i] : right[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                      ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 8 ? left[i] : right[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                     ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 8 ? left[i] : right[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                      ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 4 ? left[i] : right[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                     ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 4 ? left[i] : right[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                      ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 2 ? left[i] : right[i-2])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                     ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 2 ? left[i] : right[i-2])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (i < 4 ? BitConverter.SingleToInt32Bits(left[i]) : BitConverter.SingleToInt32Bits(right[i-4]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                     ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (i < 2 ? BitConverter.DoubleToInt64Bits(left[i]) : BitConverter.DoubleToInt64Bits(right[i-2]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Floor",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Floor",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                                                                      ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[0]) < 0) ? left[0] : 0)",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[0]) < 0) ? left[0] : 0)",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[0]) < 0) ? right[0] : BitConverter.DoubleToInt64Bits(result[0]))",                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[i]) < 0) ? right[i] : BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[0]) < 0) ? right[0] : BitConverter.SingleToInt32Bits(result[0]))",                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[i]) < 0) ? right[i] : BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Max",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Max",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Min",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Min",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Multiply",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] * right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Multiply",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] * right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Or",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Or",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[4]) != BitConverter.SingleToInt32Bits(firstOp[5])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[1])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[2]) != BitConverter.DoubleToInt64Bits(firstOp[2]) || BitConverter.DoubleToInt64Bits(result[2]) != BitConverter.DoubleToInt64Bits(firstOp[2])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse", ["Method"] = "Permute",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[1]) != BitConverter.SingleToInt32Bits(firstOp[0]) || BitConverter.SingleToInt32Bits(result[2]) != BitConverter.SingleToInt32Bits(firstOp[0])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "Permute",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[1]) != BitConverter.DoubleToInt64Bits(firstOp[1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (i < 2 ? BitConverter.DoubleToInt64Bits(right[i]) : BitConverter.DoubleToInt64Bits(left[i-2]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (i < 4 ? BitConverter.SingleToInt32Bits(right[i]) : BitConverter.SingleToInt32Bits(left[i-4]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                        ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 16 ? right[i] : left[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 16 ? right[i] : left[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 8 ? right[i] : left[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 8 ? right[i] : left[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 4 ? right[i] : left[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 4 ? right[i] : left[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 2 ? right[i] : left[i-2])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 2 ? right[i] : left[i-2])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "1",                                                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i > 3 ? (BitConverter.SingleToInt32Bits(left[5]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "(long)1",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i > 1 ? (BitConverter.DoubleToInt64Bits(left[2]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundCurrentDirection",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundCurrentDirection",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNearestInteger",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNearestInteger",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNegativeInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNegativeInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToPositiveInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToPositiveInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToZero",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((firstOp[0] > 0) ? Math.Floor(firstOp[0]) : Math.Ceiling(firstOp[0]))",                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((firstOp[i] > 0) ? Math.Floor(firstOp[i]) : Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToZero",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((firstOp[0] > 0) ? MathF.Floor(firstOp[0]) : MathF.Ceiling(firstOp[0]))",                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((firstOp[i] > 0) ? MathF.Floor(firstOp[i]) : MathF.Ceiling(firstOp[i]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Shuffle",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[1])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[7]) != BitConverter.SingleToInt32Bits(right[4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Shuffle",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[3]) != BitConverter.DoubleToInt64Bits(right[2])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Subtract",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Subtract",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Xor",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Xor",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Avx1_Vector128Inputs = new []
{
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[0]) < 0) ? left[0] : 0)",                                         ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[0]) < 0) ? left[0] : 0)",                                         ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[0]) < 0) ? right[0] : BitConverter.DoubleToInt64Bits(result[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[i]) < 0) ? right[i] : BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[0]) < 0) ? right[0] : BitConverter.SingleToInt32Bits(result[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[i]) < 0) ? right[i] : BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "1",                                 ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "(long)1",                           ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Avx2Inputs = new []
{
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] + right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "5",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != right[5]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 11) ? right[i + 5] : left[i - 11]) : ((i < 27) ? right[i + 5] : left[i - 11])))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "27",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != left[11]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 5) ? left[i + 11] : 0) : ((i < 21) ? left[i + 11] : 0)))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "250", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "5",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != right[5]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 11) ? right[i + 5] : left[i - 11]) : ((i < 27) ? right[i + 5] : left[i - 11])))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "27",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != left[11]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 5) ? left[i + 11] : 0) : ((i < 21) ? left[i + 11] : 0)))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "250", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (i == 7 ? left[0] : right[i+1]) : (i == 15 ? left[8] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (i == 7 ? left[0] : right[i+1]) : (i == 15 ? left[8] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (i == 3 ? left[0] : right[i+1]) : (i == 7 ? left[4] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (i == 3 ? left[0] : right[i+1]) : (i == 7 ? left[4] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "8",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 2 ? (i == 1 ? left[0] : right[i+1]) : (i == 3 ? left[2] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "8",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 2 ? (i == 1 ? left[0] : right[i+1]) : (i == 3 ? left[2] : right[i+1]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                              ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Average",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)((left[0] + right[0] + 1) >> 1) != result[0]",                                      ["ValidateRemainingResults"] = "(byte)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Average",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)((left[0] + right[0] + 1) >> 1) != result[0]",                                    ["ValidateRemainingResults"] = "(ushort)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((1 & (1 << i)) == 0) ? left[i] : right[i]) : (((1 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((2 & (1 << i)) == 0) ? left[i] : right[i]) : (((2 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((4 & (1 << i)) == 0) ? left[i] : right[i]) : (((4 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((85 & (1 << i)) == 0) ? left[i] : right[i]) : (((85 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((1 & (1 << i)) == 0) ? left[i] : right[i]) : (((1 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((2 & (1 << i)) == 0) ? left[i] : right[i]) : (((2 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((4 & (1 << i)) == 0) ? left[i] : right[i]) : (((4 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((85 & (1 << i)) == 0) ? left[i] : right[i]) : (((85 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Byte",                   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "(byte)(((i % 2) == 0) ? 128 : 1)",   ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",       ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "SByte",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "(sbyte)(((i % 2) == 0) ? -128 : 1)", ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",       ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int16",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToInt16(\"0xFFFF\", 16) : (short)0)",      ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt16",                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToUInt16(\"0xFFFF\", 16) : (ushort)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int32",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToInt32(\"0xFFFFFFFF\", 16) : (int)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt32",                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToUInt32(\"0xFFFFFFFF\", 16) : (uint)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int64",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToInt64(\"0xFFFFFFFFFFFFFFFF\", 16) : (long)0)",   ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",      ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt64",                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "(((i % 2) == 0) ? Convert.ToUInt64(\"0xFFFFFFFFFFFFFFFF\", 16): (ulong)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",      ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse",  ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse",  ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((byte)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((byte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((short)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                         ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((sbyte)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ushort)(-1)) : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ushort)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((short)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                          ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)",                         ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((sbyte)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimdScalarUnOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ConvertToInt32",                                               ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result != firstOp[0]"}),
    ("SimdScalarUnOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ConvertToUInt32",                                              ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "result != firstOp[0]"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                           ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                              ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                             ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((right[0] & (1U << 31)) != 0) ? left[0] : 0)",                             ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1U << 31)) != 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                             ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != (((right[0] & (1UL << 63)) != 0) ? left[0] : 0)",                            ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1UL << 63)) != 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "result[0] != (((left[0] & (1U << 31)) != 0)  ? right[0] : result[0])",                    ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1U << 31)) != 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                            ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != (((left[0] & (1UL << 63)) != 0)  ? right[0] : result[0])",                   ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1UL << 63)) != 0) ? right[i] : result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyAddAdjacent",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), short.MinValue, short.MaxValue)",      ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyAddAdjacent",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), int.MinValue, int.MaxValue)",          ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), int.MinValue, int.MaxValue)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyHighRoundScale",      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (short)((((left[0] * right[0]) >> 14) + 1) >> 1)",                                               ["ValidateRemainingResults"] = "result[i] != (short)((((left[i] * right[i]) >> 14) + 1) >> 1)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyHigh",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt16(BitConverter.GetBytes((((int)(left[0])) * right[0]) >> 16), 0)",            ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt16(BitConverter.GetBytes((((int)(left[i])) * right[i]) >> 16), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyHigh",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt16(BitConverter.GetBytes((((uint)(left[0])) * right[0]) >> 16), 0)",          ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt16(BitConverter.GetBytes((((uint)(left[i])) * right[i]) >> 16), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[0])) * right[0]), 0)",                   ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[0])) * right[0]), 0)",                    ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[0])) * right[0]), 0)",                 ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[0])) * right[0]), 0)",                  ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[i])) * right[i]), 0)"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultipleSumAbsoluteDifferences",["RetVectorType"]="Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != (Math.Abs(left[0]-right[0])+Math.Abs(left[1]-right[1])+Math.Abs(left[2]-right[2])+Math.Abs(left[3]-right[3]))",                                                                   ["ValidateRemainingResults"] = "result[i] != Math.Abs(left[i%8+(i>7?16:0)]-right[0+(i>7?16:0)])+Math.Abs(left[i%8+1+(i>7?16:0)]-right[1+(i>7?16:0)])+Math.Abs(left[i%8+2+(i>7?16:0)]-right[2+(i>7?16:0)])+Math.Abs(left[i%8+3+(i>7?16:0)]-right[3+(i>7?16:0)])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] | right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] | right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackUnsignedSaturate",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (ushort)Math.Clamp(left[0], ushort.MinValue, ushort.MaxValue)",              ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (ushort)Math.Clamp(left[i], ushort.MinValue, ushort.MaxValue) : (i < 8 && i > 3 ? (ushort)Math.Clamp(right[i%4], ushort.MinValue, ushort.MaxValue) : (i < 12 && i > 7 ? (ushort)Math.Clamp(left[i-4], ushort.MinValue, ushort.MaxValue) : (ushort)Math.Clamp(right[i-8], ushort.MinValue, ushort.MaxValue))))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackUnsignedSaturate",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (byte)Math.Clamp(left[0], byte.MinValue, byte.MaxValue)",                    ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (byte)Math.Clamp(left[i], byte.MinValue, byte.MaxValue) : (i < 16 && i > 7 ? (byte)Math.Clamp(right[i%8], byte.MinValue, byte.MaxValue) : (i < 24 && i > 15 ? (byte)Math.Clamp(left[i-8], byte.MinValue, byte.MaxValue) : (byte)Math.Clamp(right[i-16], byte.MinValue, byte.MaxValue))))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackSignedSaturate",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (short)Math.Clamp(left[0], short.MinValue, short.MaxValue)",                 ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (short)Math.Clamp(left[i], short.MinValue, short.MaxValue) : (i < 8 && i > 3 ? (short)Math.Clamp(right[i%4], short.MinValue, short.MaxValue) : (i < 12 && i > 7 ? (short)Math.Clamp(left[i-4], short.MinValue, short.MaxValue) : (short)Math.Clamp(right[i-8], short.MinValue, short.MaxValue))))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackSignedSaturate",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (sbyte)Math.Clamp(left[0], sbyte.MinValue, sbyte.MaxValue)",                 ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (sbyte)Math.Clamp(left[i], sbyte.MinValue, sbyte.MaxValue) : (i < 16 && i > 7 ? (sbyte)Math.Clamp(right[i%8], sbyte.MinValue, sbyte.MaxValue) : (i < 24 && i > 15 ? (sbyte)Math.Clamp(left[i-8], sbyte.MinValue, sbyte.MaxValue) : (sbyte)Math.Clamp(right[i-16], sbyte.MinValue, sbyte.MaxValue))))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 3 ? (result[i] != left[i - 4]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 3 ? (result[i] != left[i - 4]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 1 ? (result[i] != left[i - 2]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 1 ? (result[i] != left[i - 2]) : (result[i] != right[i])"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute4x64",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                          ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[1]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[1])  != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute4x64",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                 ["ValidateRemainingResults"] = "firstOp[1] != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute4x64",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                 ["ValidateRemainingResults"] = "firstOp[1] != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PermuteVar8x32",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "left[(right[0] & 7)] != result[0]",                                                       ["ValidateRemainingResults"] = "left[(right[i] & 7)] != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PermuteVar8x32",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "left[(right[0] & (uint)7)] != result[0]",                                                 ["ValidateRemainingResults"] = "left[(right[i] & (uint)7)] != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PermuteVar8x32",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[(right[0] & 7)]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[(right[i] & 7)]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] << 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "(ushort)(firstOp[0] << 1) != result[0]",                                                  ["ValidateRemainingResults"] = "(ushort)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] << 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "(uint)(firstOp[0] << 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(uint)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "(long)(firstOp[0] << 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(long)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "(ulong)(firstOp[0] << 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(ulong)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "(i == 16 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "(i == 16 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)8",                                                                                                                                          ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)8",                                                                                                                                             ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] >> 15) != result[0]",                                                  ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 15) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] >> 31) != result[0]",                                                    ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 31) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmeticVariable",["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "(TestLibrary.Generator.GetUInt32()%32)",                                                      ["ValidateFirstResult"] = "(int)(left[0] >> (int)right[0]) != result[0]",                                            ["ValidateRemainingResults"] = "(int)(left[i] >> (int)right[i]) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "(ushort)(firstOp[0] >> 1) != result[0]",                                                  ["ValidateRemainingResults"] = "(ushort)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "(uint)(firstOp[0] >> 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(uint)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "(long)(firstOp[0] >> 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(long)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "(ulong)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(ulong)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 8",                                                                          ["ValidateRemainingResults"] = "(i == 31 || i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 8",                                                                          ["ValidateRemainingResults"] = "(i == 31 || i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "(i == 7 || i == 15 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)8",                                                                                                                                          ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "(i == 7 || i == 15 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)8",                                                                                                                                             ["ValidateFirstResult"] = "result[0] != 134217728",                                                                  ["ValidateRemainingResults"] = "(i == 3 || i == 7 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 134217728",                                                                  ["ValidateRemainingResults"] = "(i == 3 || i == 7 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 576460752303423488L",                                                        ["ValidateRemainingResults"] = "(i == 2 ? result[i] != 576460752303423488L : result[i] != 0)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 576460752303423488UL",                                                       ["ValidateRemainingResults"] = "(i == 2 ? result[i] != 576460752303423488UL : result[i] != 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Sign",                        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                            ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (sbyte)(-left[0]) : (right[0] > 0 ? left[0] : 0))",          ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (sbyte)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Sign",                        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                            ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (short)(-left[0]) : (right[0] > 0 ? left[0] : 0))",          ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (short)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Sign",                        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                            ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (int)(-left[0]) : (right[0] > 0 ? left[0] : 0))",            ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (int)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                             ["ValidateFirstResult"] = "result[0] != ((right[0] > 127) ? 0 : left[right[0] & 0x0F])",                             ["ValidateRemainingResults"] = "result[i] != (i < 16 ? (right[i] > 127 ? 0 : left[right[i] & 0x0F]) : (right[i] > 127 ? 0 : left[(right[i] & 0x0F) + 16]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                            ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? 0 : left[right[0] & 0x0F])",                               ["ValidateRemainingResults"] = "result[i] != (i < 16 ? (right[i] < 0 ? 0 : left[right[i] & 0x0F]) : (right[i] < 0 ? 0 : left[(right[i] & 0x0F) + 16]))"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[1]",                                                                 ["ValidateRemainingResults"] = "result[i] != (i < 4 ? firstOp[0] : (i == 4 ? firstOp[5] : firstOp[4]))"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[1]",                                                                 ["ValidateRemainingResults"] = "result[i] != (i < 4 ? firstOp[0] : (i == 4 ? firstOp[5] : firstOp[4]))"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleHigh",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleHigh",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleLow",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleLow",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "SumAbsoluteDifferences",      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != Math.Abs(left[0] - right[0]) + Math.Abs(left[1] - right[1]) + Math.Abs(left[2] - right[2]) + Math.Abs(left[3] - right[3]) + Math.Abs(left[4] - right[4]) + Math.Abs(left[5] - right[5]) + Math.Abs(left[6] - right[6]) + Math.Abs(left[7] - right[7])",    ["ValidateRemainingResults"] = "result[i] != ((i % 4 != 0) ? 0 : Math.Abs(left[(i/4)*8] - right[(i/4)*8]) + Math.Abs(left[(i/4)*8+1] - right[(i/4)*8+1]) + Math.Abs(left[(i/4)*8+2] - right[(i/4)*8+2]) + Math.Abs(left[(i/4)*8+3] - right[(i/4)*8+3]) + Math.Abs(left[(i/4)*8+4] - right[(i/4)*8+4]) + Math.Abs(left[(i/4)*8+5] - right[(i/4)*8+5]) + Math.Abs(left[(i/4)*8+6] - right[(i/4)*8+6]) + Math.Abs(left[(i/4)*8+7] - right[(i/4)*8+7]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] - right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] - right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] ^ right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] ^ right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] ^ right[i]) != result[i]"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Avx2_Vector128Inputs = new []
{
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "1",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "2",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "4",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "85", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "1",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "2",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "4",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "85", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((right[0] & (1U << 31)) != 0) ? left[0] : 0)",                              ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1U << 31)) != 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (((right[0] & (1UL << 63)) != 0) ? left[0] : 0)",                             ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1UL << 63)) != 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((left[0] & (1U << 31)) != 0) ? right[0] : result[0])",                      ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1U << 31)) != 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (((left[0] & (1UL << 63))  != 0) ? right[0] : result[0])",                    ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1UL << 63)) != 0) ? right[i] : result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmeticVariable",["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(TestLibrary.Generator.GetUInt32() % 32)", ["ValidateFirstResult"] = "(int)(left[0] >> (int)right[0]) != result[0]",                                      ["ValidateRemainingResults"] = "(int)(left[i] >> (int)right[i]) != result[i]"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Fma_Vector128Inputs = new []
{
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAdd",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[0] * secondOp[0]) + thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplyAdd",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[0] * secondOp[0]) + thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddNegated",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[0] * secondOp[0]) + thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[i] * secondOp[i]) + thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplyAddNegated",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[0] * secondOp[0]) + thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[i] * secondOp[i]) + thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddNegatedScalar",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[0] * secondOp[0]) + thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplyAddNegatedScalar",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[0] * secondOp[0]) + thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[0] * secondOp[0]) + thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplyAddScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[0] * secondOp[0]) + thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddSubtract",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i + 1] * secondOp[i + 1]) + thirdOp[i + 1], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i + 1], 9))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplyAddSubtract",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i + 1] * secondOp[i + 1]) + thirdOp[i + 1], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i + 1], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplySubtract",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[0] * secondOp[0]) - thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplySubtract",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[0] * secondOp[0]) - thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplySubtractAdd",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i + 1] * secondOp[i + 1]) - thirdOp[i + 1], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i + 1], 9))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplySubtractAdd",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i + 1] * secondOp[i + 1]) - thirdOp[i + 1], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i + 1], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplySubtractNegated",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[0] * secondOp[0]) - thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[i] * secondOp[i]) - thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplySubtractNegated",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[0] * secondOp[0]) - thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[i] * secondOp[i]) - thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplySubtractNegatedScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[0] * secondOp[0]) - thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplySubtractNegatedScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[0] * secondOp[0]) - thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplySubtractScalar",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[0] * secondOp[0]) - thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Sse",  ["Method"] = "MultiplySubtractScalar",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[0] * secondOp[0]) - thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Fma_Vector256Inputs = new []
{
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplyAdd",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[0] * secondOp[0]) + thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplyAdd",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[0] * secondOp[0]) + thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplyAddNegated",      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[0] * secondOp[0]) + thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[i] * secondOp[i]) + thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplyAddNegated",      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[0] * secondOp[0]) + thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[i] * secondOp[i]) + thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplyAddSubtract",     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i + 1] * secondOp[i + 1]) + thirdOp[i + 1], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i + 1], 9))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplyAddSubtract",     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i + 1] * secondOp[i + 1]) + thirdOp[i + 1], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i + 1], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplySubtract",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[0] * secondOp[0]) - thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplySubtract",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[0] * secondOp[0]) - thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) - thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplySubtractAdd",     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))",    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round((firstOp[i + 1] * secondOp[i + 1]) - thirdOp[i + 1], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i + 1], 9))"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplySubtractAdd",     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i] * secondOp[i]) + thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))",  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round((firstOp[i + 1] * secondOp[i + 1]) - thirdOp[i + 1], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i + 1], 3))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplySubtractNegated", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[0] * secondOp[0]) - thirdOp[0], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[0], 9))",   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Round(-(firstOp[i] * secondOp[i]) - thirdOp[i], 9)) != BitConverter.DoubleToInt64Bits(Math.Round(result[i], 9))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Fma", ["LoadIsa"] = "Avx", ["Method"] = "MultiplySubtractNegated", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[0] * secondOp[0]) - thirdOp[0], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[0], 3))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Round(-(firstOp[i] * secondOp[i]) - thirdOp[i], 3)) != BitConverter.SingleToInt32Bits(MathF.Round(result[i], 3))"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Bmi1Inputs = new []
{
    ("ScalarBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "AndNot",                  ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt32",                                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateResult"] = "isUnexpectedResult = ((~left & right) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "ExtractLowestSetBit",     ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32",                                                             ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateResult"] = "isUnexpectedResult = ((unchecked((uint)(-(int)data)) & data) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "GetMaskUpToLowestSetBit", ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32",                                                             ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateResult"] = "isUnexpectedResult = (((data - 1) ^ data) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "ResetLowestSetBit",       ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32",                                                             ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateResult"] = "isUnexpectedResult = (((data - 1) & data) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "TrailingZeroCount",       ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32",                                                             ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateResult"] = "uint expectedResult = 0; for (int index = 0; ((data >> index) & 1) == 0; index++) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarTernOpTest.template",new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "BitFieldExtract",         ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "Byte",   ["Op3BaseType"] = "Byte",       ["NextValueOp1"] = "0x1E000000",                        ["NextValueOp2"] = "25",     ["NextValueOp3"] = "4",    ["ValidateResult"] = "uint expectedResult = 15; isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Bmi1", ["Method"] = "BitFieldExtract",         ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt16",                                 ["NextValueOp1"] = "0x1E000000",                        ["NextValueOp2"] = "0x0419",                            ["ValidateResult"] = "uint expectedResult = 15; isUnexpectedResult = (expectedResult != result);" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Bmi1X64Inputs = new []
{
    ("ScalarBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "AndNot",                  ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt64",                             ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateResult"] = "isUnexpectedResult = ((~left & right) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "ExtractLowestSetBit",     ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64",                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateResult"] = "isUnexpectedResult = ((unchecked((ulong)(-(long)data)) & data) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "GetMaskUpToLowestSetBit", ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64",                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateResult"] = "isUnexpectedResult = (((data - 1) ^ data) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "ResetLowestSetBit",       ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64",                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateResult"] = "isUnexpectedResult = (((data - 1) & data) != result);" }),
    ("ScalarUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "TrailingZeroCount",       ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64",                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateResult"] = "ulong expectedResult = 0; for (int index = 0; ((data >> index) & 1) == 0; index++) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarTernOpTest.template",new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "BitFieldExtract",         ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "Byte",["Op3BaseType"] = "Byte",      ["NextValueOp1"] = "0x1E00000000000000",                ["NextValueOp2"] = "57",     ["NextValueOp3"] = "4",    ["ValidateResult"] = "ulong expectedResult = 15; isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Bmi1.X64", ["Method"] = "BitFieldExtract",         ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt16",                             ["NextValueOp1"] = "0x1E00000000000000",                ["NextValueOp2"] = "0x0439",                            ["ValidateResult"] = "ulong expectedResult = 15; isUnexpectedResult = (expectedResult != result);" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] AesInputs = new []
{
    ("AesBinOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Aes", ["LoadIsa"] = "Aes", ["Method"] = "Decrypt",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte", ["LargestVectorSize"] = "16", ["InputSize"] = "16", ["Input"] = "{0xef, 0xcd, 0xab, 0x89, 0x67, 0x45, 0x23, 0x01, 0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88}", ["KeySize"] = "16", ["Key"] = "{0xff, 0xdd, 0xbb, 0x99, 0x77, 0x55, 0x33, 0x11, 0xee, 0xcc, 0xaa, 0x88, 0x66, 0x44, 0x22, 0x00}", ["ExpectedRetSize"] = "16", ["ExpectedRet"] = "{0x8f, 0xc4, 0xfe, 0x76, 0x51, 0x4f, 0x4e, 0x04, 0xee, 0x39, 0xda, 0x81, 0xa3, 0xcf, 0x7e, 0xb5}"}),
    ("AesBinOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Aes", ["LoadIsa"] = "Aes", ["Method"] = "DecryptLast",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte", ["LargestVectorSize"] = "16", ["InputSize"] = "16", ["Input"] = "{0xef, 0xcd, 0xab, 0x89, 0x67, 0x45, 0x23, 0x01, 0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88}", ["KeySize"] = "16", ["Key"] = "{0xff, 0xdd, 0xbb, 0x99, 0x77, 0x55, 0x33, 0x11, 0xee, 0xcc, 0xaa, 0x88, 0x66, 0x44, 0x22, 0x00}", ["ExpectedRetSize"] = "16", ["ExpectedRet"] = "{0x9e, 0xbf, 0x72, 0x90, 0x7d, 0xd5, 0xca, 0x36, 0x93, 0xa4, 0xa4, 0x1f, 0x98, 0xdd, 0x10, 0xf2}"}),
    ("AesBinOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Aes", ["LoadIsa"] = "Aes", ["Method"] = "Encrypt",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte", ["LargestVectorSize"] = "16", ["InputSize"] = "16", ["Input"] = "{0xef, 0xcd, 0xab, 0x89, 0x67, 0x45, 0x23, 0x01, 0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88}", ["KeySize"] = "16", ["Key"] = "{0xff, 0xdd, 0xbb, 0x99, 0x77, 0x55, 0x33, 0x11, 0xee, 0xcc, 0xaa, 0x88, 0x66, 0x44, 0x22, 0x00}", ["ExpectedRetSize"] = "16", ["ExpectedRet"] = "{0xed, 0x42, 0xc4, 0xdf, 0x57, 0x0e, 0xab, 0x16, 0x33, 0x43, 0x50, 0x84, 0x18, 0xee, 0xe4, 0x28}"}),
    ("AesBinOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Aes", ["LoadIsa"] = "Aes", ["Method"] = "EncryptLast",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte", ["LargestVectorSize"] = "16", ["InputSize"] = "16", ["Input"] = "{0xef, 0xcd, 0xab, 0x89, 0x67, 0x45, 0x23, 0x01, 0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88}", ["KeySize"] = "16", ["Key"] = "{0xff, 0xdd, 0xbb, 0x99, 0x77, 0x55, 0x33, 0x11, 0xee, 0xcc, 0xaa, 0x88, 0x66, 0x44, 0x22, 0x00}", ["ExpectedRetSize"] = "16", ["ExpectedRet"] = "{0x20, 0xb3, 0x7a, 0x5d, 0xf2, 0x7d, 0xdd, 0xb6, 0xf8, 0x60, 0xc8, 0xf4, 0x8c, 0xf9, 0x04, 0x4b}"}),
    ("AesUnOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Aes", ["LoadIsa"] = "Aes", ["Method"] = "InverseMixColumns",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                            ["LargestVectorSize"] = "16", ["InputSize"] = "16", ["Input"] = "{0xef, 0xcd, 0xab, 0x89, 0x67, 0x45, 0x23, 0x01, 0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88}",                                                                                                                                         ["ExpectedRetSize"] = "16", ["ExpectedRet"] = "{0xa0, 0x0a, 0xe4, 0x4e, 0x28, 0x82, 0x6c, 0xc6, 0x55, 0x00, 0x77, 0x22, 0x11, 0x44, 0x33, 0x66}"}),
    ("AesImmOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Aes", ["LoadIsa"] = "Aes", ["Method"] = "KeygenAssist",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                             ["Imm"] = "5", ["LargestVectorSize"] = "16", ["InputSize"] = "16", ["Input"] = "{0xef, 0xcd, 0xab, 0x89, 0x67, 0x45, 0x23, 0x01, 0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88}",                                                                                                                                         ["ExpectedRetSize"] = "16", ["ExpectedRet"] = "{0x85, 0x6e, 0x26, 0x7c, 0x6b, 0x26, 0x7c, 0x85, 0xea, 0xac, 0xee, 0xc4, 0xa9, 0xee, 0xc4, 0xea}"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] PclmulqdqInputs = new []
{
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",  ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["Input1"] = "{2, 20}",   ["Input1Size"] = "2" ,["Input2"] = "{25, 95}",    ["Input2Size"] = "2" ,["ExpectedRet"] = "{50, 0}", ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["Input1"] = "{2, 20}",   ["Input1Size"] = "2" ,["Input2"] = "{25, 95}",    ["Input2Size"] = "2" ,["ExpectedRet"] = "{500, 0}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",  ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["Input1"] = "{2, 20}",   ["Input1Size"] = "2" ,["Input2"] = "{25, 95}",    ["Input2Size"] = "2" ,["ExpectedRet"] = "{190, 0}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",  ["Imm"] = "17",  ["LargestVectorSize"] = "16", ["Input1"] = "{2, 20}",   ["Input1Size"] = "2" ,["Input2"] = "{25, 95}",    ["Input2Size"] = "2" ,["ExpectedRet"] = "{1164, 0}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",  ["Imm"] = "129",  ["LargestVectorSize"] = "16",["Input1"] = "{2, 20}",   ["Input1Size"] = "2" ,["Input2"] = "{25, 95}",    ["Input2Size"] = "2" ,["ExpectedRet"] = "{500, 0}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",   ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["Input1"] = "{-2, -20}", ["Input1Size"] = "2" ,["Input2"] = "{25, 65535}", ["Input2Size"] = "2" ,["ExpectedRet"] = "{-18, 8}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["Input1"] = "{-2, -20}", ["Input1Size"] = "2" ,["Input2"] = "{25, 65535}", ["Input2Size"] = "2" ,["ExpectedRet"] = "{-436, 8}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",   ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["Input1"] = "{-2, -20}", ["Input1Size"] = "2" ,["Input2"] = "{25, 65535}", ["Input2Size"] = "2" ,["ExpectedRet"] = "{43690, 21845}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",   ["Imm"] = "17",  ["LargestVectorSize"] = "16", ["Input1"] = "{-2, -20}", ["Input1Size"] = "2" ,["Input2"] = "{25, 65535}", ["Input2Size"] = "2" ,["ExpectedRet"] = "{961188, 21845}" , ["ExpectedRetSize"] = "2"}),
    ("PclmulqdqOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Pclmulqdq", ["LoadIsa"] = "Pclmulqdq", ["Method"] = "CarrylessMultiply",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",   ["Imm"] = "129",  ["LargestVectorSize"] = "16", ["Input1"] = "{-2, -20}", ["Input1Size"] = "2" ,["Input2"] ="{25, 65535}", ["Input2Size"] = "2" ,["ExpectedRet"] = "{-436, 8}" , ["ExpectedRetSize"] = "2"}),
};

private const string ValidateBmi2ParallelBitComment = @"
// The validation logic defined here for Bmi2.ParallelBitDeposit and Bmi2.ParallelBitExtract is
// based on the 'Operation' pseudo-code defined for the pdep and pext instruction in the 'Intel®
// 64 and IA-32 Architectures Software Developer’s Manual; Volume 2 (2A, 2B, 2C & 2D): Instruction
// Set Reference, A-Z'
";

private const string ValidateBmi2ParallelBitDepositUInt32 = ValidateBmi2ParallelBitComment + @"
uint temp = left;
uint mask = right;
uint dest = 0;
byte m = 0, k = 0;

while (m < 32)
{
    if (((mask >> m) & 1) == 1) // Extract bit at index m of mask
    {
        dest |= (((temp >> k) & 1) << m); // Extract bit at index k of temp and insert to index m of dest
        k++;
    }
    m++;
}

isUnexpectedResult = (dest != result);
";

private const string ValidateBmi2ParallelBitDepositUInt64 = ValidateBmi2ParallelBitComment + @"
ulong temp = left;
ulong mask = right;
ulong dest = 0;
byte m = 0, k = 0;

while (m < 64)
{
    if (((mask >> m) & 1) == 1) // Extract bit at index m of mask
    {
        dest |= (((temp >> k) & 1) << m); // Extract bit at index k of temp and insert to index m of dest
        k++;
    }
    m++;
}

isUnexpectedResult = (dest != result);
";

private const string ValidateBmi2ParallelBitExtractUInt32 = ValidateBmi2ParallelBitComment + @"
uint temp = left;
uint mask = right;
uint dest = 0;
byte m = 0, k = 0;

while (m < 32)
{
    if (((mask >> m) & 1) == 1) // Extract bit at index m of mask
    {
        dest |= (((temp >> m) & 1) << k); // Extract bit at index m of temp and insert to index k of dest
        k++;
    }
    m++;
}

isUnexpectedResult = (dest != result);
";

private const string ValidateBmi2ParallelBitExtractUInt64 = ValidateBmi2ParallelBitComment + @"
ulong temp = left;
ulong mask = right;
ulong dest = 0;
byte m = 0, k = 0;

while (m < 64)
{
    if (((mask >> m) & 1) == 1) // Extract bit at index m of mask
    {
        dest |= (((temp >> m) & 1) << k); // Extract bit at index m of temp and insert to index k of dest
        k++;
    }
    m++;
}

isUnexpectedResult = (dest != result);
";

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Bmi2Inputs = new []
{
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2", ["Method"] = "ParallelBitDeposit",      ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt32",                                    ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                           ["ValidateResult"] = ValidateBmi2ParallelBitDepositUInt32 }),
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2", ["Method"] = "ParallelBitExtract",      ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt32",                                    ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                           ["ValidateResult"] = ValidateBmi2ParallelBitExtractUInt32 }),
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2", ["Method"] = "ZeroHighBits",            ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt32",                                    ["NextValueOp1"] = "0xFFFFFFFF",                        ["NextValueOp2"] = "16",                                                          ["ValidateResult"] = "uint expectedResult = 0xFFFF; isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2", ["Method"] = "MultiplyNoFlags",         ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt32",                                    ["NextValueOp1"] = "UInt32.MaxValue",                   ["NextValueOp2"] = "UInt32.MaxValue",                                             ["ValidateResult"] = "uint expectedResult = 4294967294; isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarTernOpBinResTest.template", new Dictionary<string, string> { ["Isa"] = "Bmi2", ["Method"] = "MultiplyNoFlags",         ["RetBaseType"] = "UInt32", ["Op1BaseType"] = "UInt32", ["Op2BaseType"] = "UInt32",  ["Op3BaseType"] = "UInt32",       ["NextValueOp1"] = "UInt32.MaxValue",                   ["NextValueOp2"] = "UInt32.MaxValue",                   ["NextValueOp3"] = "0",   ["ValidateResult"] = "uint expectedHigher = 4294967294, expectedLower = 1; isUnexpectedResult = (expectedHigher != higher) || (expectedLower != lower);" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Bmi2X64Inputs = new []
{
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2.X64", ["Method"] = "ParallelBitDeposit",  ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt64",                                    ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                            ["ValidateResult"] = ValidateBmi2ParallelBitDepositUInt64 }),
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2.X64", ["Method"] = "ParallelBitExtract",  ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt64",                                    ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                            ["ValidateResult"] = ValidateBmi2ParallelBitExtractUInt64 }),
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2.X64", ["Method"] = "ZeroHighBits",        ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt64",                                    ["NextValueOp1"] = "0xFFFFFFFFFFFFFFFF",                ["NextValueOp2"] = "32",                                                           ["ValidateResult"] = "ulong expectedResult = 0xFFFFFFFF; isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Bmi2.X64", ["Method"] = "MultiplyNoFlags",     ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt64",                                    ["NextValueOp1"] = "UInt64.MaxValue",                   ["NextValueOp2"] = "UInt64.MaxValue",                                              ["ValidateResult"] = "ulong expectedResult = 18446744073709551614; isUnexpectedResult = (expectedResult != result);" }),
    ("ScalarTernOpBinResTest.template", new Dictionary<string, string> { ["Isa"] = "Bmi2.X64", ["Method"] = "MultiplyNoFlags",     ["RetBaseType"] = "UInt64", ["Op1BaseType"] = "UInt64", ["Op2BaseType"] = "UInt64", ["Op3BaseType"] = "UInt64",        ["NextValueOp1"] = "UInt64.MaxValue",                   ["NextValueOp2"] = "UInt64.MaxValue",                     ["NextValueOp3"] = "0",  ["ValidateResult"] = "ulong expectedHigher = 18446744073709551614, expectedLower = 1; isUnexpectedResult = (expectedHigher != higher) || (expectedLower != lower);" }),
};

private static void ProcessInputs(string groupName, (string templateFileName, Dictionary<string, string> templateData)[] inputs)
{
    var testListFileName = Path.Combine("..", groupName, $"Program.{groupName}.cs");

    using (var testListFile = new StreamWriter(testListFileName, append: false))
    {
        testListFile.WriteLine(@"// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.X86
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {");

        foreach (var input in inputs)
        {
            ProcessInput(testListFile, groupName, input);
        }

        testListFile.WriteLine(@"            };
        }
    }
}");
    }
}

private static bool isImmTemplate(string name)
{
    return name == "ImmUnOpTest.template" || name == "InsertScalarTest.template" ||
           name == "ExtractScalarTest.template" || name == "InsertVector128Test.template" ||
           name == "ExtractVector128Test.template" || name == "InsertLoadTest.template" ||
           name == "ExtractStoreTest.template" || name == "ImmBinOpTest.template" ||
           name == "AesImmOpTest.template" || name == "PclmulqdqOpTest.template";
}

private static void ProcessInput(StreamWriter testListFile, string groupName, (string templateFileName, Dictionary<string, string> templateData) input)

{
    var testName = $"{input.templateData["Method"]}.{input.templateData["RetBaseType"]}";

    var suffix = "";

    if (input.templateFileName == "SimpleUnOpConvTest.template" || input.templateFileName == "SimdScalarUnOpConvTest.template" )
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["Op1VectorType"]}{input.templateData["Op1BaseType"]}";
        suffix = $"{input.templateData["Op1VectorType"]}{input.templateData["Op1BaseType"]}";
    }

    if (isImmTemplate(input.templateFileName))
    {
        testName += $".{input.templateData["Imm"]}";
        suffix += $"{input.templateData["Imm"]}";
    }

    if (input.templateFileName == "InsertLoadTest.template")
    {
        testName += ".Load";
        suffix += "Load";
    }
    else if (input.templateFileName == "ExtractStoreTest.template")
    {
        testName += ".Store";
        suffix += "Store";
    }
    else if (input.templateFileName == "ScalarTernOpTest.template")
    {
        testName += ".3Op";
        suffix += "3Op";
    }
    else if (input.templateFileName == "ScalarTernOpBinResTest.template")
    {
        testName += ".BinRes";
        suffix += "BinRes";
    }

    if (input.templateFileName == "SimpleUnOpConvTest.template" || input.templateFileName == "SimdScalarUnOpConvTest.template" )
    {
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{suffix},");
    }
    else
    {
        // Ex: ["Add.Single"] = AddSingle
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["RetBaseType"]}{suffix},");
    }

    var testFileName = Path.Combine("..", groupName, $"{testName}.cs");
    var matchingTemplate = Templates.Where((t) => t.outputTemplateName.Equals(input.templateFileName)).SingleOrDefault();
    var template = string.Empty;

    if (matchingTemplate.templateFileName is null)
    {
        template = File.ReadAllText(input.templateFileName);
    }
    else
    {
        template = File.ReadAllText(matchingTemplate.templateFileName);

        foreach (var kvp in matchingTemplate.templateData)
        {
            template = template.Replace($"{{{kvp.Key}}}", kvp.Value);
        }
    }

    foreach (var kvp in input.templateData)
    {
        template = template.Replace($"{{{kvp.Key}}}", kvp.Value);
    }

    File.WriteAllText(testFileName, template);
}

ProcessInputs("Sse1", Sse1Inputs);
ProcessInputs("Sse1.X64", Sse1X64Inputs);
ProcessInputs("Sse2", Sse2Inputs);
ProcessInputs("Sse2.X64", Sse2X64Inputs);
ProcessInputs("Sse3", Sse3Inputs);
ProcessInputs("Ssse3", Ssse3Inputs);
ProcessInputs("Sse41", Sse41Inputs);
ProcessInputs("Sse41_Overloaded", Sse41_OverloadedInputs);
ProcessInputs("Sse41.X64", Sse41X64Inputs);
ProcessInputs("Sse42", Sse42Inputs);
ProcessInputs("Avx1", Avx1Inputs);
ProcessInputs("Avx1_Vector128", Avx1_Vector128Inputs);
ProcessInputs("Avx2", Avx2Inputs);
ProcessInputs("Avx2_Vector128", Avx2_Vector128Inputs);
ProcessInputs("Fma_Vector128", Fma_Vector128Inputs);
ProcessInputs("Fma_Vector256", Fma_Vector256Inputs);
ProcessInputs("Bmi1", Bmi1Inputs);
ProcessInputs("Bmi1.X64", Bmi1X64Inputs);
ProcessInputs("Bmi2", Bmi2Inputs);
ProcessInputs("Bmi2.X64", Bmi2X64Inputs);
ProcessInputs("Aes", AesInputs);
ProcessInputs("Pclmulqdq", PclmulqdqInputs);
