/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

async function testSteps() {
  const name = "test_orphaned_files.js";

  const objectStoreName = "Blobs";

  const blobData = { key: 1, blob: getBlob("foo") };

  info("Opening database");

  let request = indexedDB.open(name);
  await expectingUpgrade(request);

  let db = request.result;

  info("Creating objectStore");

  let objectStore = db.createObjectStore(objectStoreName);

  info("Adding data");

  objectStore.add(blobData.blob, blobData.key);

  await expectingSuccess(request);

  info("Getting objectStore");

  objectStore = db
    .transaction([objectStoreName], "readwrite")
    .objectStore(objectStoreName);

  info("Getting data");

  request = objectStore.get(blobData.key);
  await requestSucceeded(request);

  let blob = request.result;

  info("Removing data");

  request = objectStore.delete(blobData.key);
  await requestSucceeded(request);
}
