var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { BaseTransport, getTransportBody, LogLevel, prefixAgentMessage } from '@grafana/agent-core';
const debugMessage = prefixAgentMessage('Failed sending payload to the receiver');
export class FetchTransport extends BaseTransport {
    constructor(options) {
        super();
        this.options = options;
    }
    send(item) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const body = JSON.stringify(getTransportBody(item));
                const { url, debug, requestOptions, apiKey } = this.options;
                const _a = requestOptions !== null && requestOptions !== void 0 ? requestOptions : {}, { headers } = _a, restOfRequestOptions = __rest(_a, ["headers"]);
                yield fetch(url, Object.assign({ method: 'POST', headers: Object.assign(Object.assign({ 'Content-Type': 'application/json' }, (headers !== null && headers !== void 0 ? headers : {})), (apiKey ? { 'x-api-key': apiKey } : {})), body, keepalive: true }, (restOfRequestOptions !== null && restOfRequestOptions !== void 0 ? restOfRequestOptions : {}))).catch(() => {
                    if (debug) {
                        this.agent.api.callOriginalConsoleMethod(LogLevel.DEBUG, debugMessage, JSON.parse(body));
                    }
                });
            }
            catch (err) { }
        });
    }
    getIgnoreUrls() {
        return [this.options.url];
    }
}
//# sourceMappingURL=index.js.map