/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.CharConversionException;
import java.io.Console;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;
import org.mozilla.jss.util.UTF8Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Password
implements PasswordCallback,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = LoggerFactory.getLogger(Password.class);
    private StackTraceElement[] stackTrace = new Throwable().getStackTrace();
    private char[] password;
    private boolean cleared;

    private Password() {
        this.cleared = true;
    }

    public Password(char[] pw) {
        int length = pw.length;
        this.cleared = false;
        this.password = new char[length];
        for (int i = 0; i < length; ++i) {
            this.password[i] = pw[i];
            pw[i] = '\u0000';
        }
    }

    @Override
    public synchronized Password getPasswordFirstAttempt(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        if (this.cleared) {
            throw new PasswordCallback.GiveUpException();
        }
        return (Password)this.clone();
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof Password)) {
            return false;
        }
        Password pw = (Password)obj;
        if (pw.password == null || this.password == null) {
            return false;
        }
        if (pw.password.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < this.password.length; ++i) {
            if (pw.password[i] == this.password[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }

    @Override
    public synchronized Password getPasswordAgain(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        throw new PasswordCallback.GiveUpException();
    }

    public synchronized char[] getChars() {
        return this.password;
    }

    public synchronized char[] getCharCopy() {
        return (char[])this.password.clone();
    }

    synchronized byte[] getByteCopy() {
        return Password.charToByte((char[])this.password.clone());
    }

    public synchronized void clear() {
        int len = this.password.length;
        for (int i = 0; i < len; ++i) {
            this.password[i] = '\u0000';
        }
        this.cleared = true;
    }

    public synchronized Object clone() {
        Password dolly = new Password();
        dolly.password = (char[])this.password.clone();
        dolly.cleared = this.cleared;
        return dolly;
    }

    @Deprecated
    protected void finalize() throws Throwable {
        StackTraceElement ste;
        int i;
        if (this.cleared) {
            return;
        }
        this.clear();
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sw, true);
        for (i = 0; i < this.stackTrace.length; ++i) {
            ste = this.stackTrace[i];
            String className = ste.getClassName();
            if (Password.class.getName().equals(className)) continue;
            out.println("Uncleared Password object created at " + ste);
            ++i;
            break;
        }
        while (i < this.stackTrace.length) {
            ste = this.stackTrace[i];
            out.println("        called by " + ste);
            ++i;
        }
        out.println("Please report the above trace to your software vendors.");
        logger.warn(sw.toString());
    }

    public static byte[] charToByte(char[] charArray) {
        byte[] byteArray;
        assert (charArray != null);
        try {
            byteArray = UTF8Converter.UnicodeToUTF8NullTerm(charArray);
        }
        catch (CharConversionException e) {
            throw new RuntimeException("Password could not be converted from Unicode: " + e.getMessage(), e);
        }
        finally {
            Password.wipeChars(charArray);
        }
        return byteArray;
    }

    public static void wipeBytes(byte[] byteArray) {
        assert (byteArray != null);
        UTF8Converter.wipeBytes(byteArray);
    }

    public static void wipeChars(char[] charArray) {
        assert (charArray != null);
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = '\u0000';
        }
    }

    public static Password readPasswordFromConsole() throws PasswordCallback.GiveUpException {
        Console console = System.console();
        char[] password = console.readPassword();
        if (password == null || password.length == 0) {
            throw new PasswordCallback.GiveUpException();
        }
        return new Password(password);
    }
}

