/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static boolean isNT() {
        return File.separator.equals("\\");
    }

    public static boolean isUnix() {
        return File.separator.equals("/");
    }

    public static boolean exec(String cmd) {
        try {
            String[] cmds = null;
            cmds = Utils.isNT() ? new String[]{"cmd", "/c", cmd} : new String[]{"/bin/sh", "-c", cmd};
            Process process = Runtime.getRuntime().exec(cmds);
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (IOException e) {
            logger.error("The command canot be executed: " + cmd, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromStream(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + System.getProperty("line.separator"));
            }
        }
        return sb.toString().trim();
    }

    public static void writeToStream(OutputStream outputStream, String input) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        writer.write(input);
        writer.flush();
        writer.close();
    }

    public static String exec(String[] cmd, String input) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Process p = pb.start();
        if (input != null) {
            Utils.writeToStream(p.getOutputStream(), input);
        }
        p.waitFor();
        String output = p.exitValue() == 0 ? Utils.readFromStream(p.getInputStream()) : Utils.readFromStream(p.getErrorStream());
        p.destroy();
        return output;
    }

    public static String SpecialURLDecode(String s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '#') {
                int c1 = Character.digit(s.charAt(++i), 16);
                int c2 = Character.digit(s.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
                continue;
            }
            out.write(c);
        }
        return out.toString();
    }

    public static byte[] SpecialDecode(String s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '#') {
                int c1 = Character.digit(s.charAt(++i), 16);
                int c2 = Character.digit(s.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
                continue;
            }
            out.write(c);
        }
        return out.toByteArray();
    }

    public static String SpecialEncode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append("%");
            if ((data[i] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(data[i] & 0xFF));
        }
        return sb.toString().toUpperCase();
    }

    public static String HexEncode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                if ((data[i] & 0xFF) < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(data[i] & 0xFF));
            }
        }
        return sb.toString();
    }

    public static void checkHost(String hostname) throws UnknownHostException {
        InetAddress.getByName(hostname);
    }

    public static void copy(String orig, String dest) throws Exception {
        try (BufferedReader in = new BufferedReader(new FileReader(orig));
             PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(dest)));){
            String line = "";
            while (in.ready()) {
                line = in.readLine();
                if (line == null) continue;
                out.println(line);
            }
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static void copyStream(BufferedReader in, OutputStreamWriter out) throws IOException {
        int len;
        char[] buf = new char[4096];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static void sortStrings(String[] strings) {
        for (int i = 0; i < strings.length - 1; ++i) {
            for (int j = i + 1; j < strings.length; ++j) {
                if (strings[i].compareTo(strings[j]) <= 0) continue;
                String t = strings[i];
                strings[i] = strings[j];
                strings[j] = t;
            }
        }
    }

    public static String lsDateStr(Date date) {
        long dateTime = date.getTime();
        if (dateTime == -1L) {
            return "------------";
        }
        long nowTime = System.currentTimeMillis();
        SimpleDateFormat formatter = new SimpleDateFormat();
        if (Math.abs(nowTime - dateTime) < 15811200000L) {
            formatter.applyPattern("MMM dd hh:ss");
        } else {
            formatter.applyPattern("MMM dd yyyy");
        }
        return formatter.format(date);
    }

    public static boolean byteArraysAreEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static String stripQuotes(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String[] getStringArrayFromVector(Vector<String> v) {
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public static String base64encode(byte[] bytes, boolean chunked) {
        if (chunked) {
            return Utils.base64encodeMultiLine(bytes);
        }
        return Utils.base64encodeSingleLine(bytes);
    }

    public static String base64encodeMultiLine(byte[] bytes) {
        return Base64.getMimeEncoder().encodeToString(bytes) + "\r\n";
    }

    public static String base64encodeSingleLine(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] base64decode(String string) {
        try {
            if (string.contains("_") || string.contains("-")) {
                return Base64.getUrlDecoder().decode(string);
            }
            return Base64.getMimeDecoder().decode(string);
        }
        catch (IllegalArgumentException iae) {
            return new byte[0];
        }
    }

    public static String normalizeString(String string) {
        return Utils.normalizeString(string, false);
    }

    public static String normalizeString(String string, Boolean keepSpace) {
        if (string == null) {
            return string;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = null;
        st = keepSpace != false ? new StringTokenizer(string, "\r\n") : new StringTokenizer(string, "\r\n ");
        while (st.hasMoreTokens()) {
            String nextLine = st.nextToken();
            nextLine = nextLine.trim();
            sb.append(nextLine);
        }
        return sb.toString();
    }
}

