/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RevocationReason;

public final class CRLReasonExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 4544973296866779535L;
    public static final CRLReasonExtension UNSPECIFIED = new CRLReasonExtension(RevocationReason.UNSPECIFIED);
    public static final CRLReasonExtension KEY_COMPROMISE = new CRLReasonExtension(RevocationReason.KEY_COMPROMISE);
    public static final CRLReasonExtension CA_COMPROMISE = new CRLReasonExtension(RevocationReason.CA_COMPROMISE);
    public static final CRLReasonExtension AFFILIATION_CHANGED = new CRLReasonExtension(RevocationReason.AFFILIATION_CHANGED);
    public static final CRLReasonExtension SUPERSEDED = new CRLReasonExtension(RevocationReason.SUPERSEDED);
    public static final CRLReasonExtension CESSATION_OF_OPERATION = new CRLReasonExtension(RevocationReason.CESSATION_OF_OPERATION);
    public static final CRLReasonExtension CERTIFICATE_HOLD = new CRLReasonExtension(RevocationReason.CERTIFICATE_HOLD);
    public static final CRLReasonExtension REMOVE_FROM_CRL = new CRLReasonExtension(RevocationReason.REMOVE_FROM_CRL);
    public static final CRLReasonExtension PRIVILEGE_WITHDRAWN = new CRLReasonExtension(RevocationReason.PRIVILEGE_WITHDRAWN);
    public static final CRLReasonExtension AA_COMPROMISE = new CRLReasonExtension(RevocationReason.AA_COMPROMISE);
    public static final String NAME = "CRLReason";
    public static final String REASON = "value";
    private RevocationReason mReason = null;

    public RevocationReason getReason() {
        return this.mReason;
    }

    public CRLReasonExtension() {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = false;
        this.mReason = null;
    }

    public CRLReasonExtension(RevocationReason reason) {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = false;
        this.mReason = reason;
    }

    public CRLReasonExtension(Boolean critical, RevocationReason reason) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = critical;
        this.mReason = reason;
    }

    public CRLReasonExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = critical;
        byte[] extValue = (byte[])((byte[])value).clone();
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        int reasonCode = val.getEnumerated();
        this.mReason = RevocationReason.fromInt(reasonCode);
        if (this.mReason == null) {
            throw new IOException("Unknown revocation reason value " + reasonCode);
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof RevocationReason)) {
            throw new IOException("Attribute must be of type RevocationReason.");
        }
        if (!name.equalsIgnoreCase(REASON)) {
            throw new IOException("Name not recognized by CRLReason");
        }
        this.mReason = (RevocationReason)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(REASON)) {
            return this.mReason;
        }
        throw new IOException("Name not recognized by CRLReason");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(REASON)) {
            throw new IOException("Name not recognized by CRLReason");
        }
        this.mReason = null;
    }

    @Override
    public String toString() {
        String s = super.toString() + "CRL Reason [" + this.mReason + "]\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    private void encodeThis() throws IOException {
        if (this.mReason == null) {
            throw new IOException("Unintialized CRLReason extension");
        }
        try (DerOutputStream os = new DerOutputStream();){
            os.putEnumerated(this.mReason.toInt());
            this.extensionValue = os.toByteArray();
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(REASON);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CRLReasonExtension) {
            return ((CRLReasonExtension)other).mReason == this.mReason && ((CRLReasonExtension)other).critical == this.critical;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mReason == null ? 0 : this.mReason.hashCode());
        return result;
    }
}

