/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class UniversalCharsetEncoder
extends CharsetEncoder {
    public UniversalCharsetEncoder(Charset cs) {
        super(cs, 4.0f, 4.0f, new byte[]{0, 0, 0, 0});
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        while (in.remaining() >= 1) {
            in.mark();
            char c = in.get();
            if (out.remaining() < 4) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
            out.put((byte)0);
            out.put((byte)0);
            out.put((byte)(c >> 8 & 0xFF));
            out.put((byte)(c & 0xFF));
        }
        return CoderResult.UNDERFLOW;
    }
}

