/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11Cipher;
import org.mozilla.jss.pkcs11.PK11KeyGenerator;
import org.mozilla.jss.pkcs11.PK11KeyPairGenerator;
import org.mozilla.jss.pkcs11.PK11KeyWrapper;
import org.mozilla.jss.pkcs11.PK11MessageDigest;
import org.mozilla.jss.pkcs11.PK11Signature;
import org.mozilla.jss.pkcs11.PK11Store;
import org.mozilla.jss.pkcs11.PK11SymmetricKeyDeriver;
import org.mozilla.jss.pkcs11.TokenCallbackInfo;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.pkcs11.Tunnel;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.NotImplementedException;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public final class PK11Token
implements CryptoToken {
    protected TokenProxy tokenProxy;
    protected PK11Store cryptoStore;
    protected boolean mIsInternalCryptoToken;
    protected boolean mIsInternalKeyStorageToken;

    @Override
    public Signature getSignatureContext(SignatureAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        assert (algorithm != null);
        return Tunnel.constructSignature(algorithm, new PK11Signature(this, algorithm));
    }

    @Override
    public JSSMessageDigest getDigestContext(DigestAlgorithm algorithm) throws NoSuchAlgorithmException, DigestException {
        if (!this.doesAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException();
        }
        return new PK11MessageDigest(this, algorithm);
    }

    @Override
    public Cipher getCipherContext(EncryptionAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm + " is not supported by this token");
        }
        return new PK11Cipher(this, algorithm);
    }

    @Override
    public KeyGenerator getKeyGenerator(KeyGenAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        return new PK11KeyGenerator(this, algorithm);
    }

    @Override
    public SymmetricKey cloneKey(SymmetricKey key) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        return PK11KeyGenerator.clone(key, this);
    }

    @Override
    public PK11SymmetricKeyDeriver getSymmetricKeyDeriver() {
        return new PK11SymmetricKeyDeriver(this);
    }

    @Override
    public KeyWrapper getKeyWrapper(KeyWrapAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        return new PK11KeyWrapper(this, algorithm);
    }

    public SecureRandom getRandomGenerator() throws NotImplementedException, TokenException {
        throw new NotImplementedException();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator(KeyPairAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        assert (algorithm != null);
        return new KeyPairGenerator(algorithm, new PK11KeyPairGenerator(this, algorithm));
    }

    @Override
    public native boolean isLoggedIn() throws TokenException;

    @Override
    public native boolean needsLogin() throws TokenException;

    @Override
    public void login(PasswordCallback callback) throws IncorrectPasswordException, TokenException {
        if (callback == null) {
            callback = new NullPasswordCallback();
        }
        this.nativeLogin(callback);
    }

    protected native void nativeLogin(PasswordCallback var1) throws IncorrectPasswordException, TokenException;

    public native boolean isWritable();

    @Override
    public native boolean isPresent();

    @Override
    public native void logout() throws TokenException;

    @Override
    public native int getLoginMode() throws TokenException;

    @Override
    public native void setLoginMode(int var1) throws TokenException;

    @Override
    public native int getLoginTimeoutMinutes() throws TokenException;

    @Override
    public native void setLoginTimeoutMinutes(int var1) throws TokenException;

    @Override
    public void initPassword(PasswordCallback ssopwcb, PasswordCallback userpwcb) throws IncorrectPasswordException, AlreadyInitializedException, TokenException {
        Password userpw;
        Password ssopw;
        byte[] userpwArray;
        block17: {
            byte[] ssopwArray = null;
            userpwArray = null;
            ssopw = null;
            userpw = null;
            PasswordCallbackInfo pwcb = this.makePWCBInfo();
            if (ssopwcb == null) {
                ssopwcb = new NullPasswordCallback();
            }
            if (userpwcb == null) {
                userpwcb = new NullPasswordCallback();
            }
            try {
                if (!this.PWInitable()) {
                    throw new AlreadyInitializedException();
                }
                if (this.isInternalKeyStorageToken()) {
                    ssopwArray = new byte[]{0};
                } else {
                    ssopw = ssopwcb.getPasswordFirstAttempt(pwcb);
                    ssopwArray = Tunnel.getPasswordByteCopy(ssopw);
                    while (!this.SSOPasswordIsCorrect(ssopwArray)) {
                        Password.wipeBytes(ssopwArray);
                        ssopw.clear();
                        ssopw = ssopwcb.getPasswordAgain(pwcb);
                        ssopwArray = Tunnel.getPasswordByteCopy(ssopw);
                    }
                }
                userpw = userpwcb.getPasswordFirstAttempt(pwcb);
                userpwArray = Tunnel.getPasswordByteCopy(userpw);
                this.initPassword(ssopwArray, userpwArray);
                if (ssopwArray == null) break block17;
            }
            catch (PasswordCallback.GiveUpException e) {
                try {
                    throw new IncorrectPasswordException(e.toString());
                }
                catch (Throwable throwable) {
                    if (ssopwArray != null) {
                        Password.wipeBytes(ssopwArray);
                    }
                    if (ssopw != null) {
                        ssopw.clear();
                    }
                    if (userpwArray != null) {
                        Password.wipeBytes(userpwArray);
                    }
                    if (userpw != null) {
                        userpw.clear();
                    }
                    throw throwable;
                }
            }
            Password.wipeBytes(ssopwArray);
        }
        if (ssopw != null) {
            ssopw.clear();
        }
        if (userpwArray != null) {
            Password.wipeBytes(userpwArray);
        }
        if (userpw != null) {
            userpw.clear();
        }
    }

    protected native boolean PWInitable() throws TokenException;

    protected native boolean SSOPasswordIsCorrect(byte[] var1) throws TokenException, AlreadyInitializedException;

    protected native void initPassword(byte[] var1, byte[] var2) throws IncorrectPasswordException, AlreadyInitializedException, TokenException;

    @Override
    public native boolean passwordIsInitialized() throws TokenException;

    @Override
    public void changePassword(PasswordCallback oldPINcb, PasswordCallback newPINcb) throws IncorrectPasswordException, TokenException {
        Password newPIN;
        Password oldPIN;
        byte[] newPW;
        block15: {
            byte[] oldPW = null;
            newPW = null;
            oldPIN = null;
            newPIN = null;
            PasswordCallbackInfo pwcb = this.makePWCBInfo();
            if (oldPINcb == null) {
                oldPINcb = new NullPasswordCallback();
            }
            if (newPINcb == null) {
                newPINcb = new NullPasswordCallback();
            }
            try {
                oldPIN = oldPINcb.getPasswordFirstAttempt(pwcb);
                oldPW = Tunnel.getPasswordByteCopy(oldPIN);
                if (!this.userPasswordIsCorrect(oldPW)) {
                    do {
                        Password.wipeBytes(oldPW);
                        oldPIN.clear();
                    } while (!this.userPasswordIsCorrect(oldPW = Tunnel.getPasswordByteCopy(oldPIN = oldPINcb.getPasswordAgain(pwcb))));
                }
                newPIN = newPINcb.getPasswordFirstAttempt(pwcb);
                newPW = Tunnel.getPasswordByteCopy(newPIN);
                this.changePassword(oldPW, newPW);
                if (oldPW == null) break block15;
            }
            catch (PasswordCallback.GiveUpException e) {
                try {
                    throw new IncorrectPasswordException(e.toString());
                }
                catch (Throwable throwable) {
                    if (oldPW != null) {
                        Password.wipeBytes(oldPW);
                    }
                    if (oldPIN != null) {
                        oldPIN.clear();
                    }
                    if (newPW != null) {
                        Password.wipeBytes(newPW);
                    }
                    if (newPIN != null) {
                        newPIN.clear();
                    }
                    throw throwable;
                }
            }
            Password.wipeBytes(oldPW);
        }
        if (oldPIN != null) {
            oldPIN.clear();
        }
        if (newPW != null) {
            Password.wipeBytes(newPW);
        }
        if (newPIN != null) {
            newPIN.clear();
        }
    }

    protected PasswordCallbackInfo makePWCBInfo() {
        return new TokenCallbackInfo(this.getName());
    }

    protected native boolean userPasswordIsCorrect(byte[] var1) throws TokenException;

    protected native void changePassword(byte[] var1, byte[] var2) throws IncorrectPasswordException, TokenException;

    @Override
    public native String getName();

    public Provider getProvider() {
        throw new RuntimeException("PK11Token.getProvider() is not yet implemented");
    }

    @Override
    public CryptoStore getCryptoStore() {
        return this.cryptoStore;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PK11Token)) {
            return false;
        }
        return this.tokenProxy.equals(((PK11Token)obj).tokenProxy);
    }

    public int hashCode() {
        return this.tokenProxy.hashCode();
    }

    @Override
    public native boolean doesAlgorithm(Algorithm var1);

    @Override
    public String generateCertRequest(String subject, int keysize, String keyType, byte[] prime, byte[] subPrime, byte[] base) throws TokenException, InvalidParameterException, PQGParamGenException {
        byte[] p = prime;
        byte[] q = subPrime;
        byte[] g = base;
        if (keyType.equalsIgnoreCase("dsa")) {
            if (p == null && q == null && g == null) {
                PQGParams pqg = PQGParams.generate(keysize);
                p = PQGParams.BigIntegerToUnsignedByteArray(pqg.getP());
                q = PQGParams.BigIntegerToUnsignedByteArray(pqg.getQ());
                g = PQGParams.BigIntegerToUnsignedByteArray(pqg.getG());
            } else if (p == null || q == null || g == null) {
                throw new InvalidParameterException("need all P, Q, and G");
            }
        }
        String pk10String = this.generatePK10(subject, keysize, keyType, p, q, g);
        return "-----BEGIN CERTIFICATE REQUEST-----\n" + pk10String + "\n-----END CERTIFICATE REQUEST-----";
    }

    protected native String generatePK10(String var1, int var2, String var3, byte[] var4, byte[] var5, byte[] var6) throws TokenException, InvalidParameterException;

    protected PK11Token() {
        assert (false);
    }

    protected PK11Token(byte[] pointer, boolean internal, boolean keyStorage) {
        assert (pointer != null);
        this.tokenProxy = new TokenProxy(pointer);
        this.mIsInternalCryptoToken = internal;
        this.mIsInternalKeyStorageToken = keyStorage;
        this.cryptoStore = new PK11Store(this.tokenProxy);
    }

    public TokenProxy getProxy() {
        return this.tokenProxy;
    }

    public boolean isInternalCryptoToken() {
        return this.mIsInternalCryptoToken;
    }

    public boolean isInternalKeyStorageToken() {
        return this.mIsInternalKeyStorageToken;
    }

    @Override
    public native void importPublicKey(PublicKey var1, boolean var2) throws TokenException;

    public static class NotInitializedException
    extends IncorrectPasswordException {
        private static final long serialVersionUID = 1L;

        public NotInitializedException() {
        }

        public NotInitializedException(String mesg) {
            super(mesg);
        }
    }
}

