; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX2OR512VL --check-prefix=AVX2 --check-prefix=AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX2OR512VL --check-prefix=AVX2 --check-prefix=AVX2-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX2OR512VL --check-prefix=AVX2 --check-prefix=AVX2-FAST-PERLANE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefix=ALL --check-prefix=AVX2OR512VL --check-prefix=AVX512VL --check-prefix=AVX512VL-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX2OR512VL --check-prefix=AVX512VL --check-prefix=AVX512VL-FAST --check-prefix=AVX512VL-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+avx512dq,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX2OR512VL --check-prefix=AVX512VL --check-prefix=AVX512VL-FAST --check-prefix=AVX512VL-FAST-PERLANE

define <8 x float> @shuffle_v8f32_00000000(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00000000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_00000000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00000010(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00000010:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_00000010:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_00000010:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,0,1,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_00000010:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_00000010:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_00000010:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,0,1,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_00000010:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 1, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00000200(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00000200:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_00000200:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_00000200:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,2,0,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_00000200:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_00000200:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_00000200:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,2,0,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_00000200:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 2, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00003000(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00003000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_00003000:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_00003000:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,3,0,0,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_00003000:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_00003000:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_00003000:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,3,0,0,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_00003000:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 3, i32 0, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00040000(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00040000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[2,0],ymm0[4,4],ymm1[6,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_00040000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [0,0,0,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 4, i32 0, i32 0, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00500000(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00500000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,1,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_00500000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [0,0,5,0]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 5, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_06000000(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_06000000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_06000000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [0,6,0,0]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 6, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_70000000(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_70000000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,0,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_70000000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [7,0,0,0]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 7, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_01014545(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_01014545:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 4, i32 5, i32 4, i32 5>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00112233(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00112233:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_00112233:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,1,1,2,2,3,3]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 1, i32 1, i32 2, i32 2, i32 3, i32 3>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00001111(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_00001111:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_00001111:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_00001111:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,1,1,1,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_00001111:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_00001111:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_00001111:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,1,1,1,1]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_00001111:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 1, i32 1, i32 1, i32 1>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_81a3c5e7(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_81a3c5e7:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 8, i32 1, i32 10, i32 3, i32 12, i32 5, i32 14, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_08080808(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_08080808:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8f32_08080808:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_08080808:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512VL-SLOW-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_08080808:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [34359738368,34359738368,34359738368,34359738368]
; AVX512VL-FAST-ALL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_08080808:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512VL-FAST-PERLANE-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 0, i32 8, i32 0, i32 8, i32 0, i32 8>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_08084c4c(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_08084c4c:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_08084c4c:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8f32_08084c4c:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovaps {{.*#+}} ymm2 = [0,8,0,8,4,12,4,12]
; AVX512VL-FAST-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 0, i32 8, i32 4, i32 12, i32 4, i32 12>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_8823cc67(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_8823cc67:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,0],ymm0[2,3],ymm1[4,4],ymm0[6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 8, i32 8, i32 2, i32 3, i32 12, i32 12, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_9832dc76(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_9832dc76:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,0],ymm0[3,2],ymm1[5,4],ymm0[7,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 9, i32 8, i32 3, i32 2, i32 13, i32 12, i32 7, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_9810dc54(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_9810dc54:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 9, i32 8, i32 1, i32 0, i32 13, i32 12, i32 5, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_08194c5d(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_08194c5d:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 4, i32 12, i32 5, i32 13>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_2a3b6e7f(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_2a3b6e7f:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 2, i32 10, i32 3, i32 11, i32 6, i32 14, i32 7, i32 15>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_08192a3b(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_08192a3b:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1OR2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_08192a3b:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [0,8,1,9,2,10,3,11]
; AVX512VL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_08991abb(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_08991abb:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm1[1,1]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_08991abb:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} ymm2 = <u,0,1,1,u,2,3,3>
; AVX2-SLOW-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_08991abb:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <0,u,u,u,1,u,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <u,0,1,1,u,2,3,3>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_08991abb:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} ymm2 = <u,0,1,1,u,2,3,3>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_08991abb:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [8,0,1,1,9,2,3,3]
; AVX512VL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 9, i32 9, i32 1, i32 10, i32 11, i32 11>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_091b2d3f(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_091b2d3f:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm0[0,1,1,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8f32_091b2d3f:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <0,u,1,u,2,u,3,u>
; AVX2-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_091b2d3f:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [0,9,1,11,2,13,3,15]
; AVX512VL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 9, i32 1, i32 11, i32 2, i32 13, i32 3, i32 15>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_09ab1def(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_09ab1def:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_09ab1def:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_09ab1def:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <0,u,u,u,1,u,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_09ab1def:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_09ab1def:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [8,1,2,3,9,5,6,7]
; AVX512VL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 1, i32 13, i32 14, i32 15>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00014445(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00014445:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,1,4,4,4,5]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 1, i32 4, i32 4, i32 4, i32 5>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00204464(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00204464:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,0,4,4,6,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 0, i32 4, i32 4, i32 6, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_03004744(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_03004744:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,3,0,0,4,7,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 3, i32 0, i32 0, i32 4, i32 7, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_10005444(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_10005444:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,0,0,5,4,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 0, i32 0, i32 5, i32 4, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_22006644(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_22006644:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,2,0,0,6,6,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 2, i32 2, i32 0, i32 0, i32 6, i32 6, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_33307774(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_33307774:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,3,3,0,7,7,7,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 3, i32 3, i32 0, i32 7, i32 7, i32 7, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_32107654(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_32107654:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00234467(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00234467:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,3,4,4,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 3, i32 4, i32 4, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00224466(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00224466:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00224466_v4f32(<4 x float> %a, <4 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00224466_v4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %2 = shufflevector <4 x float> %b, <4 x float> %b, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %3 = shufflevector <4 x float> %1, <4 x float> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %3
}

define <8 x float> @shuffle_v8f32_00004444_v4f32(<4 x float> %a, <4 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00004444_v4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,0,4,4,4,4]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  ret <8 x float> %1
}

define <8 x float> @shuffle_v8f32_10325476(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_10325476:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,3,2,5,4,7,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_11335577(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_11335577:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_11335577_v4f32(<4 x float> %a, <4 x float> %b) {
; ALL-LABEL: shuffle_v8f32_11335577_v4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %2 = shufflevector <4 x float> %b, <4 x float> %b, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %3 = shufflevector <4 x float> %1, <4 x float> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %3
}

define <8 x float> @shuffle_v8f32_10235467(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_10235467:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,2,3,5,4,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 2, i32 3, i32 5, i32 4, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_10225466(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_10225466:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,2,2,5,4,6,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 2, i32 2, i32 5, i32 4, i32 6, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00015444(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00015444:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,1,5,4,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 1, i32 5, i32 4, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00204644(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00204644:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,0,4,6,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 0, i32 4, i32 6, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_03004474(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_03004474:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,3,0,0,4,4,7,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 3, i32 0, i32 0, i32 4, i32 4, i32 7, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_10004444(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_10004444:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,0,0,4,4,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_22006446(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_22006446:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,2,0,0,6,4,4,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 2, i32 2, i32 0, i32 0, i32 6, i32 4, i32 4, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_33307474(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_33307474:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,3,3,0,7,4,7,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 3, i32 3, i32 0, i32 7, i32 4, i32 7, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_32104567(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_32104567:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,4,5,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00236744(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00236744:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,3,6,7,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 3, i32 6, i32 7, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00226644(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00226644:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,2,6,6,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 6, i32 6, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_10324567(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_10324567:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,3,2,4,5,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_11334567(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_11334567:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,3,3,4,5,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_01235467(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_01235467:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,2,3,5,4,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 5, i32 4, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_01235466(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_01235466:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,2,3,5,4,6,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 5, i32 4, i32 6, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_002u6u44(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_002u6u44:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,u,6,u,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 undef, i32 6, i32 undef, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_00uu66uu(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_00uu66uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,u,u,6,6,u,u]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 0, i32 undef, i32 undef, i32 6, i32 6, i32 undef, i32 undef>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_103245uu(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_103245uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,3,2,4,5,u,u]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 4, i32 5, i32 undef, i32 undef>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_1133uu67(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_1133uu67:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,3,3,u,u,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 undef, i32 undef, i32 6, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_0uu354uu(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_0uu354uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,u,u,3,5,4,u,u]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 undef, i32 undef, i32 3, i32 5, i32 4, i32 undef, i32 undef>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_uuu3uu66(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_uuu3uu66:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[u,u,u,3,u,u,6,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 3, i32 undef, i32 undef, i32 6, i32 6>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_c348cda0(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_c348cda0:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,0],ymm2[4,5],ymm1[6,4]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,3],ymm2[0,0],ymm0[4,7],ymm2[4,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4,5,6],ymm0[7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_c348cda0:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vbroadcastf128 {{.*#+}} ymm2 = [4,5,2,0,4,5,2,0]
; AVX2-SLOW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,3,2,0,4,7,6,4]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4,5,6],ymm0[7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_c348cda0:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <u,3,4,u,u,u,u,0>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm2 = [4,5,2,0,4,5,2,0]
; AVX2-FAST-ALL-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4,5,6],ymm0[7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_c348cda0:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vbroadcastf128 {{.*#+}} ymm2 = [4,5,2,0,4,5,2,0]
; AVX2-FAST-PERLANE-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,3,2,0,4,7,6,4]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4,5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_c348cda0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [4,11,12,0,4,5,2,8]
; AVX512VL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 12, i32 3, i32 4, i32 8, i32 12, i32 13, i32 10, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_f511235a(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_f511235a:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,1,1,5,5,5,5]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm2[0],ymm0[1],ymm2[3],ymm0[3]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,0,1]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[3,1,2,2,7,5,6,6]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_f511235a:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[3,2,2,3,7,6,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,0]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,0,1,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_f511235a:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <7,u,u,u,u,u,u,2>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <u,5,1,1,2,3,5,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_f511235a:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[3,2,2,3,7,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,0]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,0,1,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_f511235a:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [15,5,1,1,2,3,5,10]
; AVX512VL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 15, i32 5, i32 1, i32 1, i32 2, i32 3, i32 5, i32 10>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_32103210(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_32103210:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_32103210:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_32103210:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [3,2,1,0,3,2,1,0]
; AVX2-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_32103210:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_32103210:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_32103210:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [3,2,1,0,3,2,1,0]
; AVX512VL-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-FAST-ALL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_32103210:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 3, i32 2, i32 1, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_76547654(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_76547654:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_76547654:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_76547654:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [7,6,5,4,7,6,5,4]
; AVX2-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_76547654:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_76547654:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_76547654:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [7,6,5,4,7,6,5,4]
; AVX512VL-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-FAST-ALL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_76547654:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 7, i32 6, i32 5, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_76543210(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_76543210:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_76543210:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_76543210:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [7,6,5,4,3,2,1,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_76543210:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_76543210:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_76543210:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [7,6,5,4,3,2,1,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_76543210:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_3210ba98(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_3210ba98:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_3210ba98:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_3210ba98:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [3,2,1,0,11,10,9,8]
; AVX512VL-FAST-ALL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_3210ba98:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 11, i32 10, i32 9, i32 8>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_3210fedc(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_3210fedc:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_3210fedc:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8f32_3210fedc:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovaps {{.*#+}} ymm2 = [3,2,1,0,15,14,13,12]
; AVX512VL-FAST-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_7654fedc(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_7654fedc:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_7654fedc:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_7654fedc:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [7,6,5,4,15,14,13,12]
; AVX512VL-FAST-ALL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_7654fedc:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 15, i32 14, i32 13, i32 12>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_fedc7654(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_fedc7654:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_fedc7654:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_fedc7654:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [7,6,5,4,15,14,13,12]
; AVX512VL-FAST-ALL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_fedc7654:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 15, i32 14, i32 13, i32 12, i32 7, i32 6, i32 5, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @PR21138(<8 x float> %truc, <8 x float> %tchose) {
; AVX1-LABEL: PR21138:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm2[1,3],ymm0[5,7],ymm2[5,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR21138:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: PR21138:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: PR21138:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [1,3,5,7,9,11,13,15]
; AVX512VL-FAST-ALL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: PR21138:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %truc, <8 x float> %tchose, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_ba987654(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_ba987654:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_ba987654:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8f32_ba987654:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovaps {{.*#+}} ymm2 = [3,2,1,0,15,14,13,12]
; AVX512VL-FAST-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_ba983210(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_ba983210:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_ba983210:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_ba983210:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [3,2,1,0,11,10,9,8]
; AVX512VL-FAST-ALL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_ba983210:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 11, i32 10, i32 9, i32 8, i32 3, i32 2, i32 1, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_80u1c4u5(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_80u1c4u5:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 8, i32 0, i32 undef, i32 1, i32 12, i32 4, i32 undef, i32 5>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_a2u3e6f7(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_a2u3e6f7:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 10, i32 2, i32 undef, i32 3, i32 14, i32 6, i32 15, i32 7>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_084c195d(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_084c195d:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,2,1,4,4,6,5]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3,4,5],ymm1[6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[1,1,0,3,5,5,4,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,1,3,4,5,5,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3,4,5],ymm0[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8f32_084c195d:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_084c195d:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_084c195d:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [0,8,4,12,1,9,5,13]
; AVX512VL-FAST-ALL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_084c195d:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 4, i32 12, i32 1, i32 9, i32 5, i32 13>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_01452367(<8 x float> %a) {
; AVX1-LABEL: shuffle_v8f32_01452367:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8f32_01452367:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 4, i32 5, i32 2, i32 3, i32 6, i32 7>
  ret <8 x float> %shuffle
}

; PR53124
define <8 x float> @shuffle_v8f32_089abcde(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_089abcde:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,0],ymm1[0,0],ymm2[7,4],ymm1[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,2],ymm1[1,2],ymm2[4,6],ymm1[5,6]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8f32_089abcde:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <u,0,1,2,3,4,5,6>
; AVX2-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_089abcde:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [8,0,1,2,3,4,5,6]
; AVX512VL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_0189abcd(<8 x float> %a, <8 x float> %b) {
; AVX1OR2-LABEL: shuffle_v8f32_0189abcd:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1OR2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_0189abcd:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_0189abcd:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovapd {{.*#+}} ymm2 = [4,0,1,2]
; AVX512VL-FAST-ALL-NEXT:    vpermi2pd %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovapd %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_0189abcd:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_01289abc(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_01289abc:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0],ymm2[3,0],ymm1[4,4],ymm2[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,2],ymm1[2,0],ymm2[5,6],ymm1[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8f32_01289abc:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <u,u,u,0,1,2,3,4>
; AVX2-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_01289abc:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} ymm2 = [8,9,10,0,1,2,3,4]
; AVX512VL-NEXT:    vpermi2ps %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 8, i32 9, i32 10, i32 11, i32 12>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_uuuu1111(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_uuuu1111:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; ALL-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 1, i32 1, i32 1, i32 1>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_44444444(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8f32_44444444:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8f32_44444444:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8f32_44444444:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8f32_44444444:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8f32_44444444:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8f32_44444444:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8f32_44444444:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_1188uuuu(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_1188uuuu:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,0]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 1, i32 8, i32 8, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_uuuu3210(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_uuuu3210:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; ALL-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 3, i32 2, i32 1, i32 0>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_uuuu1188(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_uuuu1188:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,0]
; ALL-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 1, i32 1, i32 8, i32 8>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_1111uuuu(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_1111uuuu:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_5555uuuu(<8 x float> %a, <8 x float> %b) {
; ALL-LABEL: shuffle_v8f32_5555uuuu:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm0, %xmm0
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %shuffle
}

define <8 x float> @shuffle_v8f32_32107654_v4f32(<4 x float> %a, <4 x float> %b) {
; ALL-LABEL: shuffle_v8f32_32107654_v4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %2 = shufflevector <4 x float> %b, <4 x float> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %3 = shufflevector <4 x float> %1, <4 x float> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %3
}

define <8 x float> @shuffle_mem_v8f32_8BA0CFE4(<8 x float> %a0, ptr %a1) {
; AVX1OR2-LABEL: shuffle_mem_v8f32_8BA0CFE4:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vshufps {{.*#+}} ymm1 = ymm0[2,0],mem[0,0],ymm0[6,4],mem[4,4]
; AVX1OR2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,3],ymm1[0,2],ymm0[4,7],ymm1[4,6]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_mem_v8f32_8BA0CFE4:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vshufps {{.*#+}} ymm1 = ymm0[2,0],mem[0,0],ymm0[6,4],mem[4,4]
; AVX512VL-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,3],ymm1[0,2],ymm0[4,7],ymm1[4,6]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_mem_v8f32_8BA0CFE4:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,3,2,8,4,7,6,12]
; AVX512VL-FAST-NEXT:    vpermt2ps (%rdi), %ymm1, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %1 = load <8 x float>, ptr %a1
  %2 = shufflevector <8 x float> %1, <8 x float> %a0, <8 x i32> <i32 8, i32 11, i32 10, i32 0, i32 12, i32 15, i32 14, i32 4>
  ret <8 x float> %2
}

define <8 x i32> @shuffle_v8i32_00000000(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00000000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00000000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00000010(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00000010:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_00000010:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_00000010:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,0,1,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_00000010:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_00000010:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_00000010:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,0,1,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_00000010:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 1, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00000200(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00000200:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_00000200:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_00000200:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,2,0,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_00000200:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_00000200:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_00000200:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,0,2,0,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_00000200:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,2]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 2, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00003000(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00003000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_00003000:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_00003000:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,3,0,0,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_00003000:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_00003000:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_00003000:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,3,0,0,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_00003000:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,3,0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 3, i32 0, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00040000(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00040000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[2,0],ymm0[4,4],ymm1[6,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00040000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [0,0,0,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 4, i32 0, i32 0, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00500000(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00500000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,1,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00500000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [0,0,5,0]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 5, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_06000000(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_06000000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_06000000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [0,6,0,0]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 6, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_70000000(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_70000000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,0,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_70000000:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} xmm1 = [7,0,0,0]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 7, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_01014545(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_01014545:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_01014545:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,0,1,4,5,4,5]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 4, i32 5, i32 4, i32 5>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00112233(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00112233:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_00112233:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,1,1,4,4,5,5]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_00112233:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,1,1,2,2,3,3]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_00112233:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,1,1,4,4,5,5]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_00112233:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,1,1,4,4,5,5]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_00112233:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,1,1,2,2,3,3]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_00112233:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,1,1,4,4,5,5]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 1, i32 1, i32 2, i32 2, i32 3, i32 3>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00001111(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00001111:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_00001111:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_00001111:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,1,1,1,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_00001111:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_00001111:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_00001111:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,0,1,1,1,1]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_00001111:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 1, i32 1, i32 1, i32 1>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_81a3c5e7(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_81a3c5e7:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 8, i32 1, i32 10, i32 3, i32 12, i32 5, i32 14, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_08080808(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_08080808:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_08080808:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_08080808:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512VL-SLOW-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_08080808:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [34359738368,34359738368,34359738368,34359738368]
; AVX512VL-FAST-ALL-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_08080808:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512VL-FAST-PERLANE-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 8, i32 0, i32 8, i32 0, i32 8, i32 0, i32 8>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_08084c4c(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_08084c4c:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[0,0],ymm0[4,4],ymm1[4,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_08084c4c:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_08084c4c:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,0,1,4,5,4,5]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8i32_08084c4c:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,8,0,8,4,12,4,12]
; AVX512VL-FAST-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 8, i32 0, i32 8, i32 4, i32 12, i32 4, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_8823cc67(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_8823cc67:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,0],ymm0[2,3],ymm1[4,4],ymm0[6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 8, i32 8, i32 2, i32 3, i32 12, i32 12, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_9832dc76(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_9832dc76:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,0],ymm0[3,2],ymm1[5,4],ymm0[7,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 9, i32 8, i32 3, i32 2, i32 13, i32 12, i32 7, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_9810dc54(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_9810dc54:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 9, i32 8, i32 1, i32 0, i32 13, i32 12, i32 5, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_08194c5d(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_08194c5d:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 4, i32 12, i32 5, i32 13>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_2a3b6e7f(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_2a3b6e7f:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 10, i32 3, i32 11, i32 6, i32 14, i32 7, i32 15>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_08192a3b(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_08192a3b:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1OR2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_08192a3b:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,8,1,9,2,10,3,11]
; AVX512VL-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_08991abb(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_08991abb:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm1[1,1]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_08991abb:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,1,1,4,4,5,5]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_08991abb:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <0,u,u,u,1,u,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <u,0,1,1,u,2,3,3>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_08991abb:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,1,1,4,4,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_08991abb:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,0,1,1,9,2,3,3]
; AVX512VL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 8, i32 9, i32 9, i32 1, i32 10, i32 11, i32 11>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_091b2d3f(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_091b2d3f:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_091b2d3f:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_091b2d3f:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpmovzxdq {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512VL-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_091b2d3f:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,9,1,11,2,13,3,15]
; AVX512VL-FAST-ALL-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_091b2d3f:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512VL-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 9, i32 1, i32 11, i32 2, i32 13, i32 3, i32 15>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_09ab1def(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_09ab1def:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_09ab1def:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_09ab1def:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <0,u,u,u,1,u,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_09ab1def:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_09ab1def:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,1,2,3,9,5,6,7]
; AVX512VL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 1, i32 13, i32 14, i32 15>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00014445(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_00014445:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,1,4,4,4,5]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 1, i32 4, i32 4, i32 4, i32 5>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00204464(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_00204464:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,0,4,4,6,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 0, i32 4, i32 4, i32 6, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_03004744(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_03004744:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,3,0,0,4,7,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 3, i32 0, i32 0, i32 4, i32 7, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_10005444(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_10005444:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,0,0,5,4,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 0, i32 0, i32 5, i32 4, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_22006644(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_22006644:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,2,0,0,6,6,4,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 2, i32 0, i32 0, i32 6, i32 6, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_33307774(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_33307774:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,3,3,0,7,7,7,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 3, i32 3, i32 0, i32 7, i32 7, i32 7, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_32107654(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_32107654:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00234467(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_00234467:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,3,4,4,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 3, i32 4, i32 4, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00224466(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00224466:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00224466:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_10325476(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_10325476:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,3,2,5,4,7,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_11335577(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_11335577:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_11335577:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_10235467(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_10235467:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,2,3,5,4,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 2, i32 3, i32 5, i32 4, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_10225466(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_10225466:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,2,2,5,4,6,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 2, i32 2, i32 5, i32 4, i32 6, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00015444(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00015444:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,1,5,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00015444:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,0,1,5,4,4,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 1, i32 5, i32 4, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00204644(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00204644:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,0,4,6,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00204644:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,2,0,4,6,4,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 0, i32 4, i32 6, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_03004474(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_03004474:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,3,0,0,4,4,7,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_03004474:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,3,0,0,4,4,7,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 3, i32 0, i32 0, i32 4, i32 4, i32 7, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_10004444(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_10004444:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_10004444:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [1,0,0,0,4,4,4,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_22006446(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_22006446:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,2,0,0,6,4,4,6]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_22006446:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [2,2,0,0,6,4,4,6]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 2, i32 0, i32 0, i32 6, i32 4, i32 4, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_33307474(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_33307474:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,3,3,0,7,4,7,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_33307474:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [3,3,3,0,7,4,7,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 3, i32 3, i32 0, i32 7, i32 4, i32 7, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_32104567(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_32104567:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_32104567:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [3,2,1,0,4,5,6,7]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00236744(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00236744:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,3,6,7,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00236744:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,2,3,6,7,4,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 3, i32 6, i32 7, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00226644(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00226644:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,2,6,6,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00226644:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,0,2,2,6,6,4,4]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 6, i32 6, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_10324567(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_10324567:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,3,2,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_10324567:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [1,0,3,2,4,5,6,7]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_11334567(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_11334567:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,3,3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_11334567:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [1,1,3,3,4,5,6,7]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_01235467(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_01235467:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,2,3,5,4,6,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_01235467:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,1,2,3,5,4,6,7]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 5, i32 4, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_01235466(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_01235466:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,1,2,3,5,4,6,6]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_01235466:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = [0,1,2,3,5,4,6,6]
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 5, i32 4, i32 6, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_002u6u44(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_002u6u44:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,2,u,6,u,4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_002u6u44:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = <0,0,2,u,6,u,4,4>
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 2, i32 undef, i32 6, i32 undef, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_00uu66uu(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_00uu66uu:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,u,u,6,6,u,u]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_00uu66uu:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = <0,0,u,u,6,6,u,u>
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 0, i32 undef, i32 undef, i32 6, i32 6, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_103245uu(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_103245uu:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,0,3,2,4,5,u,u]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_103245uu:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = <1,0,3,2,4,5,u,u>
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 4, i32 5, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_1133uu67(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_1133uu67:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,1,3,3,u,u,6,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_1133uu67:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = <1,1,3,3,u,u,6,7>
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 undef, i32 undef, i32 6, i32 7>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_0uu354uu(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_0uu354uu:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,u,u,3,5,4,u,u]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_0uu354uu:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = <0,u,u,3,5,4,u,u>
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 undef, i32 undef, i32 3, i32 5, i32 4, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_uuu3uu66(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_uuu3uu66:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[u,u,u,3,u,u,6,6]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_uuu3uu66:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vmovaps {{.*#+}} ymm1 = <u,u,u,3,u,u,6,6>
; AVX2OR512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 3, i32 undef, i32 undef, i32 6, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_6caa87e5(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_6caa87e5:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,0],ymm1[2,2],ymm2[4,4],ymm1[6,6]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4],ymm0[5],ymm1[6],ymm0[7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_6caa87e5:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,1,3,2]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,2,2,4,4,6,6]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_6caa87e5:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = <u,4,2,2,0,u,6,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,1,3,2]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_6caa87e5:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,2,2,4,4,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_6caa87e5:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [14,4,2,2,0,15,6,13]
; AVX512VL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 6, i32 12, i32 10, i32 10, i32 8, i32 7, i32 14, i32 5>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_32103210(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_32103210:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_32103210:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_32103210:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [3,2,1,0,3,2,1,0]
; AVX2-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_32103210:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_32103210:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_32103210:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [3,2,1,0,3,2,1,0]
; AVX512VL-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-FAST-ALL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_32103210:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_76547654(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_76547654:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_76547654:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_76547654:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [7,6,5,4,7,6,5,4]
; AVX2-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_76547654:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_76547654:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_76547654:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [7,6,5,4,7,6,5,4]
; AVX512VL-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-FAST-ALL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_76547654:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_76543210(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_76543210:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_76543210:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_76543210:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [7,6,5,4,3,2,1,0]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_76543210:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_76543210:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_76543210:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm1 = [7,6,5,4,3,2,1,0]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_76543210:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_3210ba98(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_3210ba98:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_3210ba98:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_3210ba98:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,2,1,0,11,10,9,8]
; AVX512VL-FAST-ALL-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_3210ba98:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 11, i32 10, i32 9, i32 8>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_3210fedc(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_3210fedc:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_3210fedc:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8i32_3210fedc:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,2,1,0,15,14,13,12]
; AVX512VL-FAST-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_7654fedc(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_7654fedc:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_7654fedc:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_7654fedc:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [7,6,5,4,15,14,13,12]
; AVX512VL-FAST-ALL-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_7654fedc:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 15, i32 14, i32 13, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_fedc7654(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_fedc7654:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_fedc7654:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512VL-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_fedc7654:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [7,6,5,4,15,14,13,12]
; AVX512VL-FAST-ALL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_fedc7654:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 15, i32 14, i32 13, i32 12, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_ba987654(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_ba987654:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_ba987654:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8i32_ba987654:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,2,1,0,15,14,13,12]
; AVX512VL-FAST-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_ba983210(<8 x i32> %a, <8 x i32> %b) {
; AVX1OR2-LABEL: shuffle_v8i32_ba983210:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1OR2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_ba983210:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v8i32_ba983210:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,2,1,0,15,14,13,12]
; AVX512VL-FAST-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_089abcde(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_089abcde:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,0],ymm1[0,0],ymm2[7,4],ymm1[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,2],ymm1[1,2],ymm2[4,6],ymm1[5,6]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_089abcde:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <u,0,1,2,3,4,5,6>
; AVX2-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_089abcde:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    valignd {{.*#+}} ymm1 = ymm1[7,0,1,2,3,4,5,6]
; AVX512VL-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_089abcde:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,0,1,2,3,4,5,6]
; AVX512VL-FAST-ALL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_089abcde:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    valignd {{.*#+}} ymm1 = ymm1[7,0,1,2,3,4,5,6]
; AVX512VL-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_0189abcd(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_0189abcd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_0189abcd:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,1,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_0189abcd:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,1,2]
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_0189abcd:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,0,1,2]
; AVX512VL-FAST-ALL-NEXT:    vpermi2q %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_0189abcd:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,1,2]
; AVX512VL-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_01289abc(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_01289abc:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0],ymm2[3,0],ymm1[4,4],ymm2[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,2],ymm1[2,0],ymm2[5,6],ymm1[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_01289abc:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <u,u,u,0,1,2,3,4>
; AVX2-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_01289abc:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    valignd {{.*#+}} ymm1 = ymm1[5,6,7,0,1,2,3,4]
; AVX512VL-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_01289abc:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,9,10,0,1,2,3,4]
; AVX512VL-FAST-ALL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_01289abc:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    valignd {{.*#+}} ymm1 = ymm1[5,6,7,0,1,2,3,4]
; AVX512VL-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5,6,7]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 8, i32 9, i32 10, i32 11, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_zuu8zuuc(<8 x i32> %a) {
; AVX1-LABEL: shuffle_v8i32_zuu8zuuc:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,0],ymm0[0,0],ymm1[4,4],ymm0[4,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_zuu8zuuc:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpslldq {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,2,3],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[16,17,18,19]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> zeroinitializer, <8 x i32> %a, <8 x i32> <i32 0, i32 undef, i32 undef, i32 8, i32 0, i32 undef, i32 undef, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_9ubzdefz(<8 x i32> %a) {
; AVX1-LABEL: shuffle_v8i32_9ubzdefz:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,2],ymm1[2,0],ymm0[5,6],ymm1[6,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_9ubzdefz:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpsrldq {{.*#+}} ymm0 = ymm0[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,ymm0[20,21,22,23,24,25,26,27,28,29,30,31],zero,zero,zero,zero
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> zeroinitializer, <8 x i32> %a, <8 x i32> <i32 9, i32 undef, i32 11, i32 0, i32 13, i32 14, i32 15, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_80u1b4uu(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_80u1b4uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 8, i32 0, i32 undef, i32 1, i32 12, i32 4, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_uuuu1111(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_uuuu1111:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; ALL-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 1, i32 1, i32 1, i32 1>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_2222uuuu(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_2222uuuu:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,2,2,2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 2, i32 2, i32 2, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_2A3Buuuu(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_2A3Buuuu:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 10, i32 3, i32 11, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_44444444(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_44444444:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_44444444:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_44444444:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_44444444:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_44444444:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_44444444:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_44444444:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_44444444_bc(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: shuffle_v8i32_44444444_bc:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,0,4,4,4,4]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v8i32_44444444_bc:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: shuffle_v8i32_44444444_bc:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: shuffle_v8i32_44444444_bc:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v8i32_44444444_bc:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v8i32_44444444_bc:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VL-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v8i32_44444444_bc:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-FAST-PERLANE-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %tmp0 = bitcast <8 x float> %a to <8 x i32>
  %tmp1 = bitcast <8 x float> %b to <8 x i32>
  %shuffle = shufflevector <8 x i32> %tmp0, <8 x i32> %tmp1, <8 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_5555uuuu(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_5555uuuu:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm0, %xmm0
; ALL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_0dcd3f14(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_0dcd3f14:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm0[1,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[3,1,1,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX1-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5],ymm0[6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_0dcd3f14:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <0,u,u,u,3,u,1,4>
; AVX2-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_0dcd3f14:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,5,4,5,11,7,9,12]
; AVX512VL-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 13, i32 12, i32 13, i32 3, i32 15, i32 1, i32 4>
  ret <8 x i32> %shuffle
}

; PR32453
define <8 x i32> @shuffle_v8i32_uuuuuu7u(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: shuffle_v8i32_uuuuuu7u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_uuuuuu7u:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,3,3,3,7,7,7,7]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 7, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_32107654_v4i32(<4 x i32> %a, <4 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_32107654_v4i32:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %2 = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %3 = shufflevector <4 x i32> %1, <4 x i32> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %3
}

define <8 x i32> @shuffle_v8i32_00004444_v4f32(<4 x i32> %a, <4 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_00004444_v4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,0,0,0,4,4,4,4]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  ret <8 x i32> %1
}

define <8 x float> @splat_mem_v8f32_2(ptr %p) {
; ALL-LABEL: splat_mem_v8f32_2:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastss (%rdi), %ymm0
; ALL-NEXT:    retq
  %1 = load float, ptr %p
  %2 = insertelement <4 x float> undef, float %1, i32 0
  %3 = shufflevector <4 x float> %2, <4 x float> undef, <8 x i32> zeroinitializer
  ret <8 x float> %3
}

define <8 x float> @splat_v8f32(<4 x float> %r) {
; AVX1-LABEL: splat_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: splat_v8f32:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2OR512VL-NEXT:    retq
  %1 = shufflevector <4 x float> %r, <4 x float> undef, <8 x i32> zeroinitializer
  ret <8 x float> %1
}

;
; Shuffle to logical bit shifts
;

define <8 x i32> @shuffle_v8i32_z0U2zUz6(<8 x i32> %a) {
; AVX1-LABEL: shuffle_v8i32_z0U2zUz6:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,3,1,6,4,7,5]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_z0U2zUz6:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> zeroinitializer, <8 x i32> <i32 8, i32 0, i32 undef, i32 2, i32 8, i32 undef, i32 8, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_1U3z5zUU(<8 x i32> %a) {
; AVX1-LABEL: shuffle_v8i32_1U3z5zUU:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_1U3z5zUU:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> zeroinitializer, <8 x i32> <i32 1, i32 undef, i32 3, i32 8, i32 5, i32 8, i32 undef, i32 undef>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_B012F456(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_B012F456:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,0],ymm0[0,0],ymm1[7,4],ymm0[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm0[1,2],ymm1[4,6],ymm0[5,6]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_B012F456:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpalignr {{.*#+}} ymm0 = ymm1[12,13,14,15],ymm0[0,1,2,3,4,5,6,7,8,9,10,11],ymm1[28,29,30,31],ymm0[16,17,18,19,20,21,22,23,24,25,26,27]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 11, i32 0, i32 1, i32 2, i32 15, i32 4, i32 5, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_1238567C(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_1238567C:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0],ymm0[3,0],ymm1[4,4],ymm0[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,2],ymm1[2,0],ymm0[5,6],ymm1[6,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_1238567C:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[4,5,6,7,8,9,10,11,12,13,14,15],ymm1[0,1,2,3],ymm0[20,21,22,23,24,25,26,27,28,29,30,31],ymm1[16,17,18,19]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 2, i32 3, i32 8, i32 5, i32 6, i32 7, i32 12>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_9AB0DEF4(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_9AB0DEF4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0],ymm1[3,0],ymm0[4,4],ymm1[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,2],ymm0[2,0],ymm1[5,6],ymm0[6,4]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_9AB0DEF4:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpalignr {{.*#+}} ymm0 = ymm1[4,5,6,7,8,9,10,11,12,13,14,15],ymm0[0,1,2,3],ymm1[20,21,22,23,24,25,26,27,28,29,30,31],ymm0[16,17,18,19]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 9, i32 10, i32 11, i32 0, i32 13, i32 14, i32 15, i32 4>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_389A7CDE(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_389A7CDE:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0],ymm1[0,0],ymm0[7,4],ymm1[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[1,2],ymm0[4,6],ymm1[5,6]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: shuffle_v8i32_389A7CDE:
; AVX2OR512VL:       # %bb.0:
; AVX2OR512VL-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[12,13,14,15],ymm1[0,1,2,3,4,5,6,7,8,9,10,11],ymm0[28,29,30,31],ymm1[16,17,18,19,20,21,22,23,24,25,26,27]
; AVX2OR512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 8, i32 9, i32 10, i32 7, i32 12, i32 13, i32 14>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_30127456(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_30127456:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,0,1,2,7,4,5,6]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 3, i32 0, i32 1, i32 2, i32 7, i32 4, i32 5, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_12305674(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: shuffle_v8i32_12305674:
; ALL:       # %bb.0:
; ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[1,2,3,0,5,6,7,4]
; ALL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 2, i32 3, i32 0, i32 5, i32 6, i32 7, i32 4>
  ret <8 x i32> %shuffle
}

define <8x float> @concat_v2f32_1(ptr %tmp64, ptr %tmp65) {
; ALL-LABEL: concat_v2f32_1:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; ALL-NEXT:    vmovhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; ALL-NEXT:    retq
entry:
  %tmp74 = load <2 x float>, ptr %tmp65, align 8
  %tmp72 = load <2 x float>, ptr %tmp64, align 8
  %tmp73 = shufflevector <2 x float> %tmp72, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %tmp75 = shufflevector <2 x float> %tmp74, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %tmp76 = shufflevector <8 x float> %tmp73, <8 x float> %tmp75, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %tmp76
}

define <8x float> @concat_v2f32_2(ptr %tmp64, ptr %tmp65) {
; ALL-LABEL: concat_v2f32_2:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; ALL-NEXT:    vmovhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; ALL-NEXT:    retq
entry:
  %tmp74 = load <2 x float>, ptr %tmp65, align 8
  %tmp72 = load <2 x float>, ptr %tmp64, align 8
  %tmp76 = shufflevector <2 x float> %tmp72, <2 x float> %tmp74, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %tmp76
}

define <8x float> @concat_v2f32_3(ptr %tmp64, ptr %tmp65) {
; ALL-LABEL: concat_v2f32_3:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; ALL-NEXT:    vmovhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; ALL-NEXT:    retq
entry:
  %tmp74 = load <2 x float>, ptr %tmp65, align 8
  %tmp72 = load <2 x float>, ptr %tmp64, align 8
  %tmp76 = shufflevector <2 x float> %tmp72, <2 x float> %tmp74, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x float> %tmp76, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %res
}

define <8 x i32> @insert_mem_and_zero_v8i32(ptr %ptr) {
; ALL-LABEL: insert_mem_and_zero_v8i32:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; ALL-NEXT:    retq
  %a = load i32, ptr %ptr
  %v = insertelement <8 x i32> undef, i32 %a, i32 0
  %shuffle = shufflevector <8 x i32> %v, <8 x i32> zeroinitializer, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i32> %shuffle
}

define <8 x i32> @concat_v8i32_0123CDEF(<8 x i32> %a, <8 x i32> %b) {
; ALL-LABEL: concat_v8i32_0123CDEF:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; ALL-NEXT:    retq
  %alo = shufflevector <8 x i32> %a, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %bhi = shufflevector <8 x i32> %b, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuf = shufflevector <4 x i32> %alo, <4 x i32> %bhi, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %shuf
}

define <8 x i32> @concat_v8i32_4567CDEF_bc(<8 x i32> %a0, <8 x i32> %a1) {
; AVX1OR2-LABEL: concat_v8i32_4567CDEF_bc:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: concat_v8i32_4567CDEF_bc:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-NEXT:    retq
  %a0hi = shufflevector <8 x i32> %a0, <8 x i32> %a1, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %a1hi = shufflevector <8 x i32> %a0, <8 x i32> %a1, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  %bc0hi = bitcast <4 x i32> %a0hi to <2 x i64>
  %bc1hi = bitcast <4 x i32> %a1hi to <2 x i64>
  %shuffle64 = shufflevector <2 x i64> %bc0hi, <2 x i64> %bc1hi, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle32 = bitcast <4 x i64> %shuffle64 to <8 x i32>
  ret <8 x i32> %shuffle32
}

define <8 x float> @concat_v8f32_4567CDEF_bc(<8 x float> %f0, <8 x float> %f1) {
; ALL-LABEL: concat_v8f32_4567CDEF_bc:
; ALL:       # %bb.0:
; ALL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; ALL-NEXT:    retq
  %a0 = bitcast <8 x float> %f0 to <4 x i64>
  %a1 = bitcast <8 x float> %f1 to <8 x i32>
  %a0hi = shufflevector <4 x i64> %a0, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %a1hi = shufflevector <8 x i32> %a1, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %bc0hi = bitcast <2 x i64> %a0hi to <2 x i64>
  %bc1hi = bitcast <4 x i32> %a1hi to <2 x i64>
  %shuffle64 = shufflevector <2 x i64> %bc0hi, <2 x i64> %bc1hi, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle32 = bitcast <4 x i64> %shuffle64 to <8 x float>
  ret <8 x float> %shuffle32
}

define <8 x i32> @insert_dup_mem_v8i32(ptr %ptr) {
; ALL-LABEL: insert_dup_mem_v8i32:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastss (%rdi), %ymm0
; ALL-NEXT:    retq
  %tmp = load i32, ptr %ptr, align 4
  %tmp1 = insertelement <4 x i32> zeroinitializer, i32 %tmp, i32 0
  %tmp2 = shufflevector <4 x i32> %tmp1, <4 x i32> undef, <8 x i32> zeroinitializer
  ret <8 x i32> %tmp2
}

define <8 x i32> @shuffle_v8i32_12345678(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: shuffle_v8i32_12345678:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0],ymm0[3,0],ymm1[4,4],ymm0[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,2],ymm1[2,0],ymm0[5,6],ymm1[6,4]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_12345678:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[4,5,6,7,8,9,10,11,12,13,14,15],ymm1[0,1,2,3],ymm0[20,21,22,23,24,25,26,27,28,29,30,31],ymm1[16,17,18,19]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_12345678:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    valignd {{.*#+}} ymm0 = ymm0[1,2,3,4,5,6,7],ymm1[0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_v8i32_12345670(<8 x i32> %a) {
; AVX1-LABEL: shuffle_v8i32_12345670:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0],ymm0[3,0],ymm1[4,4],ymm0[7,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,2],ymm1[2,0],ymm0[5,6],ymm1[6,4]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v8i32_12345670:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps {{.*#+}} ymm1 = [1,2,3,4,5,6,7,0]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_12345670:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    valignd {{.*#+}} ymm0 = ymm0[1,2,3,4,5,6,7,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> undef, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0>
  ret <8 x i32> %shuffle
}

define <8 x float> @add_v8f32_02468ACE_13579BDF(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: add_v8f32_02468ACE_13579BDF:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vhaddps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: add_v8f32_02468ACE_13579BDF:
; AVX2OR512VL:       # %bb.0: # %entry
; AVX2OR512VL-NEXT:    vhaddps %ymm1, %ymm0, %ymm0
; AVX2OR512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2OR512VL-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %shuffle1 = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %add = fadd <8 x float> %shuffle, %shuffle1
  ret <8 x float> %add
}

define <8 x float> @add_v8f32_8ACE0246_9BDF1357(<8 x float> %a, <8 x float> %b) {
; AVX1-LABEL: add_v8f32_8ACE0246_9BDF1357:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vhaddps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: add_v8f32_8ACE0246_9BDF1357:
; AVX2OR512VL:       # %bb.0: # %entry
; AVX2OR512VL-NEXT:    vhaddps %ymm1, %ymm0, %ymm0
; AVX2OR512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2OR512VL-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 8, i32 10, i32 12, i32 14, i32 0, i32 2, i32 4, i32 6>
  %shuffle1 = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 9, i32 11, i32 13, i32 15, i32 1, i32 3, i32 5, i32 7>
  %add = fadd <8 x float> %shuffle, %shuffle1
  ret <8 x float> %add
}

define <8 x i32> @add_v8i32_02468ACE_13579BDF(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: add_v8i32_02468ACE_13579BDF:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vphaddd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm2, %ymm2
; AVX1-NEXT:    vphaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[3],ymm2[3]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: add_v8i32_02468ACE_13579BDF:
; AVX2OR512VL:       # %bb.0: # %entry
; AVX2OR512VL-NEXT:    vphaddd %ymm1, %ymm0, %ymm0
; AVX2OR512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2OR512VL-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %shuffle1 = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %add = add <8 x i32> %shuffle, %shuffle1
  ret <8 x i32> %add
}

define <8 x i32> @add_v8i32_8ACE0246_9BDF1357(<8 x i32> %a, <8 x i32> %b) {
; AVX1-LABEL: add_v8i32_8ACE0246_9BDF1357:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vphaddd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm2, %ymm2
; AVX1-NEXT:    vphaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[2],ymm2[2]
; AVX1-NEXT:    retq
;
; AVX2OR512VL-LABEL: add_v8i32_8ACE0246_9BDF1357:
; AVX2OR512VL:       # %bb.0: # %entry
; AVX2OR512VL-NEXT:    vphaddd %ymm1, %ymm0, %ymm0
; AVX2OR512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2OR512VL-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 8, i32 10, i32 12, i32 14, i32 0, i32 2, i32 4, i32 6>
  %shuffle1 = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 9, i32 11, i32 13, i32 15, i32 1, i32 3, i32 5, i32 7>
  %add = add <8 x i32> %shuffle, %shuffle1
  ret <8 x i32> %add
}

; This test used to crash due to bad handling of concat_vectors after a bitcast
; in lowerVectorShuffleAsBroadcast.
define <8 x float> @broadcast_concat_crash(<4 x float> %x, <4 x float> %y, float %z) {
; AVX1-LABEL: broadcast_concat_crash:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[3,3,3,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: broadcast_concat_crash:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: broadcast_concat_crash:
; AVX512VL-SLOW:       # %bb.0: # %entry
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX512VL-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-SLOW-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[2,3]
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: broadcast_concat_crash:
; AVX512VL-FAST:       # %bb.0: # %entry
; AVX512VL-FAST-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX512VL-FAST-NEXT:    vmovaps {{.*#+}} xmm1 = [1,4,3,3]
; AVX512VL-FAST-NEXT:    vpermi2ps %xmm2, %xmm0, %xmm1
; AVX512VL-FAST-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-NEXT:    retq
entry:
  %tmp = shufflevector <4 x float> %x, <4 x float> %y, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %bc = bitcast <8 x float> %tmp to <4 x i64>
  %tmp1 = extractelement <4 x i64> %bc, i32 3
  %tmp2 = bitcast i64 %tmp1 to <2 x float>
  %tmp4 = extractelement <2 x float> %tmp2, i32 1
  %tmp5 = insertelement <8 x float> undef, float %tmp4, i32 4
  %tmp6 = insertelement <8 x float> %tmp5, float %z, i32 5
  ret <8 x float> %tmp6
}

; PR40434: https://bugs.llvm.org/show_bug.cgi?id=40434

define <8 x i32> @unpckh_v8i32(<8 x i32> %x, <8 x i32> %y) {
; ALL-LABEL: unpckh_v8i32:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm1, %xmm1
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %unpckh = shufflevector <8 x i32> %x, <8 x i32> %y, <8 x i32> <i32 2, i32 14, i32 3, i32 15, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %unpckh
}

; Same as above but with floats.

define <8 x float> @unpckh_v8f32(<8 x float> %x, <8 x float> %y) {
; ALL-LABEL: unpckh_v8f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm1, %xmm1
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %unpckh = shufflevector <8 x float> %x, <8 x float> %y, <8 x i32> <i32 2, i32 14, i32 3, i32 15, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %unpckh
}

; Alternate form of the above - make sure we don't have conflicting transforms.

define <8 x i32> @blend_perm_v8i32(<8 x i32> %x, <8 x i32> %y) {
; ALL-LABEL: blend_perm_v8i32:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm1, %xmm1
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %unpckh = shufflevector <8 x i32> %x, <8 x i32> %y, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 14, i32 15>
  %r = shufflevector <8 x i32> %unpckh, <8 x i32> undef, <8 x i32> <i32 2, i32 6, i32 3, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %r
}

; Same as above but with floats.

define <8 x float> @blend_perm_v8f32(<8 x float> %x, <8 x float> %y) {
; ALL-LABEL: blend_perm_v8f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm1, %xmm1
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %unpckh = shufflevector <8 x float> %x, <8 x float> %y, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 14, i32 15>
  %r = shufflevector <8 x float> %unpckh, <8 x float> undef, <8 x i32> <i32 2, i32 6, i32 3, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %r
}

; Another variation of the above - make sure we don't have conflicting transforms.

define <8 x i32> @unpckh_v8i32_unary(<8 x i32> %x) {
; ALL-LABEL: unpckh_v8i32_unary:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm0, %xmm1
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %r = shufflevector <8 x i32> %x, <8 x i32> undef, <8 x i32> <i32 2, i32 6, i32 3, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %r
}

; Same as above but with floats.

define <8 x float> @unpckh_v8f32_unary(<8 x float> %x) {
; ALL-LABEL: unpckh_v8f32_unary:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm0, %xmm1
; ALL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; ALL-NEXT:    retq
  %r = shufflevector <8 x float> %x, <8 x float> undef, <8 x i32> <i32 2, i32 6, i32 3, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %r
}

; FIXME: Why are integer and FP (below) lowering different for AVX1?

define <8 x i32> @lowhalf_v8i32(<8 x i32> %x, <8 x i32> %y) {
; AVX1-LABEL: lowhalf_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,2,2,2]
; AVX1-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: lowhalf_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps {{.*#+}} xmm1 = [2,6,3,6]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: lowhalf_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm2 = [2,14,3,14]
; AVX512VL-NEXT:    vpermt2d %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %r = shufflevector <8 x i32> %x, <8 x i32> %y, <8 x i32> <i32 2, i32 14, i32 3, i32 14, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %r
}

; FIXME: AVX1 lowering is better than AVX2 (and AVX512?)

define <8 x float> @lowhalf_v8f32(<8 x float> %x, <8 x float> %y) {
; AVX1-LABEL: lowhalf_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,3],xmm1[2,2]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: lowhalf_v8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps {{.*#+}} xmm1 = [2,6,3,6]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: lowhalf_v8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps {{.*#+}} xmm2 = [2,14,3,14]
; AVX512VL-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %r = shufflevector <8 x float> %x, <8 x float> %y, <8 x i32> <i32 2, i32 14, i32 3, i32 14, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %r
}

