; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=bonaire -amdgpu-atomic-optimizations=false -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=CI %s
; RUN: llc -march=amdgcn -mcpu=tonga -amdgpu-atomic-optimizations=false -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=VI %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizations=false -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s

define amdgpu_kernel void @atomic_max_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_max_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x8
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB0_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB0_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[10:11], s[0:1], 0x20
; VI-NEXT:    s_add_u32 s4, s0, 32
; VI-NEXT:    s_addc_u32 s5, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:  .LBB0_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB0_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB0_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_max_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB1_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB1_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s0, s4, 32
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB1_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB1_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB1_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB2_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB2_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s4, s4, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB2_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB2_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB2_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB3_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB3_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dwordx2 s[12:13], s[6:7], 0x20
; VI-NEXT:    s_add_u32 s8, s6, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s9, s7, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB3_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB3_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB3_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_max_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB4_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB4_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB4_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[6:7], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s7
; VI-NEXT:    v_mov_b32_e32 v4, s6
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB4_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB4_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %out, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_max_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB5_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB5_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB5_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB5_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB5_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %out, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB6_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB6_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB6_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB6_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB6_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %ptr, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB7_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB7_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s8, s0, s6
; VI-NEXT:    s_addc_u32 s9, s1, s7
; VI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:  .LBB7_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB7_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB7_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %ptr, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umax_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x8
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB8_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB8_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[10:11], s[0:1], 0x20
; VI-NEXT:    s_add_u32 s4, s0, 32
; VI-NEXT:    s_addc_u32 s5, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:  .LBB8_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB8_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB8_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umax_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB9_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB9_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s0, s4, 32
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB9_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB9_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB9_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB10_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB10_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s4, s4, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB10_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB10_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB10_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB11_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB11_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dwordx2 s[12:13], s[6:7], 0x20
; VI-NEXT:    s_add_u32 s8, s6, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s9, s7, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB11_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB11_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB11_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umax_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB12_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB12_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB12_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s7
; VI-NEXT:    v_mov_b32_e32 v4, s6
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB12_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB12_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %out, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umax_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB13_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB13_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB13_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB13_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB13_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %out, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB14_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB14_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB14_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB14_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB14_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %ptr, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB15_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB15_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s8, s0, s6
; VI-NEXT:    s_addc_u32 s9, s1, s7
; VI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:  .LBB15_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB15_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB15_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %ptr, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_min_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x8
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB16_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB16_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[10:11], s[0:1], 0x20
; VI-NEXT:    s_add_u32 s4, s0, 32
; VI-NEXT:    s_addc_u32 s5, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:  .LBB16_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB16_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB16_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_min_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB17_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB17_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s0, s4, 32
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB17_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB17_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB17_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB18_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB18_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s4, s4, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB18_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB18_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB18_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB19_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB19_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dwordx2 s[12:13], s[6:7], 0x20
; VI-NEXT:    s_add_u32 s8, s6, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s9, s7, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB19_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB19_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB19_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_min_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB20_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB20_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB20_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[6:7], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s7
; VI-NEXT:    v_mov_b32_e32 v4, s6
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB20_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB20_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %out, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_min_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB21_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB21_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB21_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB21_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB21_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %out, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB22_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB22_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB22_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB22_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB22_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %ptr, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB23_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_i64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB23_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s8, s0, s6
; VI-NEXT:    s_addc_u32 s9, s1, s7
; VI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:  .LBB23_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_i64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB23_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_i64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB23_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %ptr, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umin_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x8
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB24_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB24_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[10:11], s[0:1], 0x20
; VI-NEXT:    s_add_u32 s4, s0, 32
; VI-NEXT:    s_addc_u32 s5, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:  .LBB24_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB24_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB24_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umin_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB25_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB25_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s0, s4, 32
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB25_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB25_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB25_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB26_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB26_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x20
; VI-NEXT:    s_add_u32 s4, s4, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB26_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB26_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB26_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB27_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB27_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dwordx2 s[12:13], s[6:7], 0x20
; VI-NEXT:    s_add_u32 s8, s6, 32
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_addc_u32 s9, s7, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB27_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB27_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x20
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB27_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umin_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b64 s[4:5], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB28_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[6:7], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s7
; CI-NEXT:    v_mov_b32_e32 v4, s6
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; CI-NEXT:    s_cbranch_execnz .LBB28_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB28_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[6:7], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s7
; VI-NEXT:    v_mov_b32_e32 v4, s6
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB28_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v5, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB28_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %out, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umin_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; CI-NEXT:    s_mov_b64 s[10:11], 0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s12
; CI-NEXT:    v_mov_b32_e32 v3, s13
; CI-NEXT:  .LBB29_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[8:9], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    v_mov_b32_e32 v4, s8
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; CI-NEXT:    s_cbranch_execnz .LBB29_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[10:11]
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[10:11], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_mov_b32_e32 v3, s13
; VI-NEXT:  .LBB29_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[8:9], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v4, s8
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; VI-NEXT:    s_cbranch_execnz .LBB29_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[10:11]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB29_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %out, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    s_add_u32 s4, s0, s4
; CI-NEXT:    s_addc_u32 s5, s1, s5
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s8
; CI-NEXT:    v_mov_b32_e32 v3, s9
; CI-NEXT:  .LBB30_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB30_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:  .LBB30_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB30_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB30_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %ptr, i64 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; CI-NEXT:    s_add_u32 s8, s0, s6
; CI-NEXT:    s_addc_u32 s9, s1, s7
; CI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; CI-NEXT:    s_mov_b64 s[0:1], 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:  .LBB31_1: ; %atomicrmw.start
; CI-NEXT:    ; =>This Inner Loop Header: Depth=1
; CI-NEXT:    v_cmp_ge_u64_e32 vcc, s[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_mov_b32_e32 v7, v3
; CI-NEXT:    v_mov_b32_e32 v6, v2
; CI-NEXT:    v_mov_b32_e32 v5, v1
; CI-NEXT:    v_mov_b32_e32 v4, v0
; CI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; CI-NEXT:    v_mov_b32_e32 v2, v4
; CI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, v5
; CI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; CI-NEXT:    s_cbranch_execnz .LBB31_1
; CI-NEXT:  ; %bb.2: ; %atomicrmw.end
; CI-NEXT:    s_or_b64 exec, exec, s[0:1]
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; VI-NEXT:    s_add_u32 s8, s0, s6
; VI-NEXT:    s_addc_u32 s9, s1, s7
; VI-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:  .LBB31_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_cmp_ge_u64_e32 vcc, s[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v3, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v7, v3
; VI-NEXT:    v_mov_b32_e32 v6, v2
; VI-NEXT:    v_mov_b32_e32 v5, v1
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v2, v4
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v5
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB31_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX9-NEXT:    s_add_u32 s0, s0, s6
; GFX9-NEXT:    s_addc_u32 s1, s1, s7
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-NEXT:    v_cmp_ge_u64_e32 vcc, s[4:5], v[5:6]
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v5, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v2, v[3:6], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[5:6]
; GFX9-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_execnz .LBB31_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %ptr, i64 %in seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}
