/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"reflect"
)


// PulpAnsibleDefaultApiV3CollectionsAllAPIService PulpAnsibleDefaultApiV3CollectionsAllAPI service
type PulpAnsibleDefaultApiV3CollectionsAllAPIService service

type PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3CollectionsAllAPIService
	deprecated *bool
	name *string
	namespace *string
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) Deprecated(deprecated bool) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.deprecated = &deprecated
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) Name(name string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.name = &name
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) Namespace(namespace string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.namespace = &namespace
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;namespace&#x60; - Namespace * &#x60;-namespace&#x60; - Namespace (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) Ordering(ordering []string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) PulpHrefIn(pulpHrefIn []string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) PulpIdIn(pulpIdIn []string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) Fields(fields []string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) Execute() ([]CollectionResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3CollectionsAllListExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3CollectionsAllList Method for PulpAnsibleGalaxyDefaultApiV3CollectionsAllList

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest

Deprecated
*/
func (a *PulpAnsibleDefaultApiV3CollectionsAllAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsAllList(ctx context.Context) PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest {
	return PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return []CollectionResponse
// Deprecated
func (a *PulpAnsibleDefaultApiV3CollectionsAllAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsAllListExecute(r PulpAnsibleDefaultApiV3CollectionsAllAPIPulpAnsibleGalaxyDefaultApiV3CollectionsAllListRequest) ([]CollectionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  []CollectionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3CollectionsAllAPIService.PulpAnsibleGalaxyDefaultApiV3CollectionsAllList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/collections/all/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.deprecated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "deprecated", r.deprecated, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.namespace != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace", r.namespace, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
