/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the GalaxyCollectionVersionResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &GalaxyCollectionVersionResponse{}

// GalaxyCollectionVersionResponse A serializer for a CollectionVersion.
type GalaxyCollectionVersionResponse struct {
	Version string `json:"version"`
	// Get href.
	Href *string `json:"href,omitempty"`
	// Create a namespace dict.
	Namespace map[string]interface{} `json:"namespace,omitempty"`
	// Create a collection dict.
	Collection map[string]interface{} `json:"collection,omitempty"`
	// Create an artifact dict.
	Artifact map[string]interface{} `json:"artifact,omitempty"`
	Metadata CollectionMetadataResponse `json:"metadata"`
	AdditionalProperties map[string]interface{}
}

type _GalaxyCollectionVersionResponse GalaxyCollectionVersionResponse

// NewGalaxyCollectionVersionResponse instantiates a new GalaxyCollectionVersionResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGalaxyCollectionVersionResponse(version string, metadata CollectionMetadataResponse) *GalaxyCollectionVersionResponse {
	this := GalaxyCollectionVersionResponse{}
	this.Version = version
	this.Metadata = metadata
	return &this
}

// NewGalaxyCollectionVersionResponseWithDefaults instantiates a new GalaxyCollectionVersionResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGalaxyCollectionVersionResponseWithDefaults() *GalaxyCollectionVersionResponse {
	this := GalaxyCollectionVersionResponse{}
	return &this
}

// GetVersion returns the Version field value
func (o *GalaxyCollectionVersionResponse) GetVersion() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Version
}

// GetVersionOk returns a tuple with the Version field value
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionVersionResponse) GetVersionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Version, true
}

// SetVersion sets field value
func (o *GalaxyCollectionVersionResponse) SetVersion(v string) {
	o.Version = v
}

// GetHref returns the Href field value if set, zero value otherwise.
func (o *GalaxyCollectionVersionResponse) GetHref() string {
	if o == nil || IsNil(o.Href) {
		var ret string
		return ret
	}
	return *o.Href
}

// GetHrefOk returns a tuple with the Href field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionVersionResponse) GetHrefOk() (*string, bool) {
	if o == nil || IsNil(o.Href) {
		return nil, false
	}
	return o.Href, true
}

// HasHref returns a boolean if a field has been set.
func (o *GalaxyCollectionVersionResponse) HasHref() bool {
	if o != nil && !IsNil(o.Href) {
		return true
	}

	return false
}

// SetHref gets a reference to the given string and assigns it to the Href field.
func (o *GalaxyCollectionVersionResponse) SetHref(v string) {
	o.Href = &v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *GalaxyCollectionVersionResponse) GetNamespace() map[string]interface{} {
	if o == nil || IsNil(o.Namespace) {
		var ret map[string]interface{}
		return ret
	}
	return o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionVersionResponse) GetNamespaceOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Namespace) {
		return map[string]interface{}{}, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *GalaxyCollectionVersionResponse) HasNamespace() bool {
	if o != nil && !IsNil(o.Namespace) {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given map[string]interface{} and assigns it to the Namespace field.
func (o *GalaxyCollectionVersionResponse) SetNamespace(v map[string]interface{}) {
	o.Namespace = v
}

// GetCollection returns the Collection field value if set, zero value otherwise.
func (o *GalaxyCollectionVersionResponse) GetCollection() map[string]interface{} {
	if o == nil || IsNil(o.Collection) {
		var ret map[string]interface{}
		return ret
	}
	return o.Collection
}

// GetCollectionOk returns a tuple with the Collection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionVersionResponse) GetCollectionOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Collection) {
		return map[string]interface{}{}, false
	}
	return o.Collection, true
}

// HasCollection returns a boolean if a field has been set.
func (o *GalaxyCollectionVersionResponse) HasCollection() bool {
	if o != nil && !IsNil(o.Collection) {
		return true
	}

	return false
}

// SetCollection gets a reference to the given map[string]interface{} and assigns it to the Collection field.
func (o *GalaxyCollectionVersionResponse) SetCollection(v map[string]interface{}) {
	o.Collection = v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *GalaxyCollectionVersionResponse) GetArtifact() map[string]interface{} {
	if o == nil || IsNil(o.Artifact) {
		var ret map[string]interface{}
		return ret
	}
	return o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionVersionResponse) GetArtifactOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Artifact) {
		return map[string]interface{}{}, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *GalaxyCollectionVersionResponse) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given map[string]interface{} and assigns it to the Artifact field.
func (o *GalaxyCollectionVersionResponse) SetArtifact(v map[string]interface{}) {
	o.Artifact = v
}

// GetMetadata returns the Metadata field value
func (o *GalaxyCollectionVersionResponse) GetMetadata() CollectionMetadataResponse {
	if o == nil {
		var ret CollectionMetadataResponse
		return ret
	}

	return o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionVersionResponse) GetMetadataOk() (*CollectionMetadataResponse, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Metadata, true
}

// SetMetadata sets field value
func (o *GalaxyCollectionVersionResponse) SetMetadata(v CollectionMetadataResponse) {
	o.Metadata = v
}

func (o GalaxyCollectionVersionResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o GalaxyCollectionVersionResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["version"] = o.Version
	if !IsNil(o.Href) {
		toSerialize["href"] = o.Href
	}
	if !IsNil(o.Namespace) {
		toSerialize["namespace"] = o.Namespace
	}
	if !IsNil(o.Collection) {
		toSerialize["collection"] = o.Collection
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	toSerialize["metadata"] = o.Metadata

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *GalaxyCollectionVersionResponse) UnmarshalJSON(bytes []byte) (err error) {
	varGalaxyCollectionVersionResponse := _GalaxyCollectionVersionResponse{}

	if err = json.Unmarshal(bytes, &varGalaxyCollectionVersionResponse); err == nil {
		*o = GalaxyCollectionVersionResponse(varGalaxyCollectionVersionResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "version")
		delete(additionalProperties, "href")
		delete(additionalProperties, "namespace")
		delete(additionalProperties, "collection")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "metadata")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableGalaxyCollectionVersionResponse struct {
	value *GalaxyCollectionVersionResponse
	isSet bool
}

func (v NullableGalaxyCollectionVersionResponse) Get() *GalaxyCollectionVersionResponse {
	return v.value
}

func (v *NullableGalaxyCollectionVersionResponse) Set(val *GalaxyCollectionVersionResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableGalaxyCollectionVersionResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableGalaxyCollectionVersionResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGalaxyCollectionVersionResponse(val *GalaxyCollectionVersionResponse) *NullableGalaxyCollectionVersionResponse {
	return &NullableGalaxyCollectionVersionResponse{value: val, isSet: true}
}

func (v NullableGalaxyCollectionVersionResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGalaxyCollectionVersionResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


