/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PatchedcertguardRHSMCertGuard type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchedcertguardRHSMCertGuard{}

// PatchedcertguardRHSMCertGuard RHSM Content Guard Serializer.
type PatchedcertguardRHSMCertGuard struct {
	// The unique name.
	Name *string `json:"name,omitempty"`
	// An optional description.
	Description NullableString `json:"description,omitempty"`
	// A Certificate Authority (CA) certificate (or a bundle thereof) used to verify client-certificate authenticity.
	CaCertificate *string `json:"ca_certificate,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchedcertguardRHSMCertGuard PatchedcertguardRHSMCertGuard

// NewPatchedcertguardRHSMCertGuard instantiates a new PatchedcertguardRHSMCertGuard object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchedcertguardRHSMCertGuard() *PatchedcertguardRHSMCertGuard {
	this := PatchedcertguardRHSMCertGuard{}
	return &this
}

// NewPatchedcertguardRHSMCertGuardWithDefaults instantiates a new PatchedcertguardRHSMCertGuard object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchedcertguardRHSMCertGuardWithDefaults() *PatchedcertguardRHSMCertGuard {
	this := PatchedcertguardRHSMCertGuard{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PatchedcertguardRHSMCertGuard) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedcertguardRHSMCertGuard) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PatchedcertguardRHSMCertGuard) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PatchedcertguardRHSMCertGuard) SetName(v string) {
	o.Name = &v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchedcertguardRHSMCertGuard) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchedcertguardRHSMCertGuard) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *PatchedcertguardRHSMCertGuard) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *PatchedcertguardRHSMCertGuard) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *PatchedcertguardRHSMCertGuard) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *PatchedcertguardRHSMCertGuard) UnsetDescription() {
	o.Description.Unset()
}

// GetCaCertificate returns the CaCertificate field value if set, zero value otherwise.
func (o *PatchedcertguardRHSMCertGuard) GetCaCertificate() string {
	if o == nil || IsNil(o.CaCertificate) {
		var ret string
		return ret
	}
	return *o.CaCertificate
}

// GetCaCertificateOk returns a tuple with the CaCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedcertguardRHSMCertGuard) GetCaCertificateOk() (*string, bool) {
	if o == nil || IsNil(o.CaCertificate) {
		return nil, false
	}
	return o.CaCertificate, true
}

// HasCaCertificate returns a boolean if a field has been set.
func (o *PatchedcertguardRHSMCertGuard) HasCaCertificate() bool {
	if o != nil && !IsNil(o.CaCertificate) {
		return true
	}

	return false
}

// SetCaCertificate gets a reference to the given string and assigns it to the CaCertificate field.
func (o *PatchedcertguardRHSMCertGuard) SetCaCertificate(v string) {
	o.CaCertificate = &v
}

func (o PatchedcertguardRHSMCertGuard) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchedcertguardRHSMCertGuard) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}
	if !IsNil(o.CaCertificate) {
		toSerialize["ca_certificate"] = o.CaCertificate
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchedcertguardRHSMCertGuard) UnmarshalJSON(bytes []byte) (err error) {
	varPatchedcertguardRHSMCertGuard := _PatchedcertguardRHSMCertGuard{}

	if err = json.Unmarshal(bytes, &varPatchedcertguardRHSMCertGuard); err == nil {
		*o = PatchedcertguardRHSMCertGuard(varPatchedcertguardRHSMCertGuard)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "description")
		delete(additionalProperties, "ca_certificate")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchedcertguardRHSMCertGuard struct {
	value *PatchedcertguardRHSMCertGuard
	isSet bool
}

func (v NullablePatchedcertguardRHSMCertGuard) Get() *PatchedcertguardRHSMCertGuard {
	return v.value
}

func (v *NullablePatchedcertguardRHSMCertGuard) Set(val *PatchedcertguardRHSMCertGuard) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchedcertguardRHSMCertGuard) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchedcertguardRHSMCertGuard) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchedcertguardRHSMCertGuard(val *PatchedcertguardRHSMCertGuard) *NullablePatchedcertguardRHSMCertGuard {
	return &NullablePatchedcertguardRHSMCertGuard{value: val, isSet: true}
}

func (v NullablePatchedcertguardRHSMCertGuard) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchedcertguardRHSMCertGuard) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


