/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.tps.cert.TPSCertCollection;
import com.netscape.certsrv.tps.cert.TPSCertData;
import com.netscape.certsrv.tps.cert.TPSCertResource;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.usrgrp.User;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.dbs.TPSCertDatabase;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;
import org.dogtagpki.server.tps.dbs.TokenDatabase;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSCertService
extends PKIService
implements TPSCertResource {
    public static Logger logger = LoggerFactory.getLogger(TPSCertService.class);

    public TPSCertService() {
        logger.debug("TPSCertService.<init>()");
    }

    public TPSCertData createCertData(TPSCertRecord certRecord) {
        TPSCertData certData = new TPSCertData();
        certData.setID(certRecord.getId());
        certData.setSerialNumber(certRecord.getSerialNumber());
        certData.setSubject(certRecord.getSubject());
        certData.setUserID(certRecord.getUserID());
        certData.setTokenID(certRecord.getTokenID());
        certData.setOrigin(certRecord.getOrigin());
        certData.setType(certRecord.getType());
        certData.setKeyType(certRecord.getKeyType());
        certData.setStatus(certRecord.getStatus());
        certData.setCreateTime(certRecord.getCreateTime());
        certData.setModifyTime(certRecord.getModifyTime());
        String certID = certRecord.getId();
        try {
            certID = URLEncoder.encode(certID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
        return certData;
    }

    public TPSCertRecord createCertRecord(TPSCertData certData) {
        TPSCertRecord certRecord = new TPSCertRecord();
        certRecord.setId(certData.getID());
        certRecord.setSerialNumber(certData.getSerialNumber());
        certRecord.setSubject(certData.getSubject());
        certRecord.setUserID(certData.getUserID());
        certRecord.setTokenID(certData.getTokenID());
        certRecord.setOrigin(certData.getOrigin());
        certRecord.setType(certData.getType());
        certRecord.setKeyType(certData.getKeyType());
        certRecord.setStatus(certData.getStatus());
        certRecord.setCreateTime(certData.getCreateTime());
        certRecord.setModifyTime(certData.getModifyTime());
        return certRecord;
    }

    public Response findCerts(String filter, String tokenID, Integer start, Integer size) {
        String method = "TPSCertService:findCerts: ";
        String msg = "";
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        logger.debug("TPSCertService.findCerts(" + filter + ", " + tokenID + ", " + start + ", " + size + ")");
        if (tokenID == null) {
            if (filter == null || filter.length() < 3) {
                throw new BadRequestException("Filter is too short. Must be at least 3 characters.");
            }
            return this.findAllCerts(filter, start, size);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (tokenID != null) {
            attributes.put("tokenID", tokenID);
        }
        TPSEngine engine = TPSEngine.getInstance();
        try {
            int i;
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + msg);
                throw new PKIException(method + msg);
            }
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            TokenDatabase tokDatabase = subsystem.getTokenDatabase();
            TokenRecord record = (TokenRecord)tokDatabase.getRecord(tokenID);
            if (record == null) {
                msg = "Token record not found";
                logger.debug(method + msg);
                throw new PKIException(method + msg);
            }
            String type = record.getType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                throw new PKIException(method + "Token record restricted");
            }
            TPSCertDatabase database = subsystem.getCertDatabase();
            Iterator certRecs = database.findRecords(filter, attributes).iterator();
            TPSCertCollection response = new TPSCertCollection();
            for (i = 0; i < start && certRecs.hasNext(); ++i) {
                certRecs.next();
            }
            while (i < start + size && certRecs.hasNext()) {
                response.addEntry((Object)this.createCertData((TPSCertRecord)((Object)certRecs.next())));
                ++i;
            }
            while (certRecs.hasNext()) {
                certRecs.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    private Response findAllCerts(String filter, Integer start, Integer size) {
        String method = "TPSCertService:findAllCerts: ";
        String msg = "";
        TPSCertCollection response = new TPSCertCollection();
        logger.debug("TPSCertService.findAllCerts({}, {}, {})", new Object[]{filter, start, size});
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            TPSCertDatabase certDatabase = subsystem.getCertDatabase();
            Iterator certRecs = certDatabase.findRecords(filter).iterator();
            TokenDatabase tokenDatabase = subsystem.getTokenDatabase();
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug("{}{}", (Object)method, (Object)msg);
                throw new PKIException(method + msg);
            }
            int total = 0;
            while (certRecs.hasNext()) {
                String type;
                TPSCertRecord certRecord = (TPSCertRecord)((Object)certRecs.next());
                String tokenID = certRecord.getTokenID();
                TokenRecord tokenRecord = null;
                try {
                    tokenRecord = (TokenRecord)tokenDatabase.getRecord(tokenID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tokenRecord == null || (type = tokenRecord.getType()) != null && !type.isEmpty() && !authorizedProfiles.contains(type) && !authorizedProfiles.contains("All Profiles")) continue;
                if (total >= start && total < start + size) {
                    response.addEntry((Object)this.createCertData(certRecord));
                }
                ++total;
            }
            response.setTotal(total);
            return this.createOKResponse(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
    }

    public Response getCert(String certID) {
        String method = "TPSCertService:getCert: ";
        String msg = "";
        if (certID == null) {
            throw new BadRequestException("Certificate ID is null.");
        }
        logger.debug("TPSCertService.getCert(\"" + certID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + msg);
                throw new PKIException(method + msg);
            }
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            TPSCertDatabase database = subsystem.getCertDatabase();
            TPSCertRecord certRec = (TPSCertRecord)database.getRecord(certID);
            String type = certRec.getKeyType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                throw new PKIException(method + "Cert record restricted");
            }
            return this.createOKResponse(this.createCertData((TPSCertRecord)database.getRecord(certID)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
    }

    List<String> getAuthorizedProfiles() throws Exception {
        String method = "TokenService.getAuthorizedProfiles: ";
        PKIPrincipal pkiPrincipal = (PKIPrincipal)this.servletRequest.getUserPrincipal();
        User user = pkiPrincipal.getUser();
        return user.getTpsProfiles();
    }
}

