/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.group;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.group.GroupCollection;
import com.netscape.certsrv.group.GroupData;
import com.netscape.certsrv.group.GroupMemberCollection;
import com.netscape.certsrv.group.GroupMemberData;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class GroupClient
extends Client {
    public GroupClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "admin/groups");
    }

    public GroupClient(SubsystemClient subsystemClient) throws Exception {
        this(subsystemClient.client, subsystemClient.getName());
    }

    public GroupCollection findGroups(String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, GroupCollection.class);
    }

    public GroupData getGroup(String groupID) throws Exception {
        return this.get(groupID, GroupData.class);
    }

    public GroupData addGroup(GroupData groupData) throws Exception {
        Entity<GroupData> entity = this.client.entity(groupData);
        return this.post(null, null, entity, GroupData.class);
    }

    public GroupData modifyGroup(String groupID, GroupData groupData) throws Exception {
        Entity<GroupData> entity = this.client.entity(groupData);
        return this.patch(groupID, null, entity, GroupData.class);
    }

    public void removeGroup(String groupID) throws Exception {
        this.delete(groupID, Void.class);
    }

    public GroupMemberCollection findGroupMembers(String groupID, String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(groupID + "/members", params, GroupMemberCollection.class);
    }

    public GroupMemberData getGroupMember(String groupID, String memberID) throws Exception {
        return this.get(groupID + "/members/" + memberID, GroupMemberData.class);
    }

    public GroupMemberData addGroupMember(String groupID, String memberID) throws Exception {
        GroupMemberData data = new GroupMemberData();
        data.setID(memberID);
        Entity<GroupMemberData> entity = this.client.entity(data);
        return this.post(groupID + "/members", null, entity, GroupMemberData.class);
    }

    public void removeGroupMember(String groupID, String memberID) throws Exception {
        this.delete(groupID + "/members/" + memberID, Void.class);
    }
}

