/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.tps.authenticator;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.tps.authenticator.AuthenticatorCollection;
import com.netscape.certsrv.tps.authenticator.AuthenticatorData;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class AuthenticatorClient
extends Client {
    public AuthenticatorClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "authenticators");
    }

    public AuthenticatorCollection findAuthenticators(String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, AuthenticatorCollection.class);
    }

    public AuthenticatorData getAuthenticator(String authenticatorID) throws Exception {
        return this.get(authenticatorID, AuthenticatorData.class);
    }

    public AuthenticatorData addAuthenticator(AuthenticatorData authenticatorData) throws Exception {
        Entity<AuthenticatorData> entity = this.client.entity(authenticatorData);
        return this.post(null, null, entity, AuthenticatorData.class);
    }

    public AuthenticatorData updateAuthenticator(String authenticatorID, AuthenticatorData authenticatorData) throws Exception {
        Entity<AuthenticatorData> entity = this.client.entity(authenticatorData);
        return this.patch(authenticatorID, null, entity, AuthenticatorData.class);
    }

    public AuthenticatorData changeAuthenticatorStatus(String authenticatorID, String action) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (action != null) {
            params.put("action", action);
        }
        return this.post(authenticatorID, params, null, AuthenticatorData.class);
    }

    public void removeAuthenticator(String authenticatorID) throws Exception {
        this.delete(authenticatorID, Void.class);
    }
}

