/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tks.servlet;

import com.netscape.certsrv.base.EBaseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import org.dogtagpki.server.tks.servlet.KDF;
import org.dogtagpki.server.tks.servlet.SecureChannelProtocol;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NistSP800_108KDF
extends KDF {
    public static Logger logger = LoggerFactory.getLogger(NistSP800_108KDF.class);
    static final int KDF_OUTPUT_SIZE_BITS = 384;
    static final int KDF_OUTPUT_SIZE_BYTES = 48;
    static final int KEY_DATA_SIZE_BYTES = 16;
    static final int KDD_SIZE_BYTES = 10;
    static final byte KDF_LABEL = 4;
    public static final int SHA256_LENGTH = 32;
    private static final int AES_CMAC_BLOCK_SIZE = 16;
    private static final byte AES_CMAC_CONSTANT = -121;
    public static final byte ENC_KDF_CONSTANT = 4;
    public static final byte MAC_KDF_CONSTANT = 6;
    public static final byte RMAC_KDF_CONSTANT = 7;
    public static final byte CARD_CRYPTO_KDF_CONSTANT = 0;
    public static final byte HOST_CRYPTO_KDF_CONSTANT = 1;
    static final int OFFSET_CHIP_BATCH = 4;
    static final int LENGTH_CHIP_BATCH = 2;
    static final int OFFSET_CHIP_SERIAL = 6;
    static final int LENGTH_CHIP_SERIAL = 4;
    SecureChannelProtocol protocol = null;

    NistSP800_108KDF(SecureChannelProtocol protocol) {
        this.protocol = protocol;
    }

    public static boolean useThisKDF(byte nistSP800_108KDFonKeyVersion, byte requestedKeyVersion) {
        return (requestedKeyVersion & 0xFF) >= (nistSP800_108KDFonKeyVersion & 0xFF);
    }

    public Map<String, SymmetricKey> computeCardKeys(SymmetricKey masterKey, byte[] context, CryptoToken token) throws EBaseException {
        String method = "NistSP800_108KDF.computeCardKeys:";
        if (masterKey == null || context == null || token == null) {
            throw new EBaseException(method + " Invalid input parameters!");
        }
        HashMap<String, SymmetricKey> keys = new HashMap<String, SymmetricKey>();
        byte[] kdf_output = null;
        kdf_output = this.kdf_CM_SHA256_HMAC_L384(masterKey, context, (byte)4, 48, token);
        byte[] enc = new byte[16];
        byte[] mac = new byte[16];
        byte[] kek = new byte[16];
        System.arraycopy(kdf_output, 0, enc, 0, 16);
        System.arraycopy(kdf_output, 16, mac, 0, 16);
        System.arraycopy(kdf_output, 32, kek, 0, 16);
        byte[] encFinal = KDF.getDesParity(enc);
        byte[] macFinal = KDF.getDesParity(mac);
        byte[] kekFinal = KDF.getDesParity(kek);
        boolean showKeysOnlyForDebug = false;
        if (showKeysOnlyForDebug) {
            SecureChannelProtocol.debugByteArray(kdf_output, "kdf_CM_SHA256_HMAC_L384 output: ");
            SecureChannelProtocol.debugByteArray(mac, " Nist mac before parity: ");
            SecureChannelProtocol.debugByteArray(enc, " Nist enc before parity: ");
            SecureChannelProtocol.debugByteArray(kek, " Nist kek before parityl: ");
            SecureChannelProtocol.debugByteArray(macFinal, " Nist macFinal: ");
            SecureChannelProtocol.debugByteArray(encFinal, " Nist encFinal: ");
            SecureChannelProtocol.debugByteArray(kekFinal, " Nist kekFinal: ");
        }
        Arrays.fill(enc, (byte)0);
        Arrays.fill(mac, (byte)0);
        Arrays.fill(kek, (byte)0);
        Arrays.fill(kdf_output, (byte)0);
        SymmetricKey macKey = this.protocol.unwrapSymKeyOnToken(token, null, macFinal, false, SymmetricKey.DES3);
        SymmetricKey encKey = this.protocol.unwrapSymKeyOnToken(token, null, encFinal, false, SymmetricKey.DES3);
        SymmetricKey kekKey = this.protocol.unwrapSymKeyOnToken(token, null, kekFinal, false, SymmetricKey.DES3);
        Arrays.fill(encFinal, (byte)0);
        Arrays.fill(macFinal, (byte)0);
        Arrays.fill(kekFinal, (byte)0);
        keys.put("mac", macKey);
        keys.put("enc", encKey);
        keys.put("kek", kekKey);
        return keys;
    }

    public byte[] kdf_AES_CMAC_SCP03(SymmetricKey masterKey, byte[] context, byte kdfConstant, int kdfOutputSizeBytes) throws EBaseException {
        String method = "NistSP800_108KDF.kdf_AES_CMAC_SCP03:";
        byte[] label = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (masterKey == null || context == null || kdfOutputSizeBytes <= 0) {
            throw new EBaseException(method + " Invalid input!");
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        int outputBits = kdfOutputSizeBytes * 8;
        int h = 128;
        int remainder = outputBits % 128;
        int n = 0;
        n = remainder == 0 ? outputBits / 128 : outputBits / 128 + 1;
        byte b1 = (byte)(outputBits >> 8 & 0xFF);
        byte b2 = (byte)(outputBits & 0xFF);
        byte[] outputBitsBinary = new byte[]{b1, b2};
        try {
            data.write(label);
            data.write(kdfConstant);
            data.write(0);
            data.write(outputBitsBinary);
        }
        catch (IOException e) {
            throw new EBaseException(method + "Unable to calculate kdf!");
        }
        byte[] headerBytes = data.toByteArray();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream input = new ByteArrayOutputStream();
        byte[] kI = null;
        for (int i = 1; i <= n; ++i) {
            try {
                input.write(headerBytes);
                input.write((byte)i);
                input.write(context);
                kI = NistSP800_108KDF.computeAES_CMAC(masterKey, input.toByteArray());
                output.write(kI);
                continue;
            }
            catch (IOException e) {
                throw new EBaseException(method + "Unable to calculate kdf!");
            }
        }
        return output.toByteArray();
    }

    public SymmetricKey diversifyAESKey(SymmetricKey staticKey, byte[] tokenCUID, byte derivationConstant, CryptoToken token) throws EBaseException {
        String method = "NistSP800_108KDF.diversifyAESKey: ";
        if (staticKey == null || staticKey.getType() != SymmetricKey.Type.AES || tokenCUID == null || tokenCUID.length < 10) {
            throw new EBaseException(method + "Invalid input.");
        }
        byte[] context = new byte[8];
        context[0] = 0;
        context[1] = 0;
        System.arraycopy(tokenCUID, 6, context, 2, 4);
        System.arraycopy(tokenCUID, 4, context, 6, 2);
        int iterations = staticKey.getLength() / 16;
        if (staticKey.getLength() % 16 != 0) {
            ++iterations;
        }
        ByteArrayOutputStream cmacOutput = new ByteArrayOutputStream(16 * iterations);
        for (int i = 0; i < iterations; ++i) {
            byte[] cmacInput = new byte[16];
            cmacInput[0] = (byte)(i + 1);
            cmacInput[1] = 0;
            cmacInput[2] = 0;
            cmacInput[3] = 0;
            cmacInput[4] = derivationConstant;
            cmacInput[5] = 0;
            System.arraycopy(context, 0, cmacInput, 6, context.length);
            cmacInput[14] = (byte)(staticKey.getLength() * 8 >> 8);
            cmacInput[15] = (byte)(staticKey.getLength() * 8 & 0xFF);
            try {
                cmacOutput.write(NistSP800_108KDF.computeAES_CMAC(staticKey, cmacInput));
                continue;
            }
            catch (IOException e) {
                throw new EBaseException(method + "Error computing CMAC output.");
            }
        }
        return this.protocol.unwrapAESSymKeyOnToken(token, cmacOutput.toByteArray(), false);
    }

    private byte[] kdf_CM_SHA256_HMAC_L384(SymmetricKey masterKey, byte[] context, byte kdfLabel, int kdfOutputSizeBytes, CryptoToken token) throws EBaseException {
        String method = "NistSP800_108KDF.kdf_CM_SHA256_HMAC_L384:";
        logger.debug(method + " entering..");
        int n = 2;
        int L_BYTE_array_length = 2;
        if (context == null) {
            // empty if block
        }
        if (kdfOutputSizeBytes < 48) {
            throw new EBaseException(method + " Array \"output\" must be at least 48 bytes in size.");
        }
        int HMAC_DATA_INPUT_SIZE = context.length + 3 + L_BYTE_array_length;
        if (HMAC_DATA_INPUT_SIZE < context.length) {
            throw new EBaseException(method + " Input parameter context size is too large.");
        }
        byte[] L_BYTE_array = new byte[L_BYTE_array_length];
        L_BYTE_array[0] = 1;
        L_BYTE_array[1] = -128;
        byte[] hmac_data_input = new byte[HMAC_DATA_INPUT_SIZE];
        byte[] K = new byte[64];
        hmac_data_input[1] = kdfLabel;
        hmac_data_input[2] = 0;
        System.arraycopy(context, 0, hmac_data_input, 3, context.length);
        System.arraycopy(L_BYTE_array, 0, hmac_data_input, context.length + 3, 2);
        byte[] outputHMAC256 = null;
        for (int i = 1; i <= 2; i = (int)((byte)(i + 1))) {
            hmac_data_input[0] = i;
            outputHMAC256 = this.sha256HMAC(masterKey, hmac_data_input, HMAC_DATA_INPUT_SIZE, token);
            logger.debug(method + "outputHMAC256 len: " + outputHMAC256.length);
            System.arraycopy(outputHMAC256, 0, K, (i - 1) * 32, 32);
            Arrays.fill(outputHMAC256, (byte)0);
        }
        logger.debug(method + " Full array: " + K.length + " bytes...");
        byte[] finalOutput = new byte[48];
        System.arraycopy(K, 0, finalOutput, 0, 48);
        Arrays.fill(K, (byte)0);
        logger.debug(method + " finalOutput: " + finalOutput.length + " bytes...");
        return finalOutput;
    }

    private byte[] sha256HMAC(SymmetricKey masterKey, byte[] hmac_data_input, int hMAC_DATA_INPUT_SIZE, CryptoToken token) throws EBaseException {
        String method = "NistSP800_108KDF.sha256HMAC:";
        logger.debug(method + " Entering...");
        byte[] digestBytes = null;
        if (token == null) {
            method = " Invalid Crypto Token input!";
            throw new EBaseException(" Invalid Crypto Token input!");
        }
        try {
            JSSMessageDigest digest = token.getDigestContext((DigestAlgorithm)HMACAlgorithm.SHA256);
            digest.initHMAC(masterKey);
            digestBytes = digest.digest(hmac_data_input);
        }
        catch (Exception e) {
            logger.error(method + " Failure to HMAC the input data: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + e);
        }
        return digestBytes;
    }

    public static byte[] computeAES_CMAC(SymmetricKey aesKey, byte[] input) throws EBaseException {
        String method = "NistSP800_108KDF.computeAES_CMAC:";
        byte[] iv = null;
        if (aesKey == null || input == null) {
            throw new EBaseException(method + " invalid input data!");
        }
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, input.length);
        String alg = aesKey.getAlgorithm();
        System.out.println(" AES ALG: " + alg);
        EncryptionAlgorithm eAlg = EncryptionAlgorithm.AES_128_CBC;
        int ivLength = eAlg.getIVLength();
        if (ivLength > 0) {
            iv = new byte[ivLength];
        }
        if (!"AES".equals(alg)) {
            throw new EBaseException(method + " invalid in put key type , must be AES!");
        }
        byte[] k0 = new byte[16];
        CryptoToken token = aesKey.getOwningToken();
        Cipher encryptor = null;
        try {
            encryptor = token.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
            encryptor.initEncrypt(aesKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            k0 = encryptor.doFinal(k0);
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | TokenException e) {
            throw new EBaseException((Exception)e);
        }
        byte[] k1 = NistSP800_108KDF.getAES_CMAC_SubKey(k0);
        byte[] k2 = NistSP800_108KDF.getAES_CMAC_SubKey(k1);
        int numBlocks = 0;
        int messageSize = data.length;
        boolean perfectBlocks = false;
        if (messageSize % 16 == 0 && messageSize != 0) {
            numBlocks = messageSize / 16;
            perfectBlocks = true;
        } else {
            numBlocks = messageSize / 16 + 1;
            perfectBlocks = false;
        }
        int index = 0;
        byte inb = 0;
        byte[] finalData = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (perfectBlocks) {
            for (int j = 0; j < k1.length; ++j) {
                index = messageSize - 16 + j;
                inb = data[index];
                data[index] = (byte)(inb ^ k1[j]);
            }
            try {
                outputStream.write(data);
            }
            catch (IOException e) {
                throw new EBaseException(method + " internal buffer erro!");
            }
            finalData = outputStream.toByteArray();
        } else {
            byte[] padding = new byte[16 - messageSize % 16];
            padding[0] = -128;
            try {
                outputStream.write(data);
                outputStream.write(padding);
            }
            catch (IOException e) {
                throw new EBaseException(method + " internal buffer error!");
            }
            finalData = outputStream.toByteArray();
            messageSize = finalData.length;
            for (int j = 0; j < k2.length; ++j) {
                index = messageSize - 16 + j;
                inb = finalData[index];
                finalData[index] = (byte)(inb ^ k2[j]);
            }
        }
        byte[] encData = new byte[16];
        byte[] currentBlock = new byte[16];
        for (int i = 0; i < numBlocks; ++i) {
            try {
                encryptor.initEncrypt(aesKey, (AlgorithmParameterSpec)new IVParameterSpec(encData));
                System.arraycopy(finalData, i * 16, currentBlock, 0, 16);
                encData = encryptor.doFinal(currentBlock);
                continue;
            }
            catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | TokenException e) {
                throw new EBaseException((Exception)e);
            }
        }
        return encData;
    }

    private static byte[] getAES_CMAC_SubKey(byte[] input) {
        byte[] output = new byte[input.length];
        boolean msbSet = (input[0] & 0x80) != 0;
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)(input[i] << 1);
            if (i + 1 >= input.length || (input[i + 1] & 0x80) == 0) continue;
            int n = i;
            output[n] = (byte)(output[n] | 1);
        }
        if (msbSet) {
            int n = output.length - 1;
            output[n] = (byte)(output[n] ^ 0xFFFFFF87);
        }
        return output;
    }

    public static void main(String[] args) {
    }
}

