/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.CMSRequestInfo;
import com.netscape.certsrv.request.CMSRequestInfos;
import com.netscape.certsrv.request.IRequestVirtualList;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSRequestDAO {
    public static Logger logger = LoggerFactory.getLogger(CMSRequestDAO.class);
    protected RequestRepository requestRepository;
    protected RequestQueue queue;
    private String[] vlvFilters = new String[]{"(requeststate=*)", "(requesttype=enrollment)", "(requesttype=recovery)", "(requeststate=canceled)", "(&(requeststate=canceled)(requesttype=enrollment))", "(&(requeststate=canceled)(requesttype=recovery))", "(requeststate=rejected)", "(&(requeststate=rejected)(requesttype=enrollment))", "(&(requeststate=rejected)(requesttype=recovery))", "(requeststate=complete)", "(&(requeststate=complete)(requesttype=enrollment))", "(&(requeststate=complete)(requesttype=recovery))"};
    public static final String ATTR_SERIALNO = "serialNumber";

    public CMSRequestInfos listCMSRequests(String filter, RequestId start, int pageSize, int maxResults, int maxTime, UriInfo uriInfo) throws EBaseException {
        logger.info("CMSRequestDAO: Searching for requests with filter " + filter);
        CMSRequestInfos ret = new CMSRequestInfos();
        int totalSize = 0;
        int current = 0;
        if (this.isVLVSearch(filter)) {
            logger.debug("CMSRequestDAO: performing VLV search");
            IRequestVirtualList vlvlist = this.requestRepository.getPagedRequestsByFilter(start, false, filter, pageSize + 1, "requestId");
            totalSize = vlvlist.getSize();
            logger.debug("CMSRequestDAO: total: " + totalSize);
            ret.setTotal(totalSize);
            current = vlvlist.getCurrentIndex();
            int numRecords = totalSize > current + pageSize ? pageSize : totalSize - current;
            logger.debug("CMSRequestDAO: records (" + numRecords + "):");
            for (int i = 0; i < numRecords; ++i) {
                Request request = vlvlist.getElementAt(i);
                logger.debug("- " + request.getRequestId().toHexString());
                ret.addEntry((Object)this.createCMSRequestInfo(request, uriInfo));
            }
        } else {
            logger.debug("CMSRequestDAO: performing non-VLV search");
            RequestList requests = this.requestRepository.listRequestsByFilter(filter, maxResults, maxTime);
            if (requests == null) {
                return ret;
            }
            logger.debug("CMSRequestDAO: records:");
            while (requests.hasMoreElements()) {
                RequestId rid = requests.nextElement();
                Request request = this.requestRepository.readRequest(rid);
                if (request == null) continue;
                logger.debug("- " + request.getRequestId().toHexString());
                ret.addEntry((Object)this.createCMSRequestInfo(request, uriInfo));
            }
            ret.setTotal(ret.getEntries().size());
        }
        MultivaluedMap params = uriInfo.getQueryParameters();
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        if (params.containsKey((Object)"requestState")) {
            builder.queryParam("requestState", new Object[]{params.getFirst((Object)"requestState")});
        }
        if (params.containsKey((Object)"requestType")) {
            builder.queryParam("requestType", new Object[]{params.getFirst((Object)"requestType")});
        }
        if (params.containsKey((Object)"realm")) {
            builder.queryParam("realm", new Object[]{params.getFirst((Object)"realm")});
        }
        builder.queryParam("start", new Object[]{"{start}"});
        builder.queryParam("pageSize", new Object[]{"{pageSize}"});
        return ret;
    }

    private boolean isVLVSearch(String filter) {
        for (int i = 0; i < this.vlvFilters.length; ++i) {
            if (!this.vlvFilters[i].equalsIgnoreCase(filter)) continue;
            return true;
        }
        return false;
    }

    protected abstract CMSRequestInfo createCMSRequestInfo(Request var1, UriInfo var2);
}

