/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.connector.HttpConnection;
import com.netscape.cmscore.connector.HttpPKIMessage;
import com.netscape.cmscore.connector.RemoteAuthority;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmsutil.http.JssSSLSocketFactory;
import com.netscape.cmsutil.net.ISocketFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resender
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(Resender.class);
    public static final int MINUTE = 60;
    protected CMSEngine engine;
    protected RequestRepository requestRepository;
    RequestQueue mQueue;
    protected RemoteAuthority mDest;
    ScheduledExecutorService executorService;
    protected Vector<String> mRequestIds = new Vector();
    protected HttpConnection mConn = null;
    protected String mNickName = null;
    protected String mClientCiphers = null;
    protected boolean connected = false;
    protected int mInterval = 60;

    public Resender(String nickName, String clientCiphers, RemoteAuthority dest) {
        this.mDest = dest;
        this.mNickName = nickName;
        this.mClientCiphers = clientCiphers;
    }

    public Resender(String nickName, String clientCiphers, RemoteAuthority dest, int interval) {
        this.mDest = dest;
        this.mNickName = nickName;
        this.mClientCiphers = clientCiphers;
        if (interval > 0) {
            this.mInterval = interval;
        }
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init() {
        this.requestRepository = this.engine.getRequestRepository();
        this.mQueue = this.engine.getRequestQueue();
    }

    private void initRequests() {
        RequestList list = this.mQueue.listRequestsByStatus(RequestStatus.SVC_PENDING);
        while (list != null && list.hasMoreElements()) {
            RequestId rid = list.nextRequestId();
            logger.debug("added request Id " + rid + " in init to resend queue.");
            this.mRequestIds.addElement(rid.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(Request r) {
        Vector<String> vector = this.mRequestIds;
        synchronized (vector) {
            this.mRequestIds.addElement(r.getRequestId().toString());
        }
        logger.debug("added " + r.getRequestId() + " to resend queue");
    }

    public void start(final String name) {
        logger.debug("Starting resender thread with interval " + this.mInterval);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, name);
            }
        });
        this.executorService.scheduleWithFixedDelay(this, 0L, this.mInterval, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.engine.isInRunningState()) {
            return;
        }
        if (!this.connected) {
            logger.debug("Connecting ...");
            JssSSLSocketFactory factory = new JssSSLSocketFactory(this.mNickName, this.mClientCiphers);
            factory.addSocketListener((SSLSocketListener)this.engine.getClientSocketListener());
            this.mConn = new HttpConnection(this.mDest, (ISocketFactory)factory);
            this.mConn.setCMSEngine(this.engine);
            this.mConn.init();
            this.initRequests();
            this.connected = true;
        }
        this.resend();
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resend() {
        Vector rids = (Vector)this.mRequestIds.clone();
        Vector<RequestId> completedRids = new Vector<RequestId>();
        Enumeration enum1 = rids.elements();
        while (enum1.hasMoreElements()) {
            String ridString = (String)enum1.nextElement();
            RequestId rid = new RequestId(ridString);
            Request r = null;
            logger.debug("resend processing request id " + rid);
            try {
                r = this.requestRepository.readRequest(rid);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage("CMSCORE_CONNECTOR_REQUEST_NOT_FOUND", rid.toString()), (Throwable)e);
                continue;
            }
            try {
                if (r.getRequestStatus() != RequestStatus.SVC_PENDING) {
                    completedRids.addElement(rid);
                    logger.debug("request id " + rid + " no longer service pending");
                    continue;
                }
                boolean completed = this.send(r);
                if (!completed) continue;
                completedRids.addElement(rid);
                logger.info(CMS.getLogMessage("CMSCORE_CONNECTOR_REQUEST_COMPLETED", rid.toString()));
            }
            catch (IOException e) {
                logger.warn(CMS.getLogMessage("CMSCORE_CONNECTOR_REQUEST_ERROR", rid.toString(), e.toString()), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage("CMSCORE_CONNECTOR_DOWN", new Object[0]), (Throwable)e);
                if (e.toString().indexOf("connection not available") < 0) continue;
                break;
            }
        }
        Enumeration en = completedRids.elements();
        Vector<String> vector = this.mRequestIds;
        synchronized (vector) {
            while (en.hasMoreElements()) {
                RequestId id = (RequestId)en.nextElement();
                logger.debug("Connector: Removed request " + id + " from re-send queue");
                this.mRequestIds.removeElement(id.toString());
                logger.debug("Connector: mRequestIds now has " + this.mRequestIds.size() + " elements.");
            }
        }
    }

    private boolean send(Request r) throws IOException, EBaseException {
        try {
            HttpPKIMessage tomsg = new HttpPKIMessage();
            HttpPKIMessage replymsg = null;
            tomsg.fromRequest(r);
            replymsg = (HttpPKIMessage)this.mConn.send(tomsg);
            if (replymsg == null) {
                return false;
            }
            logger.debug(r.getRequestId() + " resent to CA");
            RequestStatus replyStatus = RequestStatus.valueOf((String)replymsg.reqStatus);
            int index = replymsg.reqId.lastIndexOf(58);
            RequestId replyRequestId = new RequestId(replymsg.reqId.substring(index + 1));
            logger.debug("reply request id " + replyRequestId + " for request " + r.getRequestId());
            if (replyStatus != RequestStatus.COMPLETE) {
                logger.debug("resend " + r.getRequestId() + " still not completed.");
                return false;
            }
            replymsg.toRequest(r);
            logger.debug("resend request id was completed " + r.getRequestId());
            this.mQueue.markAsServiced(r);
            this.mQueue.releaseRequest(r);
            logger.debug("resend released request " + r.getRequestId());
            return true;
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage("CMSCORE_CONNECTOR_RESEND_ERROR", r.getRequestId().toString(), e.toString()), (Throwable)e);
            if (e.toString().indexOf("Connection refused by peer") > 0) {
                throw new EBaseException("connection not available");
            }
            return false;
        }
    }
}

