/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.jobs.EJobsException;
import com.netscape.certsrv.jobs.JobPlugin;
import com.netscape.cms.jobs.Job;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.jobs.CronRange;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobCron;
import com.netscape.cmscore.jobs.JobPluginsConfig;
import com.netscape.cmscore.jobs.JobsConfig;
import com.netscape.cmscore.jobs.JobsSchedulerConfig;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsScheduler
extends Subsystem
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(JobsScheduler.class);
    public static final String ID = "jobsScheduler";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_INTERVAL = "interval";
    public static final String PROP_CLASS = "class";
    public static final String PROP_JOB = "job";
    public static final String PROP_IMPL = "impl";
    public static final String PROP_PLUGIN = "pluginName";
    protected static final long MINUTE_MILLI = 60000L;
    protected static final String DELIM = ",";
    protected String mId = "jobsScheduler";
    protected Thread mScheduleThread = null;
    public Hashtable<String, JobPlugin> mJobPlugins = new Hashtable();
    public Hashtable<String, Job> mJobs = new Hashtable();
    private Hashtable<String, Thread> mJobThreads = new Hashtable();
    private JobsSchedulerConfig mConfig;
    private long mInterval = 0L;

    public void init(JobsSchedulerConfig config) throws Exception {
        int i;
        logger.info("JobsScheduler: Initializing scheduler");
        this.mConfig = config;
        try {
            i = this.mConfig.getInteger(PROP_INTERVAL);
        }
        catch (Exception e) {
            i = 1;
        }
        logger.info("JobsScheduler: - interval: " + i);
        this.setInterval(i);
        JobPluginsConfig pluginsConfig = this.mConfig.getJobPluginsConfig();
        Enumeration<String> mImpls = pluginsConfig.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String id = mImpls.nextElement();
            String pluginPath = pluginsConfig.getString(id + ".class");
            JobPlugin plugin = new JobPlugin(id, pluginPath);
            this.mJobPlugins.put(id, plugin);
        }
        logger.info("JobsScheduler: Jobs: ");
        JobsConfig c = config.getJobsConfig();
        Enumeration<String> jobs = c.getSubStoreNames().elements();
        while (jobs.hasMoreElements()) {
            String jobName = jobs.nextElement();
            logger.info("JobsScheduler: - " + jobName);
            JobConfig jobConfig = c.getJobConfig(jobName);
            String implName = jobConfig.getPluginName();
            JobPlugin plugin = this.mJobPlugins.get(implName);
            if (plugin == null) {
                logger.error(CMS.getLogMessage("CMSCORE_JOBS_CLASS_NOT_FOUND", implName));
                throw new EJobsException(CMS.getUserMessage("CMS_JOB_PLUGIN_NOT_FOUND", implName));
            }
            String classPath = plugin.getClassPath();
            try {
                Job job = (Job)Class.forName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                job.setCMSEngine(this.engine);
                job.init(this, jobName, implName, jobConfig);
                this.mJobs.put(jobName, job);
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage("CMSCORE_JOBS_INIT_ERROR", e.toString()), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("CMSCORE_JOBS_INIT_ERROR", e.toString()), (Throwable)e);
                throw new EJobsException(CMS.getUserMessage("CMS_JOB_LOAD_CLASS_FAILED", classPath), e);
            }
        }
        if (this.mConfig.getBoolean(PROP_ENABLED, false)) {
            this.startDaemon();
        }
    }

    public Hashtable<String, JobPlugin> getPlugins() {
        return this.mJobPlugins;
    }

    public Hashtable<String, Job> getInstances() {
        return this.mJobs;
    }

    public Job getJob(String id) {
        return this.mJobs.get(id);
    }

    @Override
    public void run() {
        long wokeupTime = 0L;
        block6: while (true) {
            long duration;
            Calendar cal = Calendar.getInstance();
            long rightNow = cal.getTime().getTime();
            long second = cal.get(13);
            if (second != 1L) {
                long milliSec = cal.get(14);
                duration = (60L - second) * 1000L + 1000L - milliSec;
                logger.info("JobsScheduler: adjustment for cron behavior: sleep for " + duration + " milliseconds");
            } else {
                duration = this.mInterval - rightNow + wokeupTime;
            }
            while (duration < 0L) {
                duration += this.mInterval;
            }
            if (duration != 0L) {
                try {
                    Thread.sleep(duration);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
            try {
                if (!this.mConfig.getBoolean(PROP_ENABLED, false)) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            cal = Calendar.getInstance();
            wokeupTime = cal.getTime().getTime();
            Enumeration<Job> e = this.mJobs.elements();
            while (true) {
                if (!e.hasMoreElements()) continue block6;
                Job job = e.nextElement();
                try {
                    if (!job.isEnabled()) {
                    }
                }
                catch (Exception ex) {}
                continue;
                if (!this.isShowTime(job, cal)) continue;
                this.startJob(job.getId());
            }
            break;
        }
    }

    public synchronized void startJob(String id) {
        Thread thread = this.mJobThreads.get(id);
        if (thread != null && thread.isAlive()) {
            logger.info("JobsScheduler: Job " + id + " still running");
            return;
        }
        logger.info("JobsScheduler: Starting job " + id);
        Job job = this.mJobs.get(id);
        thread = new Thread((Runnable)job, id);
        this.mJobThreads.put(id, thread);
        thread.start();
    }

    public JobCron createJobCron(String cs) throws EBaseException {
        return new JobCron(cs);
    }

    protected boolean isShowTime(Job job, Calendar now) {
        int cronDow;
        JobCron jcron = job.getJobCron();
        logger.info("JobsScheduler: jobcron: " + jcron);
        if (jcron == null) {
            return false;
        }
        Vector<CronRange> moy = jcron.getItem("moy").getElements();
        int cronMoy = jcron.MOY_cal2cron(now);
        if (!jcron.isElement(cronMoy, moy)) {
            return false;
        }
        Vector<CronRange> dow = jcron.getItem("dow").getElements();
        Vector<CronRange> dom = jcron.getItem("dom").getElements();
        if (!dow.isEmpty() || dom.isEmpty()) {
            // empty if block
        }
        if (!jcron.isElement(cronDow = jcron.DOW_cal2cron(now), dow) && !jcron.isElement(now.get(5), dom)) {
            return false;
        }
        Vector<CronRange> hour = jcron.getItem("hour").getElements();
        if (!jcron.isElement(now.get(11), hour)) {
            return false;
        }
        Vector<CronRange> minute = jcron.getItem("minute").getElements();
        return jcron.isElement(now.get(12), minute);
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public void startDaemon() {
        this.mScheduleThread = new Thread((Runnable)this, "JobScheduler");
        logger.info("JobsScheduler: started Jobs Scheduler daemon thread");
        this.mScheduleThread.setDaemon(true);
        this.mScheduleThread.start();
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public void shutdown() {
        for (Job job : this.mJobs.values()) {
            job.stop();
        }
    }

    @Override
    public JobsSchedulerConfig getConfigStore() {
        return this.mConfig;
    }

    public String[] getConfigParams(String implName) throws EJobsException {
        logger.trace("JobsScheduler: in getCofigParams()");
        JobPlugin plugin = this.mJobPlugins.get(implName);
        if (plugin == null) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_CLASS_NOT_FOUND", implName));
            logger.error("JobsScheduler: Job plugin " + implName + " not found.");
            throw new EJobsException(CMS.getUserMessage("CMS_JOB_PLUGIN_NOT_FOUND", implName));
        }
        String className = plugin.getClassPath();
        logger.trace("JobsScheduler: className = " + className);
        try {
            Job jobInst = (Job)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            logger.trace("JobsScheduler: class instantiated");
            return jobInst.getConfigParams();
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("CMSCORE_JOBS_CREATE_NEW", e.toString()));
            logger.error("JobsScheduler: class NOT instantiated: " + e.getMessage(), (Throwable)e);
            throw new EJobsException(CMS.getUserMessage("CMS_JOB_LOAD_CLASS_FAILED", className), e);
        }
    }

    public void setInterval(int minutes) {
        this.mInterval = (long)minutes * 60000L;
    }

    public void log(int level, String msg) {
    }

    public Hashtable<String, JobPlugin> getJobPlugins() {
        return this.mJobPlugins;
    }
}

