/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.publishers.LdapUserCertPublisher;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCaCertPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapCaCertPublisher.class);
    public static final String LDAP_CACERT_ATTR = "caCertificate;binary";
    public static final String LDAP_CA_OBJECTCLASS = "pkiCA";
    public static final String LDAP_ARL_ATTR = "authorityRevocationList;binary";
    public static final String LDAP_CRL_ATTR = "certificateRevocationList;binary";
    protected String mCaCertAttr = "caCertificate;binary";
    protected String mCaObjectclass = "pkiCA";
    protected String mObjAdded = "";
    protected String mObjDeleted = "";
    private boolean mInited = false;
    protected ConfigStore mConfig;

    public LdapCaCertPublisher() {
    }

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"caCertAttr;string;Name of Ldap attribute in which to store certificate", "caObjectClass;string;The name of the objectclasses which should be added to this entry, if they do not already exist. This can be 'certificationAuthority' (if using RFC 2256) or 'pkiCA' (if using RFC 4523)", "HELP_TOKEN;configuration-ldappublish-publisher-cacertpublisher", "HELP_TEXT;This plugin knows how to publish the CA cert to 'certificateAuthority' and 'pkiCA' -type entries"};
        return s;
    }

    public String getImplName() {
        return "LdapCaCertPublisher";
    }

    public String getDescription() {
        return "LdapCaCertPublisher";
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("caCertAttr=" + this.mCaCertAttr);
        v.addElement("caObjectClass=" + this.mCaObjectclass);
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("caCertAttr=" + this.mCaCertAttr);
        v.addElement("caObjectClass=" + this.mCaObjectclass);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mCaCertAttr = this.mConfig.getString("caCertAttr", LDAP_CACERT_ATTR);
        this.mCaObjectclass = this.mConfig.getString("caObjectClass", LDAP_CA_OBJECTCLASS);
        this.mObjAdded = this.mConfig.getString("caObjectClassAdded", "");
        this.mObjDeleted = this.mConfig.getString("caObjectClassDeleted", "");
        this.mInited = true;
    }

    public LdapCaCertPublisher(String caCertAttr, String caObjectclass) {
        this.mCaCertAttr = caCertAttr;
        this.mCaObjectclass = caObjectclass;
        this.mInited = true;
    }

    public String getCAObjectclass() {
        return this.mCaObjectclass;
    }

    public String getCaCertAttrName() {
        return this.mCaCertAttr;
    }

    public void publish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (conn == null) {
            logger.warn("LdapCaCertPublisher: no LDAP connection");
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        try {
            this.mCaCertAttr = this.mConfig.getString("caCertAttr", LDAP_CACERT_ATTR);
            this.mCaObjectclass = this.mConfig.getString("caObjectClass", LDAP_CA_OBJECTCLASS);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        LdapBoundConnection altConn = null;
        try {
            String host = this.mConfig.getString("host", null);
            String port = this.mConfig.getString("port", null);
            if (host != null && port != null) {
                int portVal = Integer.parseInt(port);
                int version = Integer.parseInt(this.mConfig.getString("version", "2"));
                String cert_nick = this.mConfig.getString("clientCertNickname", null);
                PKISocketFactory sslSocket = new PKISocketFactory();
                sslSocket.setAuditor(engine.getAuditor());
                sslSocket.addSocketListener((SSLSocketListener)engine.getClientSocketListener());
                sslSocket.setSecure(true);
                sslSocket.setClientCertNickname(cert_nick);
                sslSocket.init(socketConfig);
                String mgr_dn = this.mConfig.getString("bindDN", null);
                String mgr_pwd = this.mConfig.getString("bindPWD", null);
                altConn = new LdapBoundConnection(host, portVal, version, (LDAPSocketFactory)sslSocket, mgr_dn, mgr_pwd);
                conn = altConn;
            }
        }
        catch (LDAPException e) {
            logger.warn("LdapCaCertPublisher: Unable to create alt connection: " + e.getMessage(), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn("LdapCaCertPublisher: Unable to create alt connection: " + e.getMessage(), (Throwable)e);
        }
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        try {
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{LDAP_CRL_ATTR, LDAP_ARL_ATTR}, true);
            LDAPEntry entry = res.next();
            LDAPAttribute arls = entry.getAttribute(LDAP_ARL_ATTR);
            LDAPAttribute crls = entry.getAttribute(LDAP_CRL_ATTR);
            LDAPSearchResults res1 = conn.search(dn, 0, "(objectclass=*)", new String[]{"objectclass", this.mCaCertAttr}, false);
            LDAPEntry entry1 = res1.next();
            LDAPAttribute ocs = entry1.getAttribute("objectclass");
            LDAPAttribute certs = entry1.getAttribute(this.mCaCertAttr);
            boolean hasCert = LdapUserCertPublisher.ByteValueExists(certs, certEnc);
            LDAPModificationSet modSet = new LDAPModificationSet();
            if (hasCert) {
                logger.warn("publish: CA " + dn + " already has Cert");
            } else if (certs == null) {
                modSet.add(0, new LDAPAttribute(this.mCaCertAttr, certEnc));
                logger.info("LdapCaCertPublisher: CA cert added");
            } else {
                modSet.add(2, new LDAPAttribute(this.mCaCertAttr, certEnc));
                logger.info("LdapCaCertPublisher: CA cert replaced");
            }
            String[] oclist = this.mCaObjectclass.split(",");
            boolean attrsAdded = false;
            for (int i = 0; i < oclist.length; ++i) {
                String oc = oclist[i].trim();
                boolean hasoc = LdapUserCertPublisher.StringValueExists(ocs, oc);
                if (hasoc) continue;
                logger.info("LdapCaCertPublisher: Adding CA objectclass " + oc + " to " + dn);
                modSet.add(0, new LDAPAttribute("objectclass", oc));
                if (attrsAdded || !oc.equalsIgnoreCase("certificationAuthority")) continue;
                if (arls == null) {
                    modSet.add(0, new LDAPAttribute(LDAP_ARL_ATTR, ""));
                }
                if (crls == null) {
                    modSet.add(0, new LDAPAttribute(LDAP_CRL_ATTR, ""));
                }
                attrsAdded = true;
            }
            String[] delList = this.mObjDeleted.split(",");
            if (delList.length > 0) {
                for (int i = 0; i < delList.length; ++i) {
                    String deloc = delList[i].trim();
                    boolean hasoc = LdapUserCertPublisher.StringValueExists(ocs, deloc);
                    boolean match = false;
                    for (int j = 0; j < oclist.length; ++j) {
                        if (!oclist[j].trim().equals(deloc)) continue;
                        match = true;
                        break;
                    }
                    if (match || !hasoc) continue;
                    logger.info("LdapCaCertPublisher: Deleting CA objectclass " + deloc + " from " + dn);
                    modSet.add(1, new LDAPAttribute("objectclass", deloc));
                }
            }
            if (!this.mObjAdded.equals("") || !this.mObjDeleted.equals("")) {
                this.mObjAdded = "";
                this.mObjDeleted = "";
                this.mConfig.putString("caObjectClassAdded", "");
                this.mConfig.putString("caObjectClassDeleted", "");
                try {
                    this.mConfig.commit(false);
                }
                catch (Exception e) {
                    logger.warn("LdapCaCertPublisher: Failure in updating mObjAdded and mObjDeleted", (Throwable)e);
                }
            }
            if (modSet.size() > 0) {
                conn.modify(dn, modSet);
            }
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_CANT_DECODE_CERT", (Object[])new Object[]{dn}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISHER_EXCEPTION", (Object[])new Object[]{"", e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_CACERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        finally {
            if (altConn != null) {
                try {
                    altConn.disconnect();
                }
                catch (LDAPException lDAPException) {}
            }
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        try {
            this.mCaCertAttr = this.mConfig.getString("caCertAttr", LDAP_CACERT_ATTR);
            this.mCaObjectclass = this.mConfig.getString("caObjectClass", LDAP_CA_OBJECTCLASS);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCaCertAttr, "objectclass"}, false);
            LDAPEntry entry = res.next();
            LDAPAttribute certs = entry.getAttribute(this.mCaCertAttr);
            LDAPAttribute ocs = entry.getAttribute("objectclass");
            boolean hasCert = LdapUserCertPublisher.ByteValueExists(certs, certEnc);
            if (!hasCert) {
                logger.warn("unpublish: " + dn + " has not cert already");
                return;
            }
            LDAPModificationSet modSet = new LDAPModificationSet();
            modSet.add(1, new LDAPAttribute(this.mCaCertAttr, certEnc));
            if (certs.size() == 1) {
                String[] oclist = this.mCaObjectclass.split(",");
                for (int i = 0; i < oclist.length; ++i) {
                    String oc = oclist[i].trim();
                    boolean hasOC = LdapUserCertPublisher.StringValueExists(ocs, oc);
                    if (!hasOC) continue;
                    logger.info("unpublish: deleting CA oc" + oc + " from " + dn);
                    modSet.add(1, new LDAPAttribute("objectclass", oc));
                }
            }
            conn.modify(dn, modSet);
        }
        catch (CertificateEncodingException e) {
            logger.error("LdapCaCertPublisher: unpublish: Cannot decode cert for " + dn + ": " + e.getMessage(), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}));
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_CACERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }
}

