/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.publish.MapperProxy;
import com.netscape.certsrv.publish.PublisherProxy;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.LdapExpression;
import com.netscape.cmscore.ldap.LdapPredicateParser;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapRule
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapRule.class);
    public static final String PROP_PREDICATE = "predicate";
    public static final String PROP_ENABLE = "enable";
    public static final String PROP_IMPLNAME = "implName";
    public static final String PROP_MAPPER = "mapper";
    public static final String PROP_PUBLISHER = "publisher";
    public static final String PROP_TYPE = "type";
    public static final String NOMAPPER = "<NONE>";
    private ConfigStore mConfig;
    protected LdapExpression mFilterExp = null;
    private String mInstanceName = null;
    private static String[] epi_params = null;

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public String[] getExtendedPluginInfo() {
        logger.trace("LdapRule: getExtendedPluginInfo() - returning epi_params:");
        for (int i = 0; i < epi_params.length; ++i) {
            logger.trace("[" + i + "]  " + epi_params[i]);
        }
        return epi_params;
    }

    /*
     * WARNING - void declaration
     */
    public void init(Hashtable<String, MapperProxy> mappers, Hashtable<String, PublisherProxy> publishers, ConfigStore config) throws EBaseException {
        void var6_10;
        this.mConfig = config;
        StringBuffer map = new StringBuffer();
        map.append(NOMAPPER);
        for (String string : mappers.keySet()) {
            map.append("," + string);
        }
        StringBuffer publish = new StringBuffer();
        for (String name : publishers.keySet()) {
            publish.append("," + name);
        }
        epi_params = new String[]{"type;choice(cacert,crl, certs);The publishing object type", "mapper;choice(" + map.toString() + ");Use the mapper to find the ldap dn \nto publish the certificate or crl", "publisher;choice(" + publish.toString() + ");Use the publisher to publish the certificate or crl a directory etc", "enable;boolean;Enable this publishing rule", "predicate;string;Filter describing when this publishing rule shoule be used"};
        String string = config.getString(PROP_PREDICATE, null);
        logger.info("LdapRule: predicate: " + string);
        if (string != null) {
            String string2 = string.trim();
        }
        if (var6_10 != null && var6_10.length() > 0) {
            LdapExpression filterExp = LdapPredicateParser.parse((String)var6_10);
            this.setPredicate(filterExp);
        }
    }

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        epi_params = new String[]{"type;choice(cacert, crl, certs);The publishing object type", "mapper;choice(null,LdapUserCertMap,LdapServerCertMap,LdapCrlMap,LdapCaCertMap);Use the mapper to find the ldap dn to publish the certificate or crl", "publisher;choice(LdapUserCertPublisher,LdapServerCertPublisher,LdapCrlPublisher,LdapCaCertPublisher);Use the publisher to publish the certificate or crl a directory etc", "enable;boolean;", "predicate;string;"};
        String exp = config.getString(PROP_PREDICATE, null);
        logger.info("LdapRule: predicate: " + exp);
        if (exp != null) {
            exp = exp.trim();
        }
        if (exp != null && exp.length() > 0) {
            LdapExpression filterExp = LdapPredicateParser.parse(exp);
            this.setPredicate(filterExp);
        }
    }

    public String getImplName() {
        return "LdapRule";
    }

    public String getDescription() {
        return "LdapRule";
    }

    public void setInstanceName(String insName) {
        this.mInstanceName = insName;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        try {
            v.addElement("type=" + this.mConfig.getString(PROP_TYPE, ""));
            v.addElement("predicate=" + this.mConfig.getString(PROP_PREDICATE, ""));
            v.addElement("enable=" + this.mConfig.getString(PROP_ENABLE, ""));
            v.addElement("mapper=" + this.mConfig.getString(PROP_MAPPER, ""));
            v.addElement("publisher=" + this.mConfig.getString(PROP_PUBLISHER, ""));
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return v;
    }

    public void setPredicate(LdapExpression exp) {
        this.mFilterExp = exp;
    }

    public LdapExpression getPredicate() {
        return this.mFilterExp;
    }

    public String getMapper() {
        try {
            String map = this.mConfig.getString(PROP_MAPPER, "");
            if (map != null) {
                map = map.trim();
            }
            if (map == null || map.equals("")) {
                return null;
            }
            if (map.equals(NOMAPPER)) {
                return null;
            }
            return map;
        }
        catch (EBaseException eBaseException) {
            return null;
        }
    }

    public String getPublisher() {
        try {
            return this.mConfig.getString(PROP_PUBLISHER, "");
        }
        catch (EBaseException eBaseException) {
            return null;
        }
    }

    public String getType() {
        try {
            return this.mConfig.getString(PROP_TYPE, "");
        }
        catch (EBaseException eBaseException) {
            return null;
        }
    }

    public boolean enabled() {
        try {
            boolean enable = this.mConfig.getBoolean(PROP_ENABLE, false);
            return enable;
        }
        catch (EBaseException eBaseException) {
            return false;
        }
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("type=");
        v.addElement("predicate=");
        v.addElement("enable=true");
        v.addElement("mapper=");
        v.addElement("publisher=");
        return v;
    }
}

