/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.request.AgentApprovals;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;

public class AgentPolicy
extends APolicyRule
implements IEnrollmentPolicy {
    APolicyRule mPolicy = null;

    public AgentPolicy() {
        this.NAME = "AgentPolicy";
        this.DESC = "Agent Approval Policy";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        String className = config.get("class");
        System.err.println("Creating agent policy with class " + className);
        if (className != null) {
            ConfigStore substore = config.getSubStore("params", ConfigStore.class);
            try {
                Class<?> c = Class.forName(className);
                Object o = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(o instanceof APolicyRule)) {
                    throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CLASS", (String[])new String[]{this.getInstanceName(), className}));
                }
                APolicyRule pr = (APolicyRule)o;
                pr.init(owner, substore);
                this.mPolicy = pr;
            }
            catch (EPolicyException e) {
                System.err.println("Agent Policy Error: " + e);
                throw e;
            }
            catch (Exception e) {
                System.err.println("Agent Policy Error: " + e);
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_LOADING_POLICY_ERROR", (String[])new String[]{this.getInstanceName(), className}));
            }
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.DEFERRED;
        if (this.mPolicy != null) {
            result = this.mPolicy.apply(req);
            System.err.println("Subordinate policy returns " + result);
        }
        if (result == PolicyResult.DEFERRED) {
            System.err.println("Checking agent approvals");
            AgentApprovals aa = AgentApprovals.fromStringVector((Vector)req.getExtDataInStringVector(AgentApprovals.class.getName()));
            if (aa != null && aa.elements().hasMoreElements()) {
                System.err.println("Agent approval found");
                result = PolicyResult.ACCEPTED;
            }
        }
        System.err.println("Agent policy returns " + result);
        return result;
    }

    public Vector<String> getInstanceParams() {
        return null;
    }

    public Vector<String> getDefaultParams() {
        return null;
    }
}

