/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.NSCCommentExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class NSCCommentExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    protected static final String PROP_USER_NOTICE_DISPLAY_TEXT = "displayText";
    protected static final String PROP_COMMENT_FILE = "commentFile";
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_INPUT_TYPE = "inputType";
    protected static final String TEXT = "Text";
    protected static final String FILE = "File";
    protected String mUserNoticeDisplayText;
    protected String mCommentFile;
    protected String mInputType;
    protected boolean mCritical;
    private Vector<String> mParams = new Vector();
    protected String tempCommentFile;
    protected boolean certApplied = false;

    public NSCCommentExt() {
        this.NAME = "NSCCommentExt";
        this.DESC = "Sets non-critical Netscape Comment extension in certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        FileInputStream fileStream = null;
        try {
            this.mCritical = config.getBoolean(PROP_CRITICAL, false);
            this.mParams.addElement("critical=" + this.mCritical);
            this.mInputType = config.getString(PROP_INPUT_TYPE, null);
            this.mParams.addElement("inputType=" + this.mInputType);
            this.mUserNoticeDisplayText = config.getString(PROP_USER_NOTICE_DISPLAY_TEXT, "");
            this.mParams.addElement("displayText=" + this.mUserNoticeDisplayText);
            this.tempCommentFile = config.getString(PROP_COMMENT_FILE, "");
            boolean enable = config.getBoolean("enable", false);
            if (enable && this.mInputType.equals(FILE)) {
                if (this.tempCommentFile.equals("")) {
                    throw new Exception("No file name provided");
                }
                fileStream = new FileInputStream(this.tempCommentFile);
                fileStream.close();
            }
            this.mCommentFile = this.tempCommentFile.equals("") ? "" : this.tempCommentFile.replace('\\', '/');
            config.putString(PROP_COMMENT_FILE, this.mCommentFile);
            this.mParams.addElement("commentFile=" + this.mCommentFile);
        }
        catch (FileNotFoundException e) {
            Object[] params = new Object[]{this.getInstanceName(), "File not found : " + this.tempCommentFile};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])new String[0]), params);
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.getInstanceName(), e.getMessage()};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])new String[0]), params);
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult r = this.applyCert(req, ci[i]);
            if (r != PolicyResult.REJECTED) continue;
            return r;
        }
        return res;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        this.certApplied = false;
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (extensions == null) {
            extensions = new CertificateExtensions();
            try {
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            }
            catch (Exception exception) {}
        } else {
            try {
                extensions.delete("NSCCommentExtension");
            }
            catch (IOException e) {
                try {
                    extensions.delete("2.16.840.1.113730.1.13");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.mInputType.equals(FILE)) {
            try (FileReader r = new FileReader(this.mCommentFile);
                 BufferedReader fis = new BufferedReader(r);){
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = fis.readLine()) != null) {
                    buffer.append(line);
                }
                this.mUserNoticeDisplayText = new String(buffer);
            }
            catch (IOException e) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, " Comment Text file not found : " + this.mCommentFile);
                logger.warn(CMS.getLogMessage((String)"POLICY_COMMENT_FILE_NOT_FOUND", (Object[])new Object[]{e.toString()}), (Throwable)e);
                return PolicyResult.REJECTED;
            }
        }
        this.certApplied = true;
        try {
            NSCCommentExtension cpExt = new NSCCommentExtension(this.mCritical, this.mUserNoticeDisplayText);
            extensions.set("NSCCommentExtension", (Object)cpExt);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_ERROR_CERTIFICATE_POLICIES_1", (Object[])new Object[]{this.NAME}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CERTIFICATE_POLICIES_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        return PolicyResult.ACCEPTED;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;Netscape recommendation: non-critical.", "inputType;choice(Text,File);Whether the comments would be entered in the displayText field or come from a file.", "displayText;string;The comment that may be displayed to the user when the certificate is viewed.", "commentFile;string; If data source is 'File', specify the file name with full path.", "HELP_TOKEN;configuration-policyrules-nsccomment", "HELP_TEXT;Adds 'netscape comment' extension. See manual"};
        return params;
    }

    public Vector<String> getInstanceParams() {
        return this.mParams;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        defParams.addElement("inputType=Text");
        defParams.addElement("displayText=");
        defParams.addElement("commentFile=");
        return defParams;
    }
}

