/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.cli;

import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.security.SecureRandomConfig;
import com.netscape.cmscore.security.SecureRandomFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.security.SecureRandom;
import org.apache.commons.cli.CommandLine;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.util.logging.PKILogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRemoveCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRemoveCLI.class);

    public CACertRemoveCLI(CLI parent) {
        super("del", "Remove certificate in CA", parent);
    }

    public void createOptions() {
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Missing serial number");
        }
        CertId certID = new CertId(cmdArgs[0]);
        String instanceDir = CMS.getInstanceDir();
        TomcatJSS tomcatjss = TomcatJSS.getInstance();
        tomcatjss.loadConfig();
        tomcatjss.init();
        String subsystem = this.parent.getParent().getName();
        String confDir = instanceDir + File.separator + subsystem + File.separator + "conf";
        String configFile = confDir + File.separator + "CS.cfg";
        logger.info("Loading " + configFile);
        FileConfigStorage storage = new FileConfigStorage(configFile);
        CAEngineConfig cs = new CAEngineConfig((ConfigStorage)storage);
        cs.load();
        DatabaseConfig dbConfig = cs.getDatabaseConfig();
        LDAPConfig ldapConfig = dbConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        SecureRandomConfig secureRandomConfig = cs.getJssSubsystemConfig().getSecureRandomConfig();
        SecureRandom secureRandom = SecureRandomFactory.create((SecureRandomConfig)secureRandomConfig);
        DBSubsystem dbSubsystem = new DBSubsystem();
        dbSubsystem.setEngineConfig((EngineConfig)cs);
        dbSubsystem.init(dbConfig, ldapConfig, socketConfig, passwordStore);
        try {
            CertificateRepository certificateRepository = new CertificateRepository(secureRandom, dbSubsystem);
            certificateRepository.init();
            logger.info("Removing cert record " + certID);
            certificateRepository.deleteCertificateRecord(certID.toBigInteger());
        }
        finally {
            dbSubsystem.shutdown();
        }
    }
}

