/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.config;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.application.config.AppSettings;
import org.sonar.process.MessageException;
import org.sonar.process.NetworkUtils;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.process.cluster.NodeType;

public class ClusterSettings
implements Consumer<Props> {
    private final NetworkUtils network;

    public ClusterSettings(NetworkUtils network) {
        this.network = network;
    }

    @Override
    public void accept(Props props) {
        if (ClusterSettings.isClusterEnabled(props)) {
            this.checkClusterProperties(props);
        }
    }

    private void checkClusterProperties(Props props) {
        if (props.value(ProcessProperties.Property.CLUSTER_WEB_STARTUP_LEADER.getKey()) != null) {
            throw new MessageException(String.format("Property [%s] is forbidden", ProcessProperties.Property.CLUSTER_WEB_STARTUP_LEADER.getKey()));
        }
        NodeType nodeType = ClusterSettings.toNodeType(props);
        switch (nodeType) {
            case APPLICATION: {
                ClusterSettings.ensureNotH2(props);
                ClusterSettings.requireValue(props, ProcessProperties.Property.AUTH_JWT_SECRET.getKey());
                this.ensureNotLoopbackAddresses(props, ProcessProperties.Property.CLUSTER_HZ_HOSTS.getKey());
                break;
            }
            case SEARCH: {
                ClusterSettings.requireValue(props, ProcessProperties.Property.SEARCH_HOST.getKey());
                this.ensureLocalButNotLoopbackAddress(props, ProcessProperties.Property.SEARCH_HOST.getKey());
                if (!props.contains(ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getKey())) break;
                LoggerFactory.getLogger(this.getClass()).warn("Property {} is ignored on search nodes since 7.2", (Object)ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getKey());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown value: " + nodeType);
            }
        }
        ClusterSettings.requireValue(props, ProcessProperties.Property.CLUSTER_NODE_HOST.getKey());
        this.ensureLocalButNotLoopbackAddress(props, ProcessProperties.Property.CLUSTER_NODE_HOST.getKey());
        this.ensureNotLoopbackAddresses(props, ProcessProperties.Property.CLUSTER_SEARCH_HOSTS.getKey());
    }

    private static NodeType toNodeType(Props props) {
        String nodeTypeValue = ClusterSettings.requireValue(props, ProcessProperties.Property.CLUSTER_NODE_TYPE.getKey());
        if (!NodeType.isValid((String)nodeTypeValue)) {
            throw new MessageException(String.format("Invalid value for property %s: [%s], only [%s] are allowed", ProcessProperties.Property.CLUSTER_NODE_TYPE.getKey(), nodeTypeValue, Arrays.stream(NodeType.values()).map(NodeType::getValue).collect(Collectors.joining(", "))));
        }
        return NodeType.parse((String)nodeTypeValue);
    }

    private static String requireValue(Props props, String key) {
        String value = props.value(key);
        if (StringUtils.isBlank((String)value)) {
            throw new MessageException(String.format("Property %s is mandatory", key));
        }
        return value;
    }

    private static void ensureNotH2(Props props) {
        String jdbcUrl = props.value(ProcessProperties.Property.JDBC_URL.getKey());
        if (StringUtils.isBlank((String)jdbcUrl) || jdbcUrl.startsWith("jdbc:h2:")) {
            throw new MessageException("Embedded database is not supported in cluster mode");
        }
    }

    private void ensureNotLoopbackAddresses(Props props, String propertyKey) {
        Arrays.stream(ClusterSettings.requireValue(props, propertyKey).split(",")).filter(StringUtils::isNotBlank).map(StringUtils::trim).map(s -> StringUtils.substringBefore((String)s, (String)":")).forEach(ip -> {
            try {
                if (this.network.isLoopbackInetAddress(this.network.toInetAddress(ip))) {
                    throw new MessageException(String.format("Property %s must not be a loopback address: %s", propertyKey, ip));
                }
            }
            catch (UnknownHostException e) {
                throw new MessageException(String.format("Property %s must not a valid address: %s [%s]", propertyKey, ip, e.getMessage()));
            }
        });
    }

    private void ensureLocalButNotLoopbackAddress(Props props, String propertyKey) {
        String propertyValue = props.nonNullValue(propertyKey).trim();
        try {
            InetAddress address = this.network.toInetAddress(propertyValue);
            if (!this.network.isLocalInetAddress(address) || this.network.isLoopbackInetAddress(address)) {
                throw new MessageException(String.format("Property %s must be a local non-loopback address: %s", propertyKey, propertyValue));
            }
        }
        catch (SocketException | UnknownHostException e) {
            throw new MessageException(String.format("Property %s must be a local non-loopback address: %s [%s]", propertyKey, propertyValue, e.getMessage()));
        }
    }

    public static boolean isClusterEnabled(AppSettings settings) {
        return ClusterSettings.isClusterEnabled(settings.getProps());
    }

    private static boolean isClusterEnabled(Props props) {
        return props.valueAsBoolean(ProcessProperties.Property.CLUSTER_ENABLED.getKey());
    }

    public static boolean shouldStartHazelcast(AppSettings appSettings) {
        return ClusterSettings.isClusterEnabled(appSettings.getProps()) && ClusterSettings.toNodeType(appSettings.getProps()).equals((Object)NodeType.APPLICATION);
    }

    public static List<ProcessId> getEnabledProcesses(AppSettings settings) {
        if (!ClusterSettings.isClusterEnabled(settings)) {
            return Arrays.asList(ProcessId.ELASTICSEARCH, ProcessId.WEB_SERVER, ProcessId.COMPUTE_ENGINE);
        }
        NodeType nodeType = NodeType.parse((String)settings.getValue(ProcessProperties.Property.CLUSTER_NODE_TYPE.getKey()).orElse(""));
        switch (nodeType) {
            case APPLICATION: {
                return Arrays.asList(ProcessId.WEB_SERVER, ProcessId.COMPUTE_ENGINE);
            }
            case SEARCH: {
                return Collections.singletonList(ProcessId.ELASTICSEARCH);
            }
        }
        throw new IllegalArgumentException("Unexpected node type " + nodeType);
    }

    public static boolean isLocalElasticsearchEnabled(AppSettings settings) {
        if (ClusterSettings.isClusterEnabled(settings.getProps())) {
            return NodeType.parse((String)settings.getValue(ProcessProperties.Property.CLUSTER_NODE_TYPE.getKey()).orElse("")) == NodeType.SEARCH;
        }
        return true;
    }
}

