/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
extends Thread {
    public static final String LOGGER_GOBBLER = "gobbler";
    private final InputStream is;
    private final Logger logger;

    StreamGobbler(InputStream is, String processKey) {
        this(is, processKey, LoggerFactory.getLogger((String)LOGGER_GOBBLER));
    }

    StreamGobbler(InputStream is, String processKey, Logger logger) {
        super(String.format("Gobbler[%s]", processKey));
        this.is = is;
        this.logger = logger;
    }

    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                this.logger.info(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void waitUntilFinish(@Nullable StreamGobbler gobbler) {
        if (gobbler != null) {
            try {
                gobbler.join();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

