/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.configuration;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.ce.configuration.CeConfiguration;
import org.sonar.ce.configuration.WorkerCountProvider;
import org.sonar.process.ProcessProperties;

public class CeConfigurationImpl
implements CeConfiguration {
    private static final int DEFAULT_WORKER_THREAD_COUNT = 1;
    private static final int MAX_WORKER_THREAD_COUNT = 10;
    private static final int DEFAULT_WORKER_COUNT = 1;
    private static final long DEFAULT_QUEUE_POLLING_DELAY = 2000L;
    private static final long CANCEL_WORN_OUTS_INITIAL_DELAY = 0L;
    private static final long CANCEL_WORN_OUTS_DELAY = 2L;
    @CheckForNull
    private final WorkerCountProvider workerCountProvider;
    private final int workerThreadCount;
    private final long gracefulStopTimeoutInMs;
    private int workerCount;

    public CeConfigurationImpl(Configuration configuration) {
        this(configuration, null);
    }

    public CeConfigurationImpl(Configuration configuration, @Nullable WorkerCountProvider workerCountProvider) {
        this.workerCountProvider = workerCountProvider;
        this.gracefulStopTimeoutInMs = configuration.getLong(ProcessProperties.Property.CE_GRACEFUL_STOP_TIMEOUT.getKey()).orElse(Long.parseLong(ProcessProperties.Property.CE_GRACEFUL_STOP_TIMEOUT.getDefaultValue()));
        if (workerCountProvider == null) {
            this.workerCount = 1;
            this.workerThreadCount = 1;
        } else {
            this.workerCount = CeConfigurationImpl.readWorkerCount(workerCountProvider);
            this.workerThreadCount = 10;
        }
    }

    private static synchronized int readWorkerCount(WorkerCountProvider workerCountProvider) {
        int value = workerCountProvider.get();
        if (value < 1 || value > 10) {
            throw CeConfigurationImpl.parsingError(value);
        }
        return value;
    }

    private static MessageException parsingError(int value) {
        return MessageException.of((String)String.format("Worker count '%s' is invalid. It must be an integer strictly greater than 0 and less or equal to 10", value));
    }

    @Override
    public int getWorkerMaxCount() {
        return this.workerThreadCount;
    }

    @Override
    public int getWorkerCount() {
        if (this.workerCountProvider != null) {
            this.workerCount = CeConfigurationImpl.readWorkerCount(this.workerCountProvider);
        }
        return this.workerCount;
    }

    @Override
    public long getQueuePollingDelay() {
        return 2000L;
    }

    @Override
    public long getCleanTasksInitialDelay() {
        return 0L;
    }

    @Override
    public long getCleanTasksDelay() {
        return 2L;
    }

    @Override
    public long getGracefulStopTimeoutInMs() {
        return this.gracefulStopTimeoutInMs;
    }
}

