/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.queue.InternalCeQueue;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.CeTaskInterruptedException;
import org.sonar.ce.task.CeTaskResult;
import org.sonar.ce.task.taskprocessor.CeTaskProcessor;
import org.sonar.ce.taskprocessor.CeTaskProcessorRepository;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerController;
import org.sonar.core.util.logs.Profiler;
import org.sonar.db.ce.CeActivityDto;

public class CeWorkerImpl
implements CeWorker {
    private static final Logger LOG = Loggers.get(CeWorkerImpl.class);
    private final int ordinal;
    private final String uuid;
    private final InternalCeQueue queue;
    private final CeTaskProcessorRepository taskProcessorRepository;
    private final CeWorkerController ceWorkerController;
    private final List<CeWorker.ExecutionListener> listeners;
    private final AtomicReference<RunningState> runningState = new AtomicReference();

    public CeWorkerImpl(int ordinal, String uuid, InternalCeQueue queue, CeTaskProcessorRepository taskProcessorRepository, CeWorkerController ceWorkerController, CeWorker.ExecutionListener ... listeners) {
        this.ordinal = CeWorkerImpl.checkOrdinal(ordinal);
        this.uuid = uuid;
        this.queue = queue;
        this.taskProcessorRepository = taskProcessorRepository;
        this.ceWorkerController = ceWorkerController;
        this.listeners = Arrays.asList(listeners);
    }

    private static int checkOrdinal(int ordinal) {
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"Ordinal must be >= 0");
        return ordinal;
    }

    @Override
    public CeWorker.Result call() {
        try (TrackRunningState trackRunningState = new TrackRunningState(this::findAndProcessTask);){
            CeWorker.Result result = trackRunningState.get();
            return result;
        }
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isExecutedBy(Thread thread) {
        return Optional.ofNullable(this.runningState.get()).filter(state -> ((RunningState)state).runningThread.equals(thread)).isPresent();
    }

    @Override
    public Optional<CeTask> getCurrentTask() {
        return Optional.ofNullable(this.runningState.get()).flatMap(RunningState::getTask);
    }

    private CeWorker.Result findAndProcessTask(RunningState localRunningState) {
        if (!this.ceWorkerController.isEnabled(this)) {
            return CeWorker.Result.DISABLED;
        }
        Optional<CeTask> ceTask = this.tryAndFindTaskToExecute();
        if (!ceTask.isPresent()) {
            return CeWorker.Result.NO_TASK;
        }
        try (CeWorkerController.ProcessingRecorderHook processing = this.ceWorkerController.registerProcessingFor(this);
             ExecuteTask executeTask = new ExecuteTask(localRunningState, ceTask.get());){
            executeTask.run();
        }
        catch (Exception e) {
            LOG.error(String.format("An error occurred while executing task with uuid '%s'", ceTask.get().getUuid()), (Throwable)e);
        }
        return CeWorker.Result.TASK_PROCESSED;
    }

    private Optional<CeTask> tryAndFindTaskToExecute() {
        try {
            return this.queue.peek(this.uuid);
        }
        catch (Exception e) {
            LOG.error("Failed to pop the queue of analysis reports", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Profiler startLogProfiler(CeTask task) {
        Profiler profiler = Profiler.create((Logger)LOG).logTimeLast(true).addContext("project", task.getMainComponent().flatMap(CeTask.Component::getKey).orElse(null)).addContext("type", (Object)task.getType());
        for (Map.Entry characteristic : task.getCharacteristics().entrySet()) {
            profiler.addContext((String)characteristic.getKey(), characteristic.getValue());
        }
        return profiler.addContext("id", (Object)task.getUuid()).addContext("submitter", (Object)CeWorkerImpl.submitterOf(task)).startInfo("Execute task");
    }

    @CheckForNull
    private static String submitterOf(CeTask task) {
        CeTask.User submitter = task.getSubmitter();
        if (submitter == null) {
            return null;
        }
        String submitterLogin = submitter.getLogin();
        if (submitterLogin != null) {
            return submitterLogin;
        }
        return submitter.getUuid();
    }

    private static final class RunningState {
        private final Thread runningThread;
        private CeTask task;

        private RunningState(Thread runningThread) {
            this.runningThread = runningThread;
        }

        public Optional<CeTask> getTask() {
            return Optional.ofNullable(this.task);
        }

        public void setTask(@Nullable CeTask task) {
            this.task = task;
        }
    }

    private final class ExecuteTask
    implements Runnable,
    AutoCloseable {
        private final CeTask task;
        private final RunningState localRunningState;
        private final Profiler ceProfiler;
        private CeActivityDto.Status status = CeActivityDto.Status.FAILED;
        private CeTaskResult taskResult = null;
        private Throwable error = null;

        private ExecuteTask(RunningState localRunningState, CeTask task) {
            this.task = task;
            this.localRunningState = localRunningState;
            this.ceProfiler = CeWorkerImpl.startLogProfiler(task);
        }

        @Override
        public void run() {
            this.beforeExecute();
            this.executeTask();
        }

        @Override
        public void close() {
            this.afterExecute();
        }

        private void beforeExecute() {
            this.localRunningState.setTask(this.task);
            this.callListeners(t -> t.onStart(this.task));
        }

        private void executeTask() {
            try {
                Optional<CeTaskProcessor> taskProcessor = CeWorkerImpl.this.taskProcessorRepository.getForCeTask(this.task);
                if (taskProcessor.isPresent()) {
                    this.taskResult = taskProcessor.get().process(this.task);
                    this.status = CeActivityDto.Status.SUCCESS;
                } else {
                    LOG.error("No CeTaskProcessor is defined for task of type {}. Plugin configuration may have changed", (Object)this.task.getType());
                    this.status = CeActivityDto.Status.FAILED;
                }
            }
            catch (MessageException e) {
                this.error = e;
            }
            catch (Throwable e) {
                Optional taskInterruptedException = CeTaskInterruptedException.isTaskInterruptedException((Throwable)e);
                if (taskInterruptedException.isPresent()) {
                    CeActivityDto.Status interruptionStatus;
                    LOG.trace("Task interrupted", (Object)e);
                    CeTaskInterruptedException exception = (CeTaskInterruptedException)taskInterruptedException.get();
                    this.status = interruptionStatus = exception.getStatus();
                    this.error = interruptionStatus == CeActivityDto.Status.FAILED ? exception : null;
                }
                LOG.error("Failed to execute task {}", (Object)this.task.getUuid(), (Object)e);
                this.error = e;
            }
        }

        private void afterExecute() {
            this.localRunningState.setTask(null);
            this.finalizeTask(this.task, this.ceProfiler, this.status, this.taskResult, this.error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finalizeTask(CeTask task, Profiler ceProfiler, CeActivityDto.Status status, @Nullable CeTaskResult taskResult, @Nullable Throwable error) {
            try {
                CeWorkerImpl.this.queue.remove(task, status, taskResult, error);
            }
            catch (Exception e) {
                if (error != null) {
                    e.addSuppressed(error);
                }
                LOG.error(String.format("Failed to finalize task with uuid '%s' and persist its state to db", task.getUuid()), (Throwable)e);
            }
            finally {
                ceProfiler.addContext("status", (Object)status.name());
                long durationMs = ceProfiler.stopInfo("Executed task");
                Duration duration = Duration.of(durationMs, ChronoUnit.MILLIS);
                this.callListeners(t -> t.onEnd(task, status, duration, taskResult, error));
            }
        }

        private void callListeners(Consumer<CeWorker.ExecutionListener> call) {
            CeWorkerImpl.this.listeners.forEach(listener -> {
                try {
                    call.accept((CeWorker.ExecutionListener)listener);
                }
                catch (Throwable t) {
                    LOG.error(String.format("Call to listener %s failed.", listener.getClass().getSimpleName()), t);
                }
            });
        }
    }

    private class TrackRunningState
    implements AutoCloseable,
    Supplier<CeWorker.Result> {
        private final RunningState localRunningState;
        private final Function<RunningState, CeWorker.Result> delegate;
        private final String oldName;

        private TrackRunningState(Function<RunningState, CeWorker.Result> delegate) {
            Thread currentThread = Thread.currentThread();
            this.localRunningState = new RunningState(currentThread);
            if (!CeWorkerImpl.this.runningState.compareAndSet(null, this.localRunningState)) {
                LOG.warn("Worker {} (UUID=%s) starts executing with new Thread {} while running state isn't null. Forcefully updating Workers's running state to new Thread.", new Object[]{CeWorkerImpl.this.getOrdinal(), CeWorkerImpl.this.getUUID(), currentThread});
                CeWorkerImpl.this.runningState.set(this.localRunningState);
            }
            this.delegate = delegate;
            this.oldName = currentThread.getName();
        }

        @Override
        public CeWorker.Result get() {
            this.localRunningState.runningThread.setName(String.format("Worker %s (UUID=%s) on %s", CeWorkerImpl.this.getOrdinal(), CeWorkerImpl.this.getUUID(), this.oldName));
            return this.delegate.apply(this.localRunningState);
        }

        @Override
        public void close() {
            this.localRunningState.runningThread.setName(this.oldName);
            if (!CeWorkerImpl.this.runningState.compareAndSet(this.localRunningState, null)) {
                LOG.warn("Worker {} (UUID=%s) ending execution in Thread {} while running state has already changed. Keeping this new state.", new Object[]{CeWorkerImpl.this.getOrdinal(), CeWorkerImpl.this.getUUID(), this.localRunningState.runningThread});
            }
        }
    }
}

