/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractStream.class);
    private final Integer identifier;
    private final String idAsString;
    private volatile AbstractStream parentStream = null;
    private final Set<AbstractNonZeroStream> childStreams = Collections.newSetFromMap(new ConcurrentHashMap());
    private long windowSize = 65535L;

    public AbstractStream(Integer identifier) {
        this.identifier = identifier;
        this.idAsString = identifier.toString();
    }

    public Integer getIdentifier() {
        return this.identifier;
    }

    final String getIdAsString() {
        return this.idAsString;
    }

    public int getIdAsInt() {
        return this.identifier;
    }

    void detachFromParent() {
        if (this.parentStream != null) {
            this.parentStream.getChildStreams().remove(this);
            this.parentStream = null;
        }
    }

    final void addChild(AbstractNonZeroStream child) {
        child.setParentStream(this);
        this.childStreams.add(child);
    }

    boolean isDescendant(AbstractStream stream) {
        AbstractStream parent;
        for (parent = stream.getParentStream(); parent != null && parent != this; parent = parent.getParentStream()) {
        }
        return parent != null;
    }

    AbstractStream getParentStream() {
        return this.parentStream;
    }

    void setParentStream(AbstractStream parentStream) {
        this.parentStream = parentStream;
    }

    final Set<AbstractNonZeroStream> getChildStreams() {
        return this.childStreams;
    }

    protected synchronized void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    protected synchronized long getWindowSize() {
        return this.windowSize;
    }

    protected synchronized void incrementWindowSize(int increment) throws Http2Exception {
        this.windowSize += (long)increment;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("abstractStream.windowSizeInc", this.getConnectionId(), this.getIdAsString(), Integer.toString(increment), Long.toString(this.windowSize)));
        }
        if (this.windowSize > Integer.MAX_VALUE) {
            String msg = sm.getString("abstractStream.windowSizeTooBig", this.getConnectionId(), this.identifier, Integer.toString(increment), Long.toString(this.windowSize));
            if (this.identifier == 0) {
                throw new ConnectionException(msg, Http2Error.FLOW_CONTROL_ERROR);
            }
            throw new StreamException(msg, Http2Error.FLOW_CONTROL_ERROR, this.identifier);
        }
    }

    protected synchronized void decrementWindowSize(int decrement) {
        this.windowSize -= (long)decrement;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("abstractStream.windowSizeDec", this.getConnectionId(), this.getIdAsString(), Integer.toString(decrement), Long.toString(this.windowSize)));
        }
    }

    protected abstract String getConnectionId();

    protected abstract int getWeight();

    @Deprecated
    protected abstract void doNotifyAll();
}

