/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.config.Configuration;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintReportParser;
import org.sonar.plugins.python.pylint.PylintRuleParser;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;

public class PylintImportSensor
extends PythonReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.python.pylint.reportPath";
    private static final String DEFAULT_REPORT_PATH = "pylint-reports/pylint-result-*.txt";
    private static final Logger LOG = Loggers.get(PylintImportSensor.class);
    private static final PylintRuleParser pylintRules = new PylintRuleParser("/org/sonar/plugins/python/pylint/rules.xml");
    private static final Set<String> warningAlreadyLogged = new HashSet<String>();

    public PylintImportSensor(Configuration conf, AnalysisWarningsWrapper analysisWarnings) {
        super(conf, analysisWarnings, "Pylint");
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        super.describe(descriptor);
        descriptor.createIssuesForRuleRepository(new String[]{"Pylint"}).onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PATH_KEY));
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReports(SensorContext context, List<File> reports) {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        for (File report : reports) {
            try {
                issues.addAll(PylintImportSensor.parse(report, context.fileSystem()));
            }
            catch (FileNotFoundException e) {
                LOG.error("Report '{}' cannot be found, details: '{}'", (Object)report, (Object)e);
            }
            catch (IOException e) {
                LOG.error("Report '{}' cannot be read, details: '{}'", (Object)report, (Object)e);
            }
        }
        PylintImportSensor.saveIssues(issues, context);
    }

    private static List<Issue> parse(File report, FileSystem fileSystem) throws IOException {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        PylintReportParser parser = new PylintReportParser();
        Scanner sc = new Scanner(report.toPath(), fileSystem.encoding().name());
        while (sc.hasNext()) {
            String line = sc.nextLine();
            Issue issue = parser.parseLine(line);
            if (issue == null) continue;
            issues.add(issue);
        }
        sc.close();
        return issues;
    }

    private static void saveIssues(List<Issue> issues, SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        for (Issue pylintIssue : issues) {
            String filepath = pylintIssue.getFilename();
            InputFile pyfile = fileSystem.inputFile(fileSystem.predicates().hasPath(filepath));
            if (pyfile != null) {
                ActiveRule rule = context.activeRules().find(RuleKey.of((String)"Pylint", (String)pylintIssue.getRuleId()));
                PylintImportSensor.processRule(pylintIssue, pyfile, rule, context);
                continue;
            }
            LOG.warn("Cannot find the file '{}' in SonarQube, ignoring violation", (Object)filepath);
        }
    }

    public static void processRule(Issue pylintIssue, InputFile pyfile, @Nullable ActiveRule rule, SensorContext context) {
        if (rule != null) {
            NewIssue newIssue = context.newIssue().forRule(rule.ruleKey());
            newIssue.at(newIssue.newLocation().on((InputComponent)pyfile).at(pyfile.selectLine(pylintIssue.getLine())).message(pylintIssue.getDescription()));
            newIssue.save();
        } else if (!pylintRules.hasRuleDefinition(pylintIssue.getRuleId())) {
            PylintImportSensor.logUnknownRuleWarning(pylintIssue.getRuleId());
        }
    }

    private static void logUnknownRuleWarning(String ruleId) {
        if (!warningAlreadyLogged.contains(ruleId)) {
            warningAlreadyLogged.add(ruleId);
            LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)ruleId);
        }
    }

    static void clearLoggedWarnings() {
        warningAlreadyLogged.clear();
    }
}

