/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.Token;

public class TokenLocation {
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;

    public TokenLocation(Token token) {
        this.startLine = token.getLine();
        this.startLineOffset = token.getColumn();
        String value = token.getValue();
        String[] lines = value.split("\r\n|\n|\r", -1);
        if (lines.length > 1) {
            this.endLine = token.getLine() + lines.length - 1;
            this.endLineOffset = lines[lines.length - 1].length();
        } else {
            this.endLine = this.startLine;
            this.endLineOffset = this.startLineOffset + token.getValue().length();
        }
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }
}

