/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;

public class TestMeasureComputerDefinition
implements MeasureComputer.MeasureComputerDefinition {
    private final Set<String> inputMetricKeys;
    private final Set<String> outputMetrics;

    private TestMeasureComputerDefinition(MeasureComputerDefinitionBuilderImpl builder) {
        this.inputMetricKeys = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(builder.inputMetricKeys)));
        this.outputMetrics = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(builder.outputMetrics)));
    }

    @Override
    public Set<String> getInputMetrics() {
        return this.inputMetricKeys;
    }

    @Override
    public Set<String> getOutputMetrics() {
        return this.outputMetrics;
    }

    public static class MeasureComputerDefinitionBuilderImpl
    implements MeasureComputer.MeasureComputerDefinition.Builder {
        private String[] inputMetricKeys = new String[0];
        private String[] outputMetrics;

        @Override
        public MeasureComputer.MeasureComputerDefinition.Builder setInputMetrics(String ... inputMetrics) {
            this.inputMetricKeys = MeasureComputerDefinitionBuilderImpl.validateInputMetricKeys(inputMetrics);
            return this;
        }

        @Override
        public MeasureComputer.MeasureComputerDefinition.Builder setOutputMetrics(String ... outputMetrics) {
            this.outputMetrics = MeasureComputerDefinitionBuilderImpl.validateOutputMetricKeys(outputMetrics);
            return this;
        }

        @Override
        public MeasureComputer.MeasureComputerDefinition build() {
            MeasureComputerDefinitionBuilderImpl.validateInputMetricKeys(this.inputMetricKeys);
            MeasureComputerDefinitionBuilderImpl.validateOutputMetricKeys(this.outputMetrics);
            return new TestMeasureComputerDefinition(this);
        }

        private static String[] validateInputMetricKeys(String[] inputMetrics) {
            Objects.requireNonNull(inputMetrics, "Input metrics cannot be null");
            MeasureComputerDefinitionBuilderImpl.checkNotNull(inputMetrics);
            return inputMetrics;
        }

        private static String[] validateOutputMetricKeys(String[] outputMetrics) {
            Objects.requireNonNull(outputMetrics, "Output metrics cannot be null");
            Preconditions.checkArgument(outputMetrics.length > 0, "At least one output metric must be defined");
            List<String> outputMetricKeys = Arrays.asList(outputMetrics);
            CoreMetrics.getMetrics().stream().map(Metric::getKey).forEach(metricKey -> Preconditions.checkArgument(!outputMetricKeys.contains(metricKey), "Core metrics are not allowed"));
            MeasureComputerDefinitionBuilderImpl.checkNotNull(outputMetrics);
            return outputMetrics;
        }

        private static void checkNotNull(String[] metrics) {
            for (String metric : metrics) {
                Objects.requireNonNull(metric, "Null metric is not allowed");
            }
        }
    }
}

