/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.sonar.core.util.MacAddressProvider;
import org.sonar.core.util.UuidGenerator;

public final class UuidGeneratorImpl
implements UuidGenerator {
    private final FullNewUuidGenerator fullNewUuidGenerator = new FullNewUuidGenerator();

    @Override
    public byte[] generate() {
        return this.fullNewUuidGenerator.get();
    }

    @Override
    public UuidGenerator.WithFixedBase withFixedBase() {
        return new FixedBasedUuidGenerator();
    }

    private static class FixedBasedUuidGenerator
    extends UuidGeneratorBase
    implements UuidGenerator.WithFixedBase {
        private final byte[] base = new byte[15];

        FixedBasedUuidGenerator() {
            int sequenceId = this.getSequenceId();
            this.initBase(this.base, sequenceId);
        }

        @Override
        public byte[] generate(int increment) {
            byte[] buffer = new byte[15];
            System.arraycopy(this.base, 0, buffer, 0, buffer.length);
            return super.generate(buffer, increment);
        }
    }

    private static final class FullNewUuidGenerator
    extends UuidGeneratorBase
    implements Supplier<byte[]> {
        private FullNewUuidGenerator() {
        }

        @Override
        public byte[] get() {
            byte[] buffer = new byte[15];
            int sequenceId = this.getSequenceId();
            this.initBase(buffer, sequenceId);
            return super.generate(buffer, sequenceId);
        }
    }

    private static class UuidGeneratorBase {
        private final AtomicInteger sequenceNumber = new AtomicInteger(new SecureRandom().nextInt());
        private final byte[] secureMungedAddress = MacAddressProvider.getSecureMungedAddress();
        private long lastTimestamp = 0L;

        private UuidGeneratorBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initBase(byte[] buffer, int sequenceId) {
            long timestamp = System.currentTimeMillis();
            UuidGeneratorBase uuidGeneratorBase = this;
            synchronized (uuidGeneratorBase) {
                timestamp = Math.max(this.lastTimestamp, timestamp);
                if (sequenceId == 0) {
                    ++timestamp;
                }
                this.lastTimestamp = timestamp;
            }
            UuidGeneratorBase.putLong(buffer, timestamp, 0, 6);
            System.arraycopy(this.secureMungedAddress, 0, buffer, 6, this.secureMungedAddress.length);
        }

        protected byte[] generate(byte[] buffer, int increment) {
            UuidGeneratorBase.putLong(buffer, increment, 12, 3);
            return buffer;
        }

        int getSequenceId() {
            return this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        }

        private static void putLong(byte[] array, long l, int pos, int numberOfLongBytes) {
            for (int i = 0; i < numberOfLongBytes; ++i) {
                array[pos + numberOfLongBytes - i - 1] = (byte)(l >>> i * 8);
            }
        }
    }
}

