/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.deprecated.test;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.test.CoverageBlock;
import org.sonar.api.test.MutableTestCase;
import org.sonar.api.test.TestCase;
import org.sonar.api.test.TestPlan;
import org.sonar.api.test.Testable;
import org.sonar.api.test.exception.CoverageAlreadyExistsException;
import org.sonar.api.test.exception.IllegalDurationException;
import org.sonar.scanner.deprecated.test.DefaultCoverageBlock;
import org.sonar.scanner.deprecated.test.DefaultTestPlan;
import org.sonar.scanner.deprecated.test.DefaultTestable;

public class DefaultTestCase
implements MutableTestCase {
    private final DefaultTestPlan testPlan;
    private String type;
    private Long durationInMs;
    private TestCase.Status status;
    private String name;
    private String message;
    private String stackTrace;
    private Map<DefaultInputFile, CoverageBlock> coverageBlocksByTestedFile = new LinkedHashMap<DefaultInputFile, CoverageBlock>();

    public DefaultTestCase(DefaultTestPlan testPlan) {
        this.testPlan = testPlan;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public MutableTestCase setType(@Nullable String s) {
        this.type = s;
        return this;
    }

    @Override
    public Long durationInMs() {
        return this.durationInMs;
    }

    @Override
    public MutableTestCase setDurationInMs(@Nullable Long l) {
        if (l != null && l < 0L) {
            throw new IllegalDurationException("Test duration must be positive (got: " + l + ")");
        }
        this.durationInMs = l;
        return this;
    }

    @Override
    public TestCase.Status status() {
        return this.status;
    }

    @Override
    public MutableTestCase setStatus(@Nullable TestCase.Status s) {
        this.status = s;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    public MutableTestCase setName(String s) {
        this.name = s;
        return this;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public MutableTestCase setMessage(String s) {
        this.message = s;
        return this;
    }

    @Override
    public String stackTrace() {
        return this.stackTrace;
    }

    @Override
    public MutableTestCase setStackTrace(String s) {
        this.stackTrace = s;
        return this;
    }

    @Override
    public MutableTestCase setCoverageBlock(Testable testable, List<Integer> lines) {
        DefaultInputFile coveredFile = ((DefaultTestable)testable).inputFile();
        return this.setCoverageBlock(coveredFile, lines);
    }

    @Override
    public MutableTestCase setCoverageBlock(InputFile mainFile, List<Integer> lines) {
        Preconditions.checkArgument(mainFile.type() == InputFile.Type.MAIN, "Test file can only cover a main file");
        DefaultInputFile coveredFile = (DefaultInputFile)mainFile;
        if (this.coverageBlocksByTestedFile.containsKey(coveredFile)) {
            throw new CoverageAlreadyExistsException("The link between " + this.name() + " and " + coveredFile.key() + " already exists");
        }
        this.coverageBlocksByTestedFile.put(coveredFile, new DefaultCoverageBlock(this, coveredFile, lines));
        return this;
    }

    @Override
    public TestPlan testPlan() {
        return this.testPlan;
    }

    @Override
    public boolean doesCover() {
        return !this.coverageBlocksByTestedFile.isEmpty();
    }

    @Override
    public int countCoveredLines() {
        throw new UnsupportedOperationException("Not supported since SQ 5.2");
    }

    @Override
    public Iterable<CoverageBlock> coverageBlocks() {
        return this.coverageBlocksByTestedFile.values();
    }

    @Override
    public CoverageBlock coverageBlock(Testable testable) {
        DefaultInputFile coveredFile = ((DefaultTestable)testable).inputFile();
        return this.coverageBlocksByTestedFile.get(coveredFile);
    }
}

