/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.genericcoverage.GenericCoverageReportParser;

public class GenericCoverageSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(GenericCoverageSensor.class);
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.coverageReportPaths";
    @Deprecated
    static final String OLD_REPORT_PATH_PROPERTY_KEY = "sonar.genericcoverage.reportPath";
    @Deprecated
    static final String OLD_COVERAGE_REPORT_PATHS_PROPERTY_KEY = "sonar.genericcoverage.reportPaths";
    @Deprecated
    static final String OLD_IT_COVERAGE_REPORT_PATHS_PROPERTY_KEY = "sonar.genericcoverage.itReportPaths";
    @Deprecated
    static final String OLD_OVERALL_COVERAGE_REPORT_PATHS_PROPERTY_KEY = "sonar.genericcoverage.overallReportPaths";
    private final DefaultConfiguration config;

    public GenericCoverageSensor(DefaultConfiguration config) {
        this.config = config;
    }

    public static ImmutableList<PropertyDefinition> properties() {
        return ImmutableList.of(PropertyDefinition.builder(REPORT_PATHS_PROPERTY_KEY).name("Coverage report paths").description("List of comma-separated paths (absolute or relative) containing coverage report.").category("codeCoverage").onQualifiers("TRK", new String[0]).multiValues(true).deprecatedKey(OLD_COVERAGE_REPORT_PATHS_PROPERTY_KEY).build());
    }

    private void loadArrayDeprecated(Set<String> reportPaths, String propertyKey) {
        if (this.config.getOriginalProperties().containsKey(propertyKey)) {
            LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)propertyKey, (Object)REPORT_PATHS_PROPERTY_KEY);
            reportPaths.addAll(Arrays.asList(this.config.getStringArray(propertyKey)));
        }
    }

    private void loadDeprecated(Set<String> reportPaths, String propertyKey) {
        if (this.config.getOriginalProperties().containsKey(propertyKey)) {
            LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)propertyKey, (Object)REPORT_PATHS_PROPERTY_KEY);
            this.config.get(propertyKey).ifPresent(reportPaths::add);
        }
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Generic Coverage Report").global().onlyWhenConfiguration(c -> Arrays.asList(REPORT_PATHS_PROPERTY_KEY, OLD_REPORT_PATH_PROPERTY_KEY, OLD_COVERAGE_REPORT_PATHS_PROPERTY_KEY, OLD_IT_COVERAGE_REPORT_PATHS_PROPERTY_KEY, OLD_OVERALL_COVERAGE_REPORT_PATHS_PROPERTY_KEY).stream().anyMatch(c::hasKey));
    }

    @Override
    public void execute(SensorContext context) {
        Set<String> reportPaths = this.loadReportPaths();
        for (String reportPath : reportPaths) {
            File reportFile = context.fileSystem().resolvePath(reportPath);
            LOG.info("Parsing {}", (Object)reportFile);
            GenericCoverageReportParser parser = new GenericCoverageReportParser();
            parser.parse(reportFile, context);
            LOG.info("Imported coverage data for {} files", (Object)parser.numberOfMatchedFiles());
            int numberOfUnknownFiles = parser.numberOfUnknownFiles();
            if (numberOfUnknownFiles <= 0) continue;
            LOG.info("Coverage data ignored for " + numberOfUnknownFiles + " unknown files, including:\n" + parser.firstUnknownFiles().stream().collect(Collectors.joining("\n")));
        }
    }

    Set<String> loadReportPaths() {
        LinkedHashSet<String> reportPaths = new LinkedHashSet<String>();
        reportPaths.addAll(Arrays.asList(this.config.getStringArray(REPORT_PATHS_PROPERTY_KEY)));
        this.loadDeprecated(reportPaths, OLD_REPORT_PATH_PROPERTY_KEY);
        this.loadArrayDeprecated(reportPaths, OLD_COVERAGE_REPORT_PATHS_PROPERTY_KEY);
        this.loadArrayDeprecated(reportPaths, OLD_IT_COVERAGE_REPORT_PATHS_PROPERTY_KEY);
        this.loadArrayDeprecated(reportPaths, OLD_OVERALL_COVERAGE_REPORT_PATHS_PROPERTY_KEY);
        return reportPaths;
    }
}

