/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.SingleProjectRepository;

@Immutable
public class MultiModuleProjectRepository
extends ProjectRepositories {
    private Map<String, SingleProjectRepository> repositoriesPerModule;

    public MultiModuleProjectRepository(Map<String, SingleProjectRepository> repositoriesPerModule) {
        super(true);
        this.repositoriesPerModule = ImmutableMap.copyOf(repositoriesPerModule);
    }

    @CheckForNull
    public FileData fileData(String moduleKeyWithBranch, String path) {
        SingleProjectRepository repository = this.repositoriesPerModule.get(moduleKeyWithBranch);
        return repository == null ? null : repository.fileData(path);
    }
}

