/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.collect.ImmutableMultimap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.scan.filesystem.PathResolver;

@Immutable
public class DefaultInputModuleHierarchy
implements InputModuleHierarchy {
    private final DefaultInputModule root;
    private final Map<DefaultInputModule, DefaultInputModule> parents;
    private final ImmutableMultimap<DefaultInputModule, DefaultInputModule> children;

    public DefaultInputModuleHierarchy(DefaultInputModule root) {
        this.children = new ImmutableMultimap.Builder().build();
        this.parents = Collections.emptyMap();
        this.root = root;
    }

    public DefaultInputModuleHierarchy(DefaultInputModule root, Map<DefaultInputModule, DefaultInputModule> parents) {
        ImmutableMultimap.Builder<DefaultInputModule, DefaultInputModule> childrenBuilder = new ImmutableMultimap.Builder<DefaultInputModule, DefaultInputModule>();
        for (Map.Entry<DefaultInputModule, DefaultInputModule> e : parents.entrySet()) {
            childrenBuilder.put(e.getValue(), e.getKey());
        }
        this.children = childrenBuilder.build();
        this.parents = Collections.unmodifiableMap(new HashMap<DefaultInputModule, DefaultInputModule>(parents));
        this.root = root;
    }

    @Override
    public DefaultInputModule root() {
        return this.root;
    }

    @Override
    public Collection<DefaultInputModule> children(DefaultInputModule component) {
        return this.children.get((Object)component);
    }

    @Override
    public DefaultInputModule parent(DefaultInputModule component) {
        return this.parents.get(component);
    }

    @Override
    public boolean isRoot(DefaultInputModule module) {
        return this.root.equals(module);
    }

    @Override
    @CheckForNull
    public String relativePath(DefaultInputModule module) {
        DefaultInputModule parent = this.parent(module);
        if (parent == null) {
            return "";
        }
        Path parentBaseDir = parent.getBaseDir();
        Path moduleBaseDir = module.getBaseDir();
        return PathResolver.relativize(parentBaseDir, moduleBaseDir).orElse(null);
    }

    @Override
    public String relativePathToRoot(DefaultInputModule module) {
        Path rootBaseDir = this.root.getBaseDir();
        Path moduleBaseDir = module.getBaseDir();
        return PathResolver.relativize(rootBaseDir, moduleBaseDir).orElse(null);
    }
}

