/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.protocol.output;

import java.io.File;
import javax.annotation.CheckForNull;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.Protobuf;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReport;

public class ScannerReportReader {
    private final FileStructure fileStructure;

    public ScannerReportReader(File dir) {
        this.fileStructure = new FileStructure(dir);
    }

    public ScannerReport.Metadata readMetadata() {
        File file = this.fileStructure.metadataFile();
        if (!ScannerReportReader.fileExists(file)) {
            throw new IllegalStateException("Metadata file is missing in analysis report: " + file);
        }
        return (ScannerReport.Metadata)Protobuf.read((File)file, ScannerReport.Metadata.parser());
    }

    public CloseableIterator<ScannerReport.ActiveRule> readActiveRules() {
        File file = this.fileStructure.activeRules();
        if (!ScannerReportReader.fileExists(file)) {
            return CloseableIterator.emptyCloseableIterator();
        }
        return Protobuf.readStream((File)file, ScannerReport.ActiveRule.parser());
    }

    public CloseableIterator<ScannerReport.AdHocRule> readAdHocRules() {
        File file = this.fileStructure.adHocRules();
        if (!ScannerReportReader.fileExists(file)) {
            return CloseableIterator.emptyCloseableIterator();
        }
        return Protobuf.readStream((File)file, ScannerReport.AdHocRule.parser());
    }

    public CloseableIterator<ScannerReport.Measure> readComponentMeasures(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.MEASURES, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.Measure.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    @CheckForNull
    public ScannerReport.Changesets readChangesets(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CHANGESETS, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return (ScannerReport.Changesets)Protobuf.read((File)file, ScannerReport.Changesets.parser());
        }
        return null;
    }

    public ScannerReport.Component readComponent(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COMPONENT, componentRef);
        if (!ScannerReportReader.fileExists(file)) {
            throw new IllegalStateException("Unable to find report for component #" + componentRef + ". File does not exist: " + file);
        }
        return (ScannerReport.Component)Protobuf.read((File)file, ScannerReport.Component.parser());
    }

    public CloseableIterator<ScannerReport.Issue> readComponentIssues(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.ISSUES, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.Issue.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<ScannerReport.ExternalIssue> readComponentExternalIssues(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.EXTERNAL_ISSUES, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.ExternalIssue.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<ScannerReport.Duplication> readComponentDuplications(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.DUPLICATIONS, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.Duplication.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<ScannerReport.CpdTextBlock> readCpdTextBlocks(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CPD_TEXT_BLOCKS, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.CpdTextBlock.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public CloseableIterator<ScannerReport.Symbol> readComponentSymbols(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYMBOLS, componentRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.Symbol.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public boolean hasSyntaxHighlighting(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, componentRef);
        return file.exists();
    }

    @CheckForNull
    public CloseableIterator<ScannerReport.LineSgnificantCode> readComponentSignificantCode(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SGNIFICANT_CODE, fileRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.LineSgnificantCode.parser());
        }
        return null;
    }

    @CheckForNull
    public ScannerReport.ChangedLines readComponentChangedLines(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CHANGED_LINES, fileRef);
        if (ScannerReportReader.fileExists(file)) {
            return (ScannerReport.ChangedLines)Protobuf.read((File)file, ScannerReport.ChangedLines.parser());
        }
        return null;
    }

    public boolean hasSignificantCode(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SGNIFICANT_CODE, fileRef);
        return ScannerReportReader.fileExists(file);
    }

    public CloseableIterator<ScannerReport.SyntaxHighlightingRule> readComponentSyntaxHighlighting(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, fileRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.SyntaxHighlightingRule.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    public boolean hasCoverage(int componentRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGES, componentRef);
        return file.exists();
    }

    public CloseableIterator<ScannerReport.LineCoverage> readComponentCoverage(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGES, fileRef);
        if (ScannerReportReader.fileExists(file)) {
            return Protobuf.readStream((File)file, ScannerReport.LineCoverage.parser());
        }
        return CloseableIterator.emptyCloseableIterator();
    }

    @CheckForNull
    public File readFileSource(int fileRef) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SOURCE, fileRef);
        if (ScannerReportReader.fileExists(file)) {
            return file;
        }
        return null;
    }

    public CloseableIterator<ScannerReport.ContextProperty> readContextProperties() {
        File file = this.fileStructure.contextProperties();
        if (!ScannerReportReader.fileExists(file)) {
            return CloseableIterator.emptyCloseableIterator();
        }
        return Protobuf.readStream((File)file, ScannerReport.ContextProperty.parser());
    }

    public CloseableIterator<ScannerReport.AnalysisWarning> readAnalysisWarnings() {
        File file = this.fileStructure.analysisWarnings();
        if (!ScannerReportReader.fileExists(file)) {
            return CloseableIterator.emptyCloseableIterator();
        }
        return Protobuf.readStream((File)file, ScannerReport.AnalysisWarning.parser());
    }

    private static boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    public FileStructure getFileStructure() {
        return this.fileStructure;
    }
}

