/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.sonar.server.platform.db.migration.charset.ColumnDef;
import org.sonar.server.platform.db.migration.charset.MssqlCharsetHandler;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

class MssqlMetadataReader {
    private final SqlExecutor sqlExecutor;

    MssqlMetadataReader(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    String getDefaultCollation(Connection connection) throws SQLException {
        return this.sqlExecutor.selectSingleString(connection, "SELECT CONVERT(VARCHAR(128), DATABASEPROPERTYEX(DB_NAME(), 'Collation'))");
    }

    List<ColumnDef> getColumnDefs(Connection connection) throws SQLException {
        return this.sqlExecutor.select(connection, "select table_name, column_name, character_set_name, collation_name, data_type, character_maximum_length, is_nullable FROM [INFORMATION_SCHEMA].[COLUMNS] WHERE collation_name is not null ORDER BY table_name,column_name", ColumnDef.ColumnDefRowConverter.INSTANCE);
    }

    List<MssqlCharsetHandler.ColumnIndex> getColumnIndices(Connection connection, ColumnDef column) throws SQLException {
        String selectIndicesSql = String.format("SELECT I.name as index_name, I.is_unique as unik, IndexedColumns      FROM sys.indexes I      JOIN sys.tables T ON T.Object_id = I.Object_id      JOIN (SELECT * FROM (      SELECT IC2.object_id, IC2.index_id,      STUFF((SELECT ' ,' + C.name      FROM sys.index_columns IC1      JOIN sys.columns C      ON C.object_id = IC1.object_id      AND C.column_id = IC1.column_id      AND IC1.is_included_column = 0      WHERE IC1.object_id = IC2.object_id      AND IC1.index_id = IC2.index_id      GROUP BY IC1.object_id,C.name,index_id      ORDER BY MAX(IC1.key_ordinal)      FOR XML PATH('')), 1, 2, '') IndexedColumns      FROM sys.index_columns IC2      GROUP BY IC2.object_id ,IC2.index_id) tmp1 )tmp2      ON I.object_id = tmp2.object_id AND I.Index_id = tmp2.index_id      WHERE I.is_primary_key = 0 AND I.is_unique_constraint = 0      and T.name =('%s')      and CHARINDEX ('%s',IndexedColumns)>0", column.getTable(), column.getColumn());
        return this.sqlExecutor.select(connection, selectIndicesSql, MssqlCharsetHandler.ColumnIndexConverter.INSTANCE);
    }
}

