/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class BooleanColumnDef
extends AbstractColumnDef {
    private BooleanColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, builder.defaultValue);
    }

    public static Builder newBooleanColumnDefBuilder() {
        return new Builder();
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "postgresql": 
            case "h2": {
                return "BOOLEAN";
            }
            case "oracle": {
                return "NUMBER(1)";
            }
            case "mssql": {
                return "BIT";
            }
            case "mysql": {
                return "TINYINT(1)";
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown dialect '%s'", dialect.getId()));
    }

    public static class Builder {
        private String columnName;
        private Boolean defaultValue = null;
        private boolean isNullable = true;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder setDefaultValue(@Nullable Boolean b) {
            this.defaultValue = b;
            return this;
        }

        public BooleanColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new BooleanColumnDef(this);
        }
    }
}

