/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.history;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.history.MigrationHistoryMeddler;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

public class MigrationHistoryImpl
implements MigrationHistory {
    private static final String SCHEMA_MIGRATIONS_TABLE = "schema_migrations";
    private final Database database;
    private final MigrationHistoryMeddler migrationHistoryMeddler;

    public MigrationHistoryImpl(Database database, MigrationHistoryMeddler migrationHistoryMeddler) {
        this.database = database;
        this.migrationHistoryMeddler = migrationHistoryMeddler;
    }

    @Override
    public void start() {
        try (Connection connection = this.database.getDataSource().getConnection();){
            Preconditions.checkState((boolean)DatabaseUtils.tableExists((String)SCHEMA_MIGRATIONS_TABLE, (Connection)connection), (Object)"Migration history table is missing");
            this.migrationHistoryMeddler.meddle(this);
        }
        catch (SQLException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void stop() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Long> getLastMigrationNumber() {
        try (Connection connection = this.database.getDataSource().getConnection();){
            List<Long> versions = MigrationHistoryImpl.selectVersions(connection);
            if (!versions.isEmpty()) {
                Optional<Long> optional2 = Optional.of(versions.get(versions.size() - 1));
                return optional2;
            }
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to read content of table schema_migrations", e);
        }
    }

    @Override
    public void done(RegisteredMigrationStep dbMigration) {
        long migrationNumber = dbMigration.getMigrationNumber();
        try (Connection connection = this.database.getDataSource().getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into schema_migrations(version) values (?)");){
            statement.setString(1, String.valueOf(migrationNumber));
            statement.execute();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(String.format("Failed to insert row with value %s in table %s", migrationNumber, SCHEMA_MIGRATIONS_TABLE), e);
        }
    }

    private static List<Long> selectVersions(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            List list;
            block13: {
                ResultSet resultSet = statement.executeQuery("select version from schema_migrations");
                try {
                    ArrayList<Long> res = new ArrayList<Long>();
                    while (resultSet.next()) {
                        res.add(resultSet.getLong(1));
                    }
                    list = (List)res.stream().sorted(Comparator.naturalOrder()).collect(MoreCollectors.toList());
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
    }
}

