/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v62;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateOrganizationUuidOfUserRoles
extends DataChange {
    private static final String INTERNAL_PROPERTY_DEFAULT_ORGANIZATION = "organization.default";

    public PopulateOrganizationUuidOfUserRoles(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        String organizationUuid = PopulateOrganizationUuidOfUserRoles.selectDefaultOrganizationUuid(context);
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id from user_roles where organization_uuid is null");
        massUpdate.update("update user_roles set organization_uuid=? where id=?");
        massUpdate.rowPluralName("user_roles");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            long id = row.getLong(1);
            update.setString(1, organizationUuid);
            update.setLong(2, id);
            return true;
        });
    }

    private static String selectDefaultOrganizationUuid(DataChange.Context context) throws SQLException {
        Select select = context.prepareSelect("select text_value from internal_properties where kee=?");
        select.setString(1, INTERNAL_PROPERTY_DEFAULT_ORGANIZATION);
        String uuid = select.get(row -> row.getString(1));
        Preconditions.checkState((uuid != null ? 1 : 0) != 0, (Object)"Default organization uuid is missing");
        return uuid;
    }
}

