/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateFileSourceLineCount
extends DataChange {
    private static final int LINE_COUNT_NOT_POPULATED = -1;

    public PopulateFileSourceLineCount(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct project_uuid from file_sources where line_count is null");
        massUpdate.update("update file_sources set line_count = ? where project_uuid = ?").setBatchSize(1);
        massUpdate.rowPluralName("file sources");
        massUpdate.execute(PopulateFileSourceLineCount::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        String projectUuid = row.getString(1);
        update.setInt(1, -1);
        update.setString(2, projectUuid);
        return true;
    }
}

