/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import java.util.Arrays;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;

@SupportsBlueGreen
public class PurgeOrphansForCE
extends DataChange {
    public PurgeOrphansForCE(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        for (String tableName : Arrays.asList("ce_task_characteristics", "ce_task_input", "ce_scanner_context")) {
            this.deleteOrphansFrom(context, tableName);
        }
    }

    private void deleteOrphansFrom(DataChange.Context context, String tableName) throws SQLException {
        String query = this.buildDeleteFromQuery(tableName, "c", "not exists (select 1 from ce_activity ca where ca.uuid = c.task_uuid)and not exists (select 1 from ce_queue cq where cq.uuid = c.task_uuid)");
        context.prepareUpsert(query).execute().commit();
    }

    private String buildDeleteFromQuery(String tableName, String alias, String whereClause) {
        String dialectId = this.getDialect().getId();
        if ("mssql".equals(dialectId) || "mysql".equals(dialectId)) {
            return "delete " + alias + " from " + tableName + " as " + alias + " where " + whereClause;
        }
        return "delete from " + tableName + " " + alias + " where " + whereClause;
    }
}

