/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;

@SupportsBlueGreen
public class CreateApplicationsAndPortfoliosCreatorPermissions
extends DataChange {
    private static final Logger LOG = Loggers.get(CreateApplicationsAndPortfoliosCreatorPermissions.class);
    private static final String DEFAULT_ORGANIZATION_KEY = "default-organization";
    private final System2 system2;

    public CreateApplicationsAndPortfoliosCreatorPermissions(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Long templateId;
        Date now = new Date(this.system2.now());
        Long adminGroupId = ((Select)context.prepareSelect("SELECT id FROM groups WHERE name=?").setString(1, "sonar-administrators")).get(row -> row.getLong(1));
        String templateKey = ((Select)context.prepareSelect("SELECT default_perm_template_view FROM organizations WHERE kee=?").setString(1, DEFAULT_ORGANIZATION_KEY)).get(row -> row.getString(1));
        if (adminGroupId == null) {
            LOG.info("Unable to find {} group. Skipping adding applications and portfolios creator permissions.", (Object)"sonar-administrators");
            return;
        }
        if (templateKey == null) {
            LOG.info("There is no default template for views. Skipping adding applications and portfolios creator permissions.");
        }
        if ((templateId = ((Select)context.prepareSelect("SELECT id FROM permission_templates WHERE kee=?").setString(1, templateKey)).get(row -> row.getLong(1))) == null) {
            LOG.info("Unable to find the default template [{}] for views. Skipping adding applications and portfolios creator permissions.", (Object)templateKey);
            return;
        }
        if (CreateApplicationsAndPortfoliosCreatorPermissions.isPermissionAbsent(context, adminGroupId, "applicationcreator")) {
            CreateApplicationsAndPortfoliosCreatorPermissions.insertPermission(context, adminGroupId, templateId, "applicationcreator", now);
        }
        if (CreateApplicationsAndPortfoliosCreatorPermissions.isPermissionAbsent(context, adminGroupId, "portfoliocreator")) {
            CreateApplicationsAndPortfoliosCreatorPermissions.insertPermission(context, adminGroupId, templateId, "portfoliocreator", now);
        }
    }

    private static boolean isPermissionAbsent(DataChange.Context context, Long groupId, String permission) throws SQLException {
        Long count = ((Select)((Select)context.prepareSelect("SELECT count(*) FROM perm_templates_groups WHERE group_id=? AND permission_reference=?").setLong(1, groupId)).setString(2, permission)).get(row -> row.getLong(1));
        return count == null || count == 0L;
    }

    private static void insertPermission(DataChange.Context context, Long groupId, Long templateId, String permission, Date now) throws SQLException {
        ((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("INSERT INTO perm_templates_groups (group_id, template_id, permission_reference, created_at, updated_at) values (?,?,?,?,?)").setLong(1, groupId)).setLong(2, templateId)).setString(3, permission)).setDate(4, now)).setDate(5, now)).execute().commit();
    }
}

