/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

@Rule(key="S1145")
public class IfConditionalAlwaysTrueOrFalseCheck
implements SlangCheck {
    public static final String MESSAGE_TEMPLATE = "Remove this useless \"%s\" statement.";

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, ifTree) -> {
            Tree condition = ifTree.condition();
            if (IfConditionalAlwaysTrueOrFalseCheck.isAlwaysTrueOrFalse(condition)) {
                String message2 = String.format(MESSAGE_TEMPLATE, ifTree.ifKeyword().text());
                ctx.reportIssue(condition, message2);
            }
        });
    }

    private static boolean isAlwaysTrueOrFalse(Tree originalCondition) {
        Tree condition = ExpressionUtils.skipParentheses(originalCondition);
        return ExpressionUtils.isBooleanLiteral(condition) || ExpressionUtils.isTrueValueLiteral(condition) || ExpressionUtils.isFalseValueLiteral(condition) || IfConditionalAlwaysTrueOrFalseCheck.isSimpleExpressionWithLiteral(condition, BinaryExpressionTree.Operator.CONDITIONAL_AND, ExpressionUtils::isFalseValueLiteral) || IfConditionalAlwaysTrueOrFalseCheck.isSimpleExpressionWithLiteral(condition, BinaryExpressionTree.Operator.CONDITIONAL_OR, ExpressionUtils::isTrueValueLiteral);
    }

    private static boolean isSimpleExpressionWithLiteral(Tree condition, BinaryExpressionTree.Operator operator, Predicate<? super Tree> hasLiteralValue) {
        boolean simpleExpression = ExpressionUtils.isBinaryOperation(condition, operator) && condition.descendants().map(ExpressionUtils::skipParentheses).allMatch(tree -> tree instanceof IdentifierTree || tree instanceof LiteralTree || ExpressionUtils.isNegation(tree) || ExpressionUtils.isBinaryOperation(tree, operator));
        return simpleExpression && condition.descendants().anyMatch(hasLiteralValue);
    }
}

